/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.viewport3d;

import net.modmaker.IO.Settings;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class Camera {
    private float x;
    private float y;
    private float z;
    private float pitch;
    private float yaw;
    private float roll;
    private float px;
    private float py;
    private float pz;
    private float fov;
    private float aspect;
    private float near;
    private float far;

    public Camera(float fov, float aspect, float near, float far) {
        this.fov = fov;
        this.aspect = aspect;
        this.near = near;
        this.far = far;
        this.initProjection();
    }

    private void initProjection() {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GLU.gluPerspective((float)this.fov, (float)this.aspect, (float)this.near, (float)this.far);
        GL11.glMatrixMode((int)5888);
        GL11.glEnable((int)2929);
    }

    public void useView() {
        GL11.glRotatef((float)this.pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)this.yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)this.roll, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)this.x, (float)this.y, (float)this.z);
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getZ() {
        return this.z;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float rx) {
        this.pitch = rx;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setYaw(float ry) {
        this.yaw = ry;
    }

    public float getRoll() {
        return this.roll;
    }

    public void setRz(float rz) {
        this.roll = rz;
    }

    public float getFov() {
        return this.fov;
    }

    public void setFov(float fov) {
        this.fov = fov;
    }

    public float getAspect() {
        return this.aspect;
    }

    public void setAspect(float aspect) {
        this.aspect = aspect;
    }

    public float getNear() {
        return this.near;
    }

    public void setNear(float near) {
        this.near = near;
    }

    public float getFar() {
        return this.far;
    }

    public void setFar(float far) {
        this.far = far;
    }

    public float getPx() {
        return this.px;
    }

    public void setPx(float px) {
        this.px = px;
    }

    public float getPy() {
        return this.py;
    }

    public void setPy(float py) {
        this.py = py;
    }

    public float getPz() {
        return this.pz;
    }

    public void setPz(float pz) {
        this.pz = pz;
    }

    public void move(float amt, float dir) {
        float dz = (float)((double)amt * Math.sin(Math.toRadians(this.yaw + 90.0f * dir)));
        float dx = (float)((double)amt * Math.cos(Math.toRadians(this.yaw + 90.0f * dir)));
        this.z += dz;
        this.pz += dz;
        this.x += dx;
        this.px += dx;
    }

    public void rotateYaw(float amt) {
        this.yaw += amt;
    }

    public void rotatePitch(float amt) {
        this.pitch += amt;
    }

    public void up(float f) {
        this.y -= f;
        this.py -= f;
    }

    public void rotateAround(float amt) {
        float dx = 0.0f;
        float dz = 0.0f;
        if (this.x > this.px) {
            dx = this.x - this.px;
        } else if (this.x < this.px) {
            dx = this.px - this.x;
        }
        if (this.z > this.pz) {
            dz = this.z - this.pz;
        } else if (this.z < this.pz) {
            dz = this.pz - this.z;
        }
        float d = (float)Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dz, 2.0));
        this.yaw += amt;
        float nz = (float)((double)d * Math.sin(Math.toRadians(this.yaw - 90.0f)));
        float nx = (float)((double)d * Math.cos(Math.toRadians(this.yaw - 90.0f)));
        while (this.pitch > 360.0f) {
            this.pitch -= 360.0f;
        }
        while (this.pitch < 0.0f) {
            this.pitch += 360.0f;
        }
        if (this.pitch > 90.0f && this.pitch < 270.0f) {
            this.z = -nz + this.pz;
            this.x = -nx + this.px;
        } else {
            this.z = nz + this.pz;
            this.x = nx + this.px;
        }
    }

    public void rotateOver(float amt) {
        float byaw = this.yaw;
        this.yaw = 0.0f;
        this.rotateAround(0.0f);
        float dy = 0.0f;
        float dz = 0.0f;
        if (this.y > this.py) {
            dy = this.y - this.py;
        } else if (this.y < this.py) {
            dy = this.py - this.y;
        }
        if (this.z > this.pz) {
            dz = this.z - this.pz;
        } else if (this.z < this.pz) {
            dz = this.pz - this.z;
        }
        float d1 = (float)Math.sqrt(Math.pow(dz, 2.0) + Math.pow(dy, 2.0));
        this.pitch -= amt;
        float nz = (float)((double)d1 * Math.cos(Math.toRadians(-this.pitch)));
        float ny = (float)((double)d1 * Math.sin(Math.toRadians(-this.pitch)));
        this.z = -nz + this.pz;
        this.y = ny + this.py;
        this.rotateAround(byaw);
    }

    public void Zoom(float amt) {
        if (amt != 0.0f) {
            float dx = this.x - this.px;
            float dz = this.z - this.pz;
            float dy = this.y - this.py;
            float ndx = dx - dx * amt * 0.1f;
            float ndz = dz - dz * amt * 0.1f;
            float ndy = dy - dy * amt * 0.1f;
            this.x = ndx + this.px;
            this.z = ndz + this.pz;
            this.y = ndy + this.py;
        }
    }

    public void moveCamToHome() {
        this.x = Settings.get("modmaker.viewport.cam.x") != null ? Float.parseFloat(Settings.get("modmaker.viewport.cam.x").toString()) : -3.6283555f;
        this.y = Settings.get("modmaker.viewport.cam.y") != null ? Float.parseFloat(Settings.get("modmaker.viewport.cam.y").toString()) : -4.344484f;
        this.z = Settings.get("modmaker.viewport.cam.z") != null ? Float.parseFloat(Settings.get("modmaker.viewport.cam.z").toString()) : 4.0968213f;
        this.pitch = Settings.get("modmaker.viewport.cam.pitch") != null ? Float.parseFloat(Settings.get("modmaker.viewport.cam.pitch").toString()) : 35.5f;
        this.yaw = Settings.get("modmaker.viewport.cam.yaw") != null ? Float.parseFloat(Settings.get("modmaker.viewport.cam.yaw").toString()) : -139.0f;
        this.roll = Settings.get("modmaker.viewport.cam.roll") != null ? Float.parseFloat(Settings.get("modmaker.viewport.cam.roll").toString()) : 0.0f;
        this.px = Settings.get("modmaker.viewport.cam.px") != null ? Float.parseFloat(Settings.get("modmaker.viewport.cam.px").toString()) : -0.046361618f;
        this.py = Settings.get("modmaker.viewport.cam.py") != null ? Float.parseFloat(Settings.get("modmaker.viewport.cam.py").toString()) : -0.44999996f;
        this.pz = Settings.get("modmaker.viewport.cam.pz") != null ? Float.parseFloat(Settings.get("modmaker.viewport.cam.pz").toString()) : -0.023791961f;
    }

    public void setCurAsHome() {
        Settings.put("modmaker.viewport.cam.x", String.valueOf(this.x));
        Settings.put("modmaker.viewport.cam.y", String.valueOf(this.y));
        Settings.put("modmaker.viewport.cam.z", String.valueOf(this.z));
        Settings.put("modmaker.viewport.cam.pitch", String.valueOf(this.pitch));
        Settings.put("modmaker.viewport.cam.yaw", String.valueOf(this.yaw));
        Settings.put("modmaker.viewport.cam.roll", String.valueOf(this.roll));
        Settings.put("modmaker.viewport.cam.px", String.valueOf(this.px));
        Settings.put("modmaker.viewport.cam.py", String.valueOf(this.py));
        Settings.put("modmaker.viewport.cam.pz", String.valueOf(this.pz));
    }
}

