/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.viewport3d;

import java.io.File;
import java.util.ArrayList;
import java.util.regex.Pattern;
import net.modmaker.Console.Console;
import net.modmaker.IO.ClassObject;
import net.modmaker.IO.ClassReader;
import net.modmaker.IO.MethodeObject;
import net.modmaker.IO.VariableObject;
import net.modmaker.viewport3d.ModelBase;
import net.modmaker.viewport3d.ModelRenderer;

public class ModelIO {
    private static String[] renderParms = new String[]{"Entity", "float", "float", "float", "float", "float", "float"};

    public static ModelBase importModel(File file) throws Exception {
        ModelBase model = new ModelBase();
        ClassReader reader = new ClassReader(file);
        reader.analizeClass();
        ClassObject cls = reader.getClassObject();
        if (cls.getExtends() == null) {
            throw new NullPointerException("No ModelBase Extensions");
        }
        if (cls.getExtends().equals("ModelBase")) {
            ModelIO.readModel(cls, model);
        } else {
            ClassObject parent = ModelIO.findParent(cls, file);
            if (parent == null) {
                throw new NullPointerException("No ModelBase Extensions");
            }
            if (parent.getExtends() == null) {
                throw new NullPointerException("No ModelBase Extensions");
            }
            if (parent.getExtends().equals("ModelBase")) {
                ModelIO.readModel(parent, model);
                ModelIO.readModel(cls, model);
            } else {
                throw new NullPointerException("No ModelBase Extensions");
            }
        }
        return model;
    }

    private static void readModel(ClassObject cls, ModelBase model) {
        ArrayList<ModelRenderer> models = new ArrayList<ModelRenderer>();
        ArrayList<ModelRenderer> childModels = new ArrayList<ModelRenderer>();
        for (VariableObject var : cls.getVariables()) {
            String name = var.getName();
            String type = var.getType();
            if (!type.equals("ModelRenderer")) continue;
            for (ModelRenderer blk : models) {
                if (!blk.boxName.equals(name)) continue;
            }
            models.add(new ModelRenderer(model, name));
            Console.Info("new ModelRender: " + name);
        }
        for (MethodeObject con : cls.getConstructor()) {
            String code = con.getCode().replace("\r", "").replaceAll("this.", "");
            String[] lines = code.split("\n");
            int row = 0;
            for (String line : lines) {
                ++row;
                try {
                    Object[] flt;
                    String[] split;
                    String pre;
                    String[] parms;
                    String value;
                    while (line.startsWith(" ")) {
                        line = line.substring(1);
                    }
                    while (line.endsWith(" ")) {
                        line = line.substring(0, line.length() - 1);
                    }
                    if (line.startsWith("textureWidth")) {
                        if (!line.contains("=")) continue;
                        value = line.split("=")[1];
                        while (value.startsWith(" ")) {
                            value = value.substring(1);
                        }
                        while (value.endsWith(" ")) {
                            value = value.substring(0, value.length() - 1);
                        }
                        if (value.endsWith(";")) {
                            value = value.substring(0, value.length() - 1);
                        }
                        model.textureWidth = Integer.parseInt(value);
                        Console.Info("textureWidth = " + model.textureWidth);
                        continue;
                    }
                    if (line.startsWith("textureHeight")) {
                        if (!line.contains("=")) continue;
                        value = line.split("=")[1];
                        while (value.startsWith(" ")) {
                            value = value.substring(1);
                        }
                        while (value.endsWith(" ")) {
                            value = value.substring(0, value.length() - 1);
                        }
                        if (value.endsWith(";")) {
                            value = value.substring(0, value.length() - 1);
                        }
                        model.textureHeight = Integer.parseInt(value);
                        Console.Info("textureHeight = " + model.textureHeight);
                        continue;
                    }
                    if (line.startsWith("ModelRenderer ")) {
                        if (line.contains("=")) {
                            String begin = line.split("=")[0];
                            String end = line.split("=")[1];
                            String[] split2 = begin.split(" ");
                            String name = split2[1];
                            ModelRenderer m = new ModelRenderer(model, name);
                            if (end.contains("new ModelRenderer(")) {
                                if (end.endsWith(";")) {
                                    end = end.substring(0, end.length() - 1);
                                }
                                while (end.endsWith(" ")) {
                                    end = end.substring(0, end.length() - 1);
                                }
                                String parm = end.split(Pattern.quote("("))[1];
                                if (!parm.equals(")") && (parms = (parm = parm.split(Pattern.quote(")"))[0]).split(",")).length == 3) {
                                    int w = 0;
                                    int h = 0;
                                    for (int a = 1; a < parms.length; ++a) {
                                        while (parms[a].startsWith(" ")) {
                                            parms[a] = parms[a].substring(1);
                                        }
                                        while (parms[a].endsWith(" ")) {
                                            parms[a] = parms[a].substring(0, parms[a].length() - 1);
                                        }
                                        try {
                                            if (a == 1) {
                                                w = Integer.parseInt(parms[a]);
                                            }
                                            if (a != 2) continue;
                                            h = Integer.parseInt(parms[a]);
                                            continue;
                                        }
                                        catch (Throwable e) {
                                            Console.Warning("Unknown value for " + name + " textureOffset " + (a == 1 ? "h" : (a == 2 ? "w" : "")) + " = " + parms[a]);
                                        }
                                    }
                                    m.setTextureOffset(w, h);
                                }
                            } else {
                                Console.Warning("Unknown ModelRenderer: " + end);
                            }
                            childModels.add(m);
                            Console.Info("new ChildModelRender: " + m.boxName);
                            continue;
                        }
                        String[] split3 = line.split(" ");
                        if (split3.length < 2) continue;
                        childModels.add(new ModelRenderer(model, split3[1]));
                        Console.Info("new ChildModelRender: " + split3[0]);
                        continue;
                    }
                    if (line == null && "".equals(line)) continue;
                    String name = null;
                    String var = null;
                    if (line.contains("=")) {
                        int a;
                        pre = line.split("=")[0];
                        String end = line.split("=")[1];
                        while (pre.startsWith(" ")) {
                            pre = pre.substring(1);
                        }
                        while (pre.endsWith(" ")) {
                            pre = pre.substring(0, pre.length() - 1);
                        }
                        if (end.endsWith(";")) {
                            end = end.substring(0, end.length() - 1);
                        }
                        while (end.startsWith(" ")) {
                            end = end.substring(1);
                        }
                        while (end.endsWith(" ")) {
                            end = end.substring(0, end.length() - 1);
                        }
                        if (pre.contains(".")) {
                            split = pre.split(Pattern.quote("."));
                            name = split[0];
                            var = split[1];
                            ModelRenderer mr = null;
                            for (ModelRenderer m : models) {
                                if (!m.boxName.equals(name)) continue;
                                mr = m;
                                break;
                            }
                            if (mr == null) {
                                for (ModelRenderer m : childModels) {
                                    if (!m.boxName.equals(name)) continue;
                                    mr = m;
                                    break;
                                }
                            }
                            if (mr == null) {
                                throw new NullPointerException("Unknown variable name: " + name);
                            }
                            if (var.equals("textureWidth")) {
                                float value2;
                                mr.textureWidth = value2 = Float.parseFloat(end);
                                continue;
                            }
                            if (var.equals("textureHeight")) {
                                float value3;
                                mr.textureHeight = value3 = Float.parseFloat(end);
                                continue;
                            }
                            if (var.equals("rotationPointX")) {
                                float value4;
                                mr.rotationPointX = value4 = Float.parseFloat(end);
                                continue;
                            }
                            if (var.equals("rotationPointY")) {
                                float value5;
                                mr.rotationPointY = value5 = Float.parseFloat(end);
                                continue;
                            }
                            if (var.equals("rotationPointZ")) {
                                float value6;
                                mr.rotationPointZ = value6 = Float.parseFloat(end);
                                continue;
                            }
                            if (var.equals("rotateAngleX")) {
                                float value7;
                                mr.rotateAngleX = value7 = Float.parseFloat(end);
                                continue;
                            }
                            if (var.equals("rotateAngleY")) {
                                float value8;
                                mr.rotateAngleY = value8 = Float.parseFloat(end);
                                continue;
                            }
                            if (var.equals("rotateAngleZ")) {
                                float value9;
                                mr.rotateAngleZ = value9 = Float.parseFloat(end);
                                continue;
                            }
                            if (var.equals("mirror")) {
                                boolean value10;
                                mr.mirror = value10 = Boolean.parseBoolean(end);
                                continue;
                            }
                            if (var.equals("showModel")) {
                                boolean value11;
                                mr.showModel = value11 = Boolean.parseBoolean(end);
                                continue;
                            }
                            if (var.equals("isHidden")) {
                                boolean value12;
                                mr.isHidden = value12 = Boolean.parseBoolean(end);
                                continue;
                            }
                            if (var.equals("field_82906_o")) {
                                float value13;
                                mr.field_82906_o = value13 = Float.parseFloat(end);
                                continue;
                            }
                            if (var.equals("field_82908_p")) {
                                float value14;
                                mr.field_82908_p = value14 = Float.parseFloat(end);
                                continue;
                            }
                            if (var.equals("field_82907_q")) {
                                float value15;
                                mr.field_82907_q = value15 = Float.parseFloat(end);
                                continue;
                            }
                            Console.Warning("Cannot resolve in ModelRenderer " + name + ": " + var);
                            continue;
                        }
                        name = pre;
                        boolean local = true;
                        for (a = 0; a < models.size(); ++a) {
                            if (!((ModelRenderer)models.get((int)a)).boxName.equals(name)) continue;
                            models.remove(a);
                            local = false;
                        }
                        for (a = 0; a < childModels.size(); ++a) {
                            if (!((ModelRenderer)childModels.get((int)a)).boxName.equals(name)) continue;
                            childModels.remove(a);
                        }
                        if (end.contains("new ModelRenderer(")) {
                            String[] parms2;
                            ModelRenderer mr = new ModelRenderer(model, name);
                            if (local) {
                                childModels.add(mr);
                            } else {
                                models.add(mr);
                            }
                            if (end.endsWith(";")) {
                                end = end.substring(0, end.length() - 1);
                            }
                            while (end.endsWith(" ")) {
                                end = end.substring(0, end.length() - 1);
                            }
                            String parm = end.split(Pattern.quote("("))[1];
                            if (parm.equals(")") || (parms2 = (parm = parm.split(Pattern.quote(")"))[0]).split(",")).length != 3) continue;
                            int w = 0;
                            int h = 0;
                            for (int a2 = 1; a2 < parms2.length; ++a2) {
                                while (parms2[a2].startsWith(" ")) {
                                    parms2[a2] = parms2[a2].substring(1);
                                }
                                while (parms2[a2].endsWith(" ")) {
                                    parms2[a2] = parms2[a2].substring(0, parms2[a2].length() - 1);
                                }
                                try {
                                    if (a2 == 1) {
                                        w = Integer.parseInt(parms2[a2]);
                                    }
                                    if (a2 != 2) continue;
                                    h = Integer.parseInt(parms2[a2]);
                                    continue;
                                }
                                catch (Throwable e) {
                                    Console.Warning("Unknown value for " + name + " textureOffset " + (a2 == 1 ? "h" : (a2 == 2 ? "w" : "")) + " = " + parms2[a2]);
                                }
                            }
                            mr.setTextureOffset(w, h);
                            continue;
                        }
                        Console.Warning("Unknown ModelRenderer: " + end);
                        continue;
                    }
                    if (!line.contains("(") || !line.contains(")")) continue;
                    pre = line.split(Pattern.quote("("))[0];
                    String parm = line.split(Pattern.quote("("))[1];
                    while (pre.startsWith(" ")) {
                        pre = pre.substring(1);
                    }
                    while (pre.endsWith(" ")) {
                        pre = pre.substring(0, pre.length() - 1);
                    }
                    if (parm.endsWith(";")) {
                        parm = parm.substring(0, parm.length() - 1);
                    }
                    while (parm.startsWith(" ")) {
                        parm = parm.substring(1);
                    }
                    while (parm.endsWith(" ")) {
                        parm = parm.substring(0, parm.length() - 1);
                    }
                    if (!pre.contains(".")) continue;
                    split = pre.split(Pattern.quote("."));
                    name = split[0];
                    var = split[1];
                    ArrayList<String> prms = new ArrayList<String>();
                    if (!parm.equals(")")) {
                        if ((parm = parm.split(Pattern.quote(")"))[0]).contains(",")) {
                            for (String str : parms = parm.split(",")) {
                                while (str.endsWith(" ")) {
                                    str = str.substring(0, str.length() - 1);
                                }
                                while (str.startsWith(" ")) {
                                    str = str.substring(1);
                                }
                                prms.add(str);
                            }
                        } else {
                            prms.add(parm);
                        }
                    }
                    ModelRenderer mr = null;
                    for (ModelRenderer m : models) {
                        if (!m.boxName.equals(name)) continue;
                        mr = m;
                        break;
                    }
                    if (mr == null) {
                        for (ModelRenderer m : childModels) {
                            if (!m.boxName.equals(name)) continue;
                            mr = m;
                            break;
                        }
                    }
                    if (mr == null) {
                        throw new NullPointerException("Unknown variable name: " + name);
                    }
                    if (var.equals("addChild") && prms.size() == 1) {
                        mr.addChild(ModelIO.getModelRenderer((String)prms.get(0), models, childModels));
                        continue;
                    }
                    if (var.equals("setTextureOffset") && prms.size() == 2) {
                        int w = 0;
                        int h = 0;
                        try {
                            w = Integer.parseInt((String)prms.get(0));
                        }
                        catch (Throwable e) {
                            Console.Warning("Unknown parameter: " + (String)prms.get(0) + " replaced by: 0");
                        }
                        try {
                            h = Integer.parseInt((String)prms.get(1));
                        }
                        catch (Throwable e) {
                            Console.Warning("Unknown parameter: " + (String)prms.get(0) + " replaced by: 0");
                        }
                        mr.setTextureOffset(w, h);
                        continue;
                    }
                    if (var.equals("addBox") && prms.size() == 7) {
                        String par1 = (String)prms.get(0);
                        float[] flt2 = new float[3];
                        int[] in = new int[3];
                        for (int a = 1; a < prms.size(); ++a) {
                            try {
                                if (a > 3) {
                                    in[a - 4] = Integer.parseInt((String)prms.get(a));
                                    continue;
                                }
                                flt2[a - 1] = Float.parseFloat((String)prms.get(a));
                                continue;
                            }
                            catch (Throwable e) {
                                Console.Warning("Unknown parameter: " + (String)prms.get(a) + " replaced by: 1");
                                if (a > 3) {
                                    in[a - 4] = 1;
                                    continue;
                                }
                                flt2[a - 1] = 1.0f;
                            }
                        }
                        mr.addBox(par1, flt2[0], flt2[1], flt2[2], in[0], in[1], in[2]);
                        continue;
                    }
                    if (var.equals("addBox") && prms.size() == 6) {
                        flt = new float[3];
                        int[] in = new int[3];
                        for (int a = 0; a < prms.size(); ++a) {
                            try {
                                if (a > 2) {
                                    in[a - 3] = Integer.parseInt((String)prms.get(a));
                                    continue;
                                }
                                flt[a] = Float.parseFloat((String)prms.get(a));
                                continue;
                            }
                            catch (Throwable e) {
                                Console.Warning("Unknown parameter: " + (String)prms.get(a) + " replaced by: 1");
                                if (a > 2) {
                                    in[a - 3] = 1;
                                    continue;
                                }
                                flt[a] = 1.0f;
                            }
                        }
                        mr.addBox(flt[0], flt[1], flt[2], in[0], in[1], in[2]);
                        continue;
                    }
                    if (var.equals("addBox") && prms.size() == 7) {
                        flt = new float[4];
                        int[] in = new int[3];
                        for (int a = 0; a < prms.size(); ++a) {
                            try {
                                if (a > 2) {
                                    in[a - 3] = Integer.parseInt((String)prms.get(a));
                                    continue;
                                }
                                if (a < 3) {
                                    flt[a] = Float.parseFloat((String)prms.get(a));
                                    continue;
                                }
                                flt[3] = Float.parseFloat((String)prms.get(a));
                                continue;
                            }
                            catch (Throwable e) {
                                Console.Warning("Unknown parameter: " + (String)prms.get(a) + " replaced by: 1");
                                if (a > 2) {
                                    in[a - 3] = 1;
                                    continue;
                                }
                                if (a < 3) {
                                    flt[a] = 1.0f;
                                    continue;
                                }
                                flt[3] = 1.0f;
                            }
                        }
                        mr.addBox(flt[0], flt[1], flt[2], in[0], in[1], in[2], flt[3]);
                        continue;
                    }
                    if (var.equals("setRotationPoint") && prms.size() == 3) {
                        flt = new float[3];
                        for (int a = 0; a < prms.size(); ++a) {
                            try {
                                flt[a] = Float.parseFloat((String)prms.get(a));
                                continue;
                            }
                            catch (Throwable e) {
                                Console.Warning("Unknown parameter: " + (String)prms.get(a) + " replaced by: 0");
                                flt[a] = 0.0f;
                            }
                        }
                        mr.setRotationPoint(flt[0], flt[1], flt[2]);
                        continue;
                    }
                    if (!var.equals("setTextureSize") || prms.size() != 2) continue;
                    flt = new int[2];
                    for (int a = 0; a < prms.size(); ++a) {
                        try {
                            flt[a] = Integer.parseInt((String)prms.get(a));
                            continue;
                        }
                        catch (Throwable e) {
                            Console.Warning("Unknown parameter: " + (String)prms.get(a) + " replaced by: 1");
                            flt[a] = 1.0f;
                        }
                    }
                    mr.setTextureSize((int)flt[0], (int)flt[1]);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    Console.Warning("Error in line " + row + ": " + e.getMessage());
                }
            }
        }
    }

    private static ModelRenderer getModelRenderer(String name, ArrayList<ModelRenderer> models, ArrayList<ModelRenderer> childModels) {
        ModelRenderer mr = null;
        for (ModelRenderer m : models) {
            if (!m.boxName.equals(name)) continue;
            mr = m;
            break;
        }
        if (mr == null) {
            for (ModelRenderer m : childModels) {
                if (!m.boxName.equals(name)) continue;
                mr = m;
                break;
            }
        }
        if (mr == null) {
            throw new NullPointerException("Unknown variable name: " + name);
        }
        return mr;
    }

    private static ClassObject findParent(ClassObject cls, File file) throws Exception {
        String extend = cls.getExtends();
        File[] listFile = file.getParentFile().listFiles();
        ClassObject parent = null;
        if (listFile != null) {
            for (File f : listFile) {
                if (!f.getName().endsWith(".java") || !f.getName().substring(0, ".java".length()).equals(extend)) continue;
                ClassReader r = new ClassReader(f);
                r.analizeClass();
                parent = r.getClassObject();
                return parent;
            }
        }
        String[] childSplit = cls.getPackage().split(Pattern.quote("."));
        File root = file.getParentFile();
        for (int a = 0; a < childSplit.length; ++a) {
            root = root.getParentFile();
        }
        if (parent == null) {
            for (String im : cls.getImports()) {
                File javaFile;
                if (!im.contains(".")) continue;
                String[] split = im.split(Pattern.quote("."));
                if (split[split.length - 1].endsWith("*")) {
                    File pack = new File(root + "/" + im.replace(".", "/"));
                    File[] listFile2 = pack.listFiles();
                    if (listFile2 == null) continue;
                    for (File f : listFile2) {
                        if (!f.getName().endsWith(".java") || !f.getName().substring(0, ".java".length()).equals(extend)) continue;
                        ClassReader r = new ClassReader(f);
                        r.analizeClass();
                        parent = r.getClassObject();
                        return parent;
                    }
                    continue;
                }
                if (!split[split.length - 1].endsWith(extend) || !(javaFile = new File(root + "/" + im.replace(".", "/") + ".java")).exists()) continue;
                ClassReader r = new ClassReader(javaFile);
                r.analizeClass();
                parent = r.getClassObject();
                return parent;
            }
        }
        return parent;
    }

    public static void main(String[] args) throws Exception {
        ModelBase mb = ModelIO.importModel(new File("C:\\Program Files\\Deathly's Mod Editor\\MCP\\forge\\mcp\\src\\minecraft\\net\\minecraft\\client\\model\\ModelBat.java"));
    }
}

