/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.viewport3d;

import java.awt.Color;
import java.awt.image.BufferedImage;

public class Texture {
    private final BufferedImage image;
    private final Color textureColor;
    private int textureOffsetX = 0;
    private int textureOffsetY = 0;

    public Texture(BufferedImage image) {
        this.image = image;
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 0;
        int count = 0;
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                ++count;
                Color c = new Color(image.getRGB(x, y));
                r += c.getRed();
                g += c.getGreen();
                b += c.getBlue();
                a += c.getAlpha();
            }
        }
        this.textureColor = new Color(r / count, g / count, b / count, a / count);
    }

    public BufferedImage getImage(int h, int w) {
        if (this.image == null) {
            return null;
        }
        return this.image.getSubimage(this.textureOffsetX, this.textureOffsetY, w, h);
    }

    public Color getTextureColor() {
        return this.textureColor;
    }

    public BufferedImage getImage(float h, float w) {
        if (this.image == null) {
            return null;
        }
        return this.image.getSubimage(this.textureOffsetX, this.textureOffsetY, (int)w, (int)h);
    }
}

