/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.viewport3d;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import net.modmaker.Console.Console;
import net.modmaker.events.Listeners.RenderListener;
import net.modmaker.viewport3d.Block;
import net.modmaker.viewport3d.Camera;
import net.modmaker.viewport3d.Texture;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;

public final class ViewPort
extends JPanel {
    private Canvas canvas1;
    private JButton jButton1;
    private JButton jButton2;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JPanel optionsPanel;
    private static ViewPort vp;
    private static boolean start;
    private static boolean stop;
    private static Camera cam;
    private static ArrayList<Block> blocks;
    private static ArrayList<RenderListener> listeners;
    private static int gridColor;
    private static boolean isInit;

    private ViewPort() throws Exception {
        if (vp != null) {
            throw new Exception("ViewPort is already initiallized");
        }
        vp = this;
        this.initComponents();
    }

    public void hideOptionsPanel(boolean hide) {
        this.optionsPanel.setVisible(!hide);
    }

    public static ViewPort getViewPort() {
        return vp;
    }

    public void start() {
        start = true;
        stop = false;
    }

    public void stop() {
        stop = true;
        start = false;
    }

    public Camera getCamera() {
        return cam;
    }

    public ArrayList<Block> getBlocks() {
        return blocks;
    }

    public void setBlocks(ArrayList<Block> blocks) {
        ViewPort.blocks = blocks;
    }

    private void camMove() {
        String xt = String.valueOf(cam.getPx());
        while (xt.length() > 4) {
            xt = xt.substring(0, xt.length() - 1);
        }
        String yt = String.valueOf(cam.getPy());
        while (yt.length() > 4) {
            yt = yt.substring(0, yt.length() - 1);
        }
        String zt = String.valueOf(cam.getPz());
        while (zt.length() > 4) {
            zt = zt.substring(0, zt.length() - 1);
        }
        String text = "X: " + xt + " Y: " + yt + " Z: " + zt;
        this.jLabel9.setText(text);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.canvas1 = new Canvas();
        this.optionsPanel = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jCheckBox2 = new JCheckBox();
        this.jButton1 = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jCheckBox3 = new JCheckBox();
        this.jSeparator2 = new JSeparator();
        this.jPanel3 = new JPanel();
        this.jLabel9 = new JLabel();
        this.jButton2 = new JButton();
        this.setBackground(new Color(100, 100, 100));
        this.jPanel1.setBackground(new Color(100, 100, 100));
        this.jPanel1.setLayout(null);
        this.canvas1.setBackground(new Color(0, 0, 0));
        this.jPanel1.add(this.canvas1);
        this.canvas1.setBounds(0, 0, 540, 470);
        this.optionsPanel.setBackground(new Color(100, 100, 100));
        this.jCheckBox1.setSelected(true);
        this.jCheckBox1.setText("Show Small Grid");
        this.jCheckBox1.setOpaque(false);
        this.jLabel1.setText("Controls:");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Gamemode", "ViewPort"}));
        this.jComboBox1.setSelectedIndex(1);
        this.jComboBox1.setBorder(null);
        this.jComboBox1.setOpaque(false);
        this.jLabel2.setFont(new Font("Tahoma", 0, 12));
        this.jLabel2.setText("Viewport Options");
        this.jCheckBox2.setSelected(true);
        this.jCheckBox2.setText("Show Textures");
        this.jCheckBox2.setOpaque(false);
        this.jButton1.setText("Set new home for the camera");
        this.jButton1.setOpaque(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewPort.this.jButton1ActionPerformed(evt);
            }
        });
        this.jSeparator1.setBackground(new Color(100, 100, 100));
        this.jSeparator1.setForeground(new Color(51, 51, 51));
        this.jCheckBox3.setSelected(true);
        this.jCheckBox3.setText("Show Big Grid");
        this.jCheckBox3.setOpaque(false);
        this.jSeparator2.setBackground(new Color(100, 100, 100));
        this.jSeparator2.setForeground(new Color(51, 51, 51));
        GroupLayout optionsPanelLayout = new GroupLayout(this.optionsPanel);
        this.optionsPanel.setLayout(optionsPanelLayout);
        optionsPanelLayout.setHorizontalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator2, -2, 196, -2).addComponent(this.jSeparator1, -2, 196, -2).addComponent(this.jCheckBox3).addComponent(this.jCheckBox2).addComponent(this.jCheckBox1).addComponent(this.jButton1).addGroup(optionsPanelLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, 148, -2))).addContainerGap()));
        optionsPanelLayout.setVerticalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBox1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addContainerGap(321, Short.MAX_VALUE)));
        this.jLabel9.setText("X: 1.5  Y: -5.4  Z: 13.7");
        this.jButton2.setText("Home");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewPort.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 363, Short.MAX_VALUE).addComponent(this.jLabel9).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jButton2, -2, 14, -2))));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.optionsPanel, -2, -1, -2).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.optionsPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            if (cam != null) {
                cam.setCurAsHome();
            }
        }
        catch (Throwable e) {
            Console.Err(e);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        try {
            if (cam != null) {
                cam.moveCamToHome();
            }
        }
        catch (Throwable e) {
            Console.Err(e);
        }
    }

    public static void Initialize() {
        if (isInit) {
            throw new RuntimeException("Is already initialized!");
        }
        isInit = true;
        Thread viewPortThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Console.Info("Initialize Viewport");
                    new ViewPort();
                    ViewPort.ViewPortLoop();
                }
                catch (Exception ex) {
                    Console.Err(ex);
                }
            }
        });
        viewPortThread.setName("ViewPort Thread");
        viewPortThread.start();
    }

    private static void ViewPortLoop() {
        try {
            while (true) {
                if (start) {
                    start = false;
                    try {
                        Display.setParent((Canvas)ViewPort.vp.canvas1);
                        Display.create((PixelFormat)new PixelFormat().withDepthBits(24));
                        Mouse.create();
                        GL11.glEnable((int)3042);
                        GL11.glEnable((int)2929);
                        GL11.glBlendFunc((int)770, (int)771);
                        GL11.glViewport((int)0, (int)0, (int)ViewPort.vp.canvas1.getWidth(), (int)ViewPort.vp.canvas1.getHeight());
                        cam = new Camera(70.0f, (float)Display.getWidth() / (float)Display.getHeight(), 0.3f, 1000.0f);
                        cam.moveCamToHome();
                        while (!Display.isCloseRequested()) {
                            long startTime = System.currentTimeMillis();
                            if (Display.getDisplayMode().getWidth() != ViewPort.vp.jPanel1.getWidth() || Display.getDisplayMode().getHeight() != ViewPort.vp.jPanel1.getHeight()) {
                                Console.Info("Resize");
                                ViewPort.vp.canvas1.setSize(ViewPort.vp.jPanel1.getSize());
                                Display.setDisplayMode((DisplayMode)new DisplayMode(ViewPort.vp.canvas1.getWidth(), ViewPort.vp.canvas1.getHeight()));
                                cam.setAspect((float)Display.getWidth() / (float)Display.getHeight());
                            }
                            ViewPort.Render();
                            try {
                                long timePassed = System.currentTimeMillis() - startTime;
                                if (timePassed < 20L) {
                                    Thread.sleep(20L - timePassed);
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            if (!stop) continue;
                            stop = false;
                            break;
                        }
                    }
                    catch (Throwable e) {
                        Console.Err(e);
                    }
                    Display.destroy();
                }
                try {
                    Thread.sleep(20L);
                }
                catch (Throwable e) {
                    Console.Err(e);
                }
            }
        }
        catch (Throwable e) {
            Console.Err(e);
            return;
        }
    }

    private static void Render() {
        vp.controlls();
        GL11.glClear((int)16640);
        GL11.glLoadIdentity();
        cam.useView();
        GL11.glPushMatrix();
        GL11.glBegin((int)7);
        for (Block block : blocks) {
            block.draw(ViewPort.vp.jCheckBox2.isSelected());
        }
        for (RenderListener rl : listeners) {
            try {
                rl.render();
            }
            catch (Throwable e) {
                Console.Err(e);
            }
        }
        ViewPort.drawGrid();
        GL11.glEnd();
        GL11.glPopMatrix();
        Display.update();
    }

    private static void drawGrid() {
        int i;
        GL11.glColor4f((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f);
        int x = (int)cam.getPx();
        int z = (int)cam.getPz();
        int gridSize = 20;
        int lGridSize = 100;
        GL11.glBindTexture((int)3553, (int)gridColor);
        if (ViewPort.vp.jCheckBox1.isSelected()) {
            for (i = x - gridSize; i < x + gridSize + 1; ++i) {
                GL11.glTexCoord2f((float)0.0f, (float)0.0f);
                GL11.glVertex3f((float)((float)(-i) - 0.01f), (float)0.0f, (float)(-z - gridSize));
                GL11.glTexCoord2f((float)0.0f, (float)1.0f);
                GL11.glVertex3f((float)((float)(-i) - 0.01f), (float)0.0f, (float)(-z + gridSize));
                GL11.glTexCoord2f((float)1.0f, (float)1.0f);
                GL11.glVertex3f((float)((float)(-i) + 0.01f), (float)0.0f, (float)(-z + gridSize));
                GL11.glTexCoord2f((float)1.0f, (float)0.0f);
                GL11.glVertex3f((float)((float)(-i) + 0.01f), (float)0.0f, (float)(-z - gridSize));
            }
            for (i = z - gridSize; i < z + gridSize + 1; ++i) {
                GL11.glVertex3f((float)(-x - gridSize), (float)0.0f, (float)((float)(-i) - 0.01f));
                GL11.glVertex3f((float)(-x - gridSize), (float)0.0f, (float)((float)(-i) + 0.01f));
                GL11.glVertex3f((float)(-x + gridSize), (float)0.0f, (float)((float)(-i) + 0.01f));
                GL11.glVertex3f((float)(-x + gridSize), (float)0.0f, (float)((float)(-i) - 0.01f));
            }
        }
        if (ViewPort.vp.jCheckBox3.isSelected()) {
            for (i = -lGridSize; i < lGridSize + 10; i += 10) {
                GL11.glVertex3f((float)((float)i - 0.1f), (float)0.0f, (float)(-lGridSize));
                GL11.glVertex3f((float)((float)i - 0.1f), (float)0.0f, (float)lGridSize);
                GL11.glVertex3f((float)((float)i + 0.1f), (float)0.0f, (float)lGridSize);
                GL11.glVertex3f((float)((float)i + 0.1f), (float)0.0f, (float)(-lGridSize));
            }
            for (i = -lGridSize; i < lGridSize + 10; i += 10) {
                GL11.glVertex3f((float)lGridSize, (float)0.0f, (float)((float)i - 0.1f));
                GL11.glVertex3f((float)lGridSize, (float)0.0f, (float)((float)i + 0.1f));
                GL11.glVertex3f((float)(-lGridSize), (float)0.0f, (float)((float)i + 0.1f));
                GL11.glVertex3f((float)(-lGridSize), (float)0.0f, (float)((float)i - 0.1f));
            }
        }
        GL11.glDeleteTextures((int)gridColor);
    }

    public static void addRenderListener(RenderListener rl) {
        listeners.add(rl);
    }

    public static void removeRenderListener(RenderListener rl) {
        listeners.remove(rl);
    }

    private void controlls() {
        if (cam != null) {
            if (this.jComboBox1.getSelectedIndex() == 0) {
                if (Keyboard.isKeyDown((int)17)) {
                    cam.move(0.1f, 1.0f);
                }
                if (Keyboard.isKeyDown((int)31)) {
                    cam.move(-0.1f, 1.0f);
                }
                if (Keyboard.isKeyDown((int)30)) {
                    cam.move(0.1f, 0.0f);
                }
                if (Keyboard.isKeyDown((int)32)) {
                    cam.move(-0.1f, 0.0f);
                }
                if (Keyboard.isKeyDown((int)57)) {
                    cam.up(0.1f);
                }
                if (Keyboard.isKeyDown((int)29)) {
                    cam.up(-0.1f);
                }
                cam.move(0.01f * (float)Mouse.getDWheel(), 1.0f);
                int rot = Mouse.getDX();
                if (Mouse.isButtonDown((int)0)) {
                    cam.rotateYaw((float)rot * 0.5f);
                }
                rot = Mouse.getDY();
                if (Mouse.isButtonDown((int)0)) {
                    cam.rotatePitch((float)(-rot) * 0.5f);
                }
            } else {
                cam.Zoom(0.01f * (float)Mouse.getDWheel());
                int rot = Mouse.getDX();
                if (Mouse.isButtonDown((int)0)) {
                    cam.rotateAround((float)rot * 0.5f);
                } else if (Mouse.isButtonDown((int)2)) {
                    cam.move((float)rot * 0.01f, 0.0f);
                }
                rot = Mouse.getDY();
                if (Mouse.isButtonDown((int)0)) {
                    cam.rotateOver((float)rot * 0.5f);
                } else if (Mouse.isButtonDown((int)2)) {
                    cam.up((float)(-rot) * 0.01f);
                } else if (Mouse.isButtonDown((int)1)) {
                    cam.Zoom((float)rot * 0.1f);
                }
                if (Keyboard.isKeyDown((int)17)) {
                    cam.moveCamToHome();
                }
            }
            vp.camMove();
        }
    }

    public static void main(String[] args) throws Exception {
        ViewPort.Initialize();
        Console.Info("Start");
        JFrame f = new JFrame("test window");
        f.setDefaultCloseOperation(3);
        f.setBounds(0, 0, 1500, 1000);
        Console.Info("Start0");
        f.setLayout(new BorderLayout());
        Console.Info("Start2");
        ViewPort v = ViewPort.getViewPort();
        v.setBounds(0, 0, 1500, 1000);
        Console.Info("Start3");
        f.add((Component)v, "Center");
        f.setResizable(false);
        f.setVisible(true);
        Block blk = new Block("test Block");
        blocks.add(blk);
        blk.setY(0.0f);
        blk.setW(1.0f);
        blk.setH(1.0f);
        blk.setD(1.0f);
        blk.setBackground(0.0f, 1.0f, 1.0f, 1.0f);
        Console.Info("Load");
        blk.setTexture(new Texture(ImageIO.read(blk.getClass().getResourceAsStream("/net/modmaker/viewport3d/image_0.png"))), 0);
        blk.setTexture(new Texture(ImageIO.read(blk.getClass().getResourceAsStream("/net/modmaker/viewport3d/image_1.png"))), 1);
        blk.setTexture(new Texture(ImageIO.read(blk.getClass().getResourceAsStream("/net/modmaker/viewport3d/image_2.png"))), 2);
        blk.setTexture(new Texture(ImageIO.read(blk.getClass().getResourceAsStream("/net/modmaker/viewport3d/image_3.png"))), 3);
        blk.setTexture(new Texture(ImageIO.read(blk.getClass().getResourceAsStream("/net/modmaker/viewport3d/image_4.png"))), 4);
        blk.setTexture(new Texture(ImageIO.read(blk.getClass().getResourceAsStream("/net/modmaker/viewport3d/image_5.png"))), 5);
        Console.Info("Load Done");
        vp.hideOptionsPanel(true);
        v.start();
    }

    static {
        blocks = new ArrayList();
        listeners = new ArrayList();
        gridColor = -1;
        isInit = false;
    }
}

