/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.launcher;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import net.modmaker.launcher.IOPanel;

public class DMELauncher {
    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Windows".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            JOptionPane.showMessageDialog(null, "Something went wrong with the UI:\n\n" + sw.toString());
        }
        try {
            File ini;
            String ln;
            File rt = new File("").getAbsoluteFile();
            File lib = new File(rt.getPath() + "/lib");
            File dme = null;
            File[] rList = rt.listFiles();
            File[] lList = lib.listFiles();
            if (lList != null && lList.length > 0) {
                for (File file : lList) {
                    if (!file.getName().toLowerCase().endsWith(".jar") || !(ln = file.getName().toLowerCase()).contains("deathly") || !ln.contains("mod") || !ln.contains("editor") || ln.contains("launcher") || file.length() <= 26624L) continue;
                    dme = file;
                    break;
                }
            }
            if (rList != null && dme == null && rList.length > 0) {
                for (File file : rList) {
                    if (!file.getName().toLowerCase().endsWith(".jar") || !(ln = file.getName().toLowerCase()).contains("deathly") || !ln.contains("mod") || !ln.contains("editor") || ln.contains("launcher") || file.length() <= 26624L) continue;
                    dme = file;
                    break;
                }
            }
            if (dme == null) {
                JOptionPane.showMessageDialog(null, "Could not find Deathly's Mod Editor.jar", "Fatal Error!", 0);
                System.exit(1);
            }
            if ((ini = new File("Deathly's Mod Editor.ini")).exists() && ini.isFile()) {
                File java;
                File root;
                File bin;
                File javac;
                BufferedReader reader = new BufferedReader(new FileReader(ini));
                String path = reader.readLine();
                if (path != null && (javac = new File(path)).exists() && javac.isFile() && (bin = javac.getParentFile()) != null && (root = bin.getParentFile()) != null && (java = new File(root.getPath() + "/jre/bin/java.exe")).exists() && java.isFile() && java.canExecute()) {
                    DMELauncher.launchDME(new File[]{java, null}, dme);
                    System.exit(0);
                }
            } else if (ini.isDirectory() && !ini.delete()) {
                JOptionPane.showMessageDialog(null, "Could not delete Deahtly's Mod Editor.ini", "Could not delete directory", 0);
            }
            File[] jva = DMELauncher.findJdk();
            if (jva != null) {
                DMELauncher.launchDME(jva, dme);
                System.exit(0);
            } else {
                File java;
                File root;
                File bin;
                File javac = DMELauncher.requestJdkPath(true);
                if (javac == null) {
                    System.exit(0);
                }
                if ((bin = javac.getParentFile()) != null && (root = bin.getParentFile()) != null && (java = new File(root.getPath() + "/jre/bin/java.exe")).exists() && java.isFile() && java.canExecute()) {
                    File[] javas = new File[]{java, javac};
                    DMELauncher.launchDME(javas, dme);
                    System.exit(0);
                }
            }
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Fatal Error:\n\n" + sw.toString(), "Fatal Error!", 0);
            System.exit(1);
        }
    }

    private static void launchDME(File[] javas, File dme) {
        try {
            int ret;
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(javas[0].getPath());
            cmd.add("-Xms512m");
            cmd.add("-jar");
            cmd.add(dme.getPath());
            pb.command(cmd);
            final Process p = pb.start();
            if (javas[1] != null) {
                try {
                    File ini = new File("Deathly's Mod Editor.ini");
                    BufferedWriter writer = new BufferedWriter(new FileWriter(ini));
                    writer.write(javas[1].getPath());
                    writer.flush();
                    writer.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            String fileName = DMELauncher.getNewLogName();
            final BufferedWriter logWriter = new BufferedWriter(new FileWriter(fileName));
            new Thread(){

                @Override
                public void run() {
                    try {
                        String line;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                        while ((line = reader.readLine()) != null) {
                            try {
                                System.err.println(line);
                                logWriter.write(line);
                                logWriter.newLine();
                                logWriter.flush();
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }.start();
            new Thread(){

                @Override
                public void run() {
                    try {
                        String line;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        while ((line = reader.readLine()) != null) {
                            try {
                                System.out.println(line);
                                logWriter.write(line);
                                logWriter.newLine();
                                logWriter.flush();
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }.start();
            int rtrn = p.waitFor();
            try {
                logWriter.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (rtrn != 0 && (ret = JOptionPane.showConfirmDialog(null, "Something went wrong\nExit value: " + rtrn + "\n\nDo you want to see the logs?", "Error!", 0, 0)) == 0) {
                String line;
                JDialog frame = new JDialog();
                IOPanel panel = new IOPanel();
                BufferedReader reader = new BufferedReader(new FileReader(fileName));
                while ((line = reader.readLine()) != null) {
                    panel.addLine(line);
                }
                reader.close();
                frame.setContentPane(panel);
                frame.setDefaultCloseOperation(2);
                Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                frame.setBounds((int)d.getWidth() / 2 - 319, (int)d.getHeight() / 2 - 164, 639, 329);
                frame.setModal(true);
                frame.setTitle(new File(fileName).getAbsolutePath());
                frame.setVisible(true);
            }
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Fatal Error:\n\n" + sw.toString(), "Fatal Error!", 0);
            System.exit(1);
        }
    }

    private static String getNewLogName() {
        File[] files;
        File logDir = new File("logs");
        if (!logDir.exists() || logDir.isFile()) {
            logDir.delete();
            logDir.mkdirs();
        }
        if ((files = logDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".log") && name.startsWith("log_");
            }
        })) == null) {
            return "logs/log_0.log";
        }
        for (int i = 0; i <= Integer.MAX_VALUE; ++i) {
            File log = new File("logs/log_" + i + ".log");
            if (log.exists()) continue;
            return "logs/log_" + i + ".log";
        }
        return "logs/log_0.log";
    }

    private static File[] findJdk() {
        String path = System.getenv("path");
        if (path != null) {
            String[] paths = path.split(";");
            for (String pt : paths) {
                File[] list;
                File dir = new File(pt);
                if (!dir.exists() || (list = dir.listFiles()) == null) continue;
                for (File file : list) {
                    if (!file.getName().equals("javac.exe")) continue;
                    File java = new File(file.getParentFile().getParent() + "/jre/bin/java.exe");
                    if (java.exists()) {
                        return new File[]{java, file};
                    }
                    java = new File(file.getParent() + "/java.exe");
                    if (!java.exists()) continue;
                    return new File[]{java, file};
                }
            }
        }
        File[] javas = new File[]{new File("C:\\Program Files (x86)\\Java"), new File("C:\\Program Files\\Java")};
        for (File java : javas) {
            File[] list;
            if (!java.exists() || !java.isDirectory() || (list = java.listFiles()) == null) continue;
            for (File file : list) {
                if (!file.getName().startsWith("jdk")) continue;
                File javac = new File(file + "/bin/javac.exe");
                File java1 = new File(file + "/bin/java.exe");
                File java2 = new File(file + "/jre/bin/java.exe");
                if (!javac.exists()) continue;
                if (java2.exists()) {
                    return new File[]{java2, javac};
                }
                if (!java1.exists()) continue;
                return new File[]{java1, javac};
            }
        }
        return null;
    }

    private static File requestJdkPath(boolean first) {
        String msg = null;
        msg = first ? "Could not find Java Developments Kit (JDK).\nDowload and install it from:\n\nhttp://www.oracle.com/technetwork/java/javase/downloads/jdk7-downloads-1880260.html\n\nIf you have installed a jdk, you can below put the path" : "Could not find Java Developments Kit (JDK).\nDowload and install it from:\n\nhttp://www.oracle.com/technetwork/java/javase/downloads/jdk7-downloads-1880260.html\n\nIf you have installed a jdk, you can below put the path\n\nCan't find jdk in given path!";
        String path = JOptionPane.showInputDialog(null, msg, "Missing Java Developments Kit (JDK)", 0);
        if (path != null) {
            File pt = new File(path);
            File out = null;
            if (pt.getName().endsWith("javac.exe")) {
                out = pt;
            } else if (pt.getName().endsWith("bin")) {
                File javac = new File(pt.getPath() + "/javac.exe");
                if (javac.exists()) {
                    out = javac;
                } else {
                    javac = new File(pt.getParentFile().getParent() + "/bin/javac.exe");
                    if (javac.exists()) {
                        out = javac;
                    }
                }
            } else if (pt.getName().endsWith("java.exe")) {
                File javac = new File(pt.getParentFile() + "/javac.exe");
                if (javac.exists()) {
                    out = javac;
                } else {
                    javac = new File(pt.getParentFile().getParentFile().getParent() + "/bin/javac.exe");
                    if (javac.exists()) {
                        out = javac;
                    }
                }
            } else {
                File javac = new File(pt.getPath() + "/bin/javac.exe");
                if (javac.exists()) {
                    out = javac;
                }
            }
            if (out != null) {
                return out;
            }
            return DMELauncher.requestJdkPath(false);
        }
        return null;
    }
}

