/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.plugin.Food;

import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import net.modmaker.Console.Console;
import net.modmaker.Export.Client;
import net.modmaker.Export.Export;
import net.modmaker.Export.Server;
import net.modmaker.MinecraftEvents.EventBase;
import net.modmaker.Mod.Mod;
import net.modmaker.Utils.Potion;
import net.modmaker.plugin.Food.Food;
import net.modmaker.plugin.Plugin;
import net.modmaker.plugin.SaveBase;

public class ExportScript {
    private static Export.ExportHint exportFood;
    private static Export.ExportHint exportClientFood;
    private static Export.ExportTextureHint exportTexture;

    public static void Enable(Plugin plugin) {
        ArrayList imports = new ArrayList();
        exportFood = new Export.ExportHint(imports, plugin){

            public void onExporting(BufferedWriter bf, Mod mod, File root) throws IOException {
                for (SaveBase sb : mod.object) {
                    try {
                        if (!(sb instanceof Food)) continue;
                        Food food = (Food)sb;
                        bf.write("    public static final Food_" + food.getJavaName() + " " + food.getJavaName() + " = new Food_" + food.getJavaName() + "();");
                        bf.newLine();
                        ExportScript.exportFoodClass(root, food);
                    }
                    catch (Exception e) {
                        Console.Err((Throwable)e);
                    }
                }
            }
        };
        ArrayList clientImports = new ArrayList();
        exportClientFood = new Export.ExportHint(clientImports, plugin){

            public void onExporting(BufferedWriter bf, Mod mod, File root) throws IOException {
                for (SaveBase sb : mod.object) {
                    try {
                        if (!(sb instanceof Food)) continue;
                        Food food = (Food)sb;
                        bf.write("        LanguageRegistry.addName(" + food.getJavaName() + ", \"" + food.getName() + "\");");
                        bf.newLine();
                    }
                    catch (Exception e) {
                        Console.Err((Throwable)e);
                    }
                }
            }
        };
        exportTexture = new Export.ExportTextureHint(){

            public void onExportTextureHint(Mod mod, File parent) throws IOException {
                for (SaveBase sb : mod.object) {
                    try {
                        if (!(sb instanceof Food)) continue;
                        Food food = (Food)sb;
                        ExportScript.exportTexture(parent, food);
                    }
                    catch (Exception e) {
                        Console.Err((Throwable)e);
                    }
                }
            }
        };
        Server.addVariables((Export.ExportHint)exportFood);
        Client.addRenderInfo((Export.ExportHint)exportClientFood);
        Export.addExportTextureHint((Export.ExportTextureHint)exportTexture);
    }

    public static void Disable() {
        if (exportFood != null) {
            Server.removeVariables((Export.ExportHint)exportFood);
        }
        if (exportClientFood != null) {
            Client.removeRenderInfo((Export.ExportHint)exportClientFood);
        }
        if (exportTexture != null) {
            Export.removeExportTextureHint((Export.ExportTextureHint)exportTexture);
        }
    }

    private static void exportTexture(File root, Food food) throws IOException {
        File tRoot = new File(root.getPath() + "/items");
        tRoot.mkdirs();
        ImageIO.write((RenderedImage)food.getTexture().getImage(), "PNG", new File(tRoot + "/" + food.getJavaName() + ".png"));
    }

    private static void exportFoodClass(File root, Food food) throws IOException {
        BufferedWriter bf = new BufferedWriter(new FileWriter(root.getPath() + "/Food_" + food.getJavaName() + ".java"));
        bf.write("package mods." + food.getMod().name.replace(" ", "_") + ";");
        bf.newLine();
        bf.newLine();
        bf.write("import cpw.mods.fml.relauncher.Side;");
        bf.newLine();
        bf.write("import cpw.mods.fml.relauncher.SideOnly;");
        bf.newLine();
        bf.write("import net.minecraft.block.Block;");
        bf.newLine();
        bf.write("import net.minecraft.client.renderer.texture.IconRegister;");
        bf.newLine();
        bf.write("import net.minecraft.creativetab.CreativeTabs;");
        bf.newLine();
        bf.write("import net.minecraft.entity.player.EntityPlayer;");
        bf.newLine();
        bf.write("import net.minecraft.item.*;");
        bf.newLine();
        bf.write("import net.minecraft.potion.*;");
        bf.newLine();
        bf.write("import net.minecraft.world.World;");
        bf.newLine();
        for (EventBase event : food.getEvents()) {
            Iterator i$ = event.getExportHint().imports.iterator();
            while (i$.hasNext()) {
                String i;
                String str = i = (String)i$.next();
                if (i.startsWith("import ")) {
                    str = i.substring("imports: ".length());
                }
                if (str.endsWith(";")) {
                    str = str.substring(0, str.length() - 1);
                }
                bf.write("import " + str + ";");
                bf.newLine();
            }
        }
        bf.write("//Start Custom imports");
        bf.newLine();
        if (food.getCustomCode() != null) {
            if (food.getCustomCode().size() >= 1) {
                if (food.getCustomCode().get(0) != null || "".equals(food.getCustomCode().get(0))) {
                    bf.write((String)food.getCustomCode().get(0));
                } else {
                    bf.newLine();
                }
            } else {
                bf.newLine();
            }
        } else {
            bf.newLine();
        }
        bf.newLine();
        bf.write("//End Custom imports");
        bf.newLine();
        bf.newLine();
        Export.writeCredits((BufferedWriter)bf, (Mod)food.getMod());
        bf.newLine();
        bf.write("public class Food_" + food.getJavaName() + " extends ItemFood{");
        bf.newLine();
        bf.write("    public Food_" + food.getJavaName() + "(){");
        bf.newLine();
        bf.write("        super(" + food.getId() + ", " + food.healAmount + ", " + food.saturationModifier + "f, " + food.isWolfsFavoriteMeat + ");");
        bf.newLine();
        bf.write("        setCreativeTab(CreativeTabs.tab" + food.tab + ");");
        bf.newLine();
        bf.write("        setMaxStackSize(" + food.maxStack + ");");
        bf.newLine();
        bf.write("        setMaxDamage(" + food.maxDamage + ");");
        bf.newLine();
        bf.write("        setUnlocalizedName(\"" + food.getName() + "\");");
        bf.newLine();
        if (food.retItem != null) {
            bf.write("        setContainerItem(" + food.retItem.getJavaName() + ");");
        }
        bf.newLine();
        if (food.potionEffect != null && !"".equals(food.potionEffect) && !food.potionEffect.equals("<none>")) {
            bf.write("        setPotionEffect(" + Potion.getPotion((String)food.potionEffect).getId() + ", " + food.potionDuration + ", " + food.potionAmplifier + ", " + food.potionProbability + "f);");
            bf.newLine();
        }
        if (food.full3D) {
            bf.write("        setFull3D();");
        }
        bf.newLine();
        bf.write("        //Start Custom constructor");
        bf.newLine();
        if (food.getCustomCode() != null) {
            if (food.getCustomCode().size() >= 2) {
                if (food.getCustomCode().get(1) != null || "".equals(food.getCustomCode().get(1))) {
                    bf.write((String)food.getCustomCode().get(1));
                } else {
                    bf.newLine();
                }
            } else {
                bf.newLine();
            }
        } else {
            bf.newLine();
        }
        bf.newLine();
        bf.write("        //End Custom constructor");
        bf.newLine();
        bf.write("    }");
        bf.newLine();
        bf.newLine();
        bf.write("    @SideOnly(Side.CLIENT)");
        bf.newLine();
        bf.write("    public void registerIcons(IconRegister iconRegister){");
        bf.newLine();
        bf.write("        itemIcon = iconRegister.registerIcon(\"" + food.getMod().name.replace(" ", "_").toLowerCase() + ":" + food.getJavaName() + "\");");
        bf.newLine();
        bf.write("    }");
        bf.newLine();
        bf.newLine();
        bf.write("    public EnumAction getItemUseAction(ItemStack par1FoodStack){");
        bf.newLine();
        bf.write("        return EnumAction." + food.action.toLowerCase() + ";");
        bf.newLine();
        bf.write("    }");
        bf.newLine();
        bf.newLine();
        if (food.rotateWhenRendering) {
            bf.write("    public boolean shouldRotateAroundWhenRendering(){");
            bf.newLine();
            bf.write("        return true;");
            bf.newLine();
            bf.write("    }");
            bf.newLine();
            bf.newLine();
        }
        for (EventBase event : food.getEvents()) {
            event.getExportHint().onExporting(bf, food.getMod(), root);
        }
        bf.write("    //Start Custom methodes");
        bf.newLine();
        if (food.getCustomCode() != null) {
            if (food.getCustomCode().size() >= 3) {
                if (food.getCustomCode().get(2) != null || "".equals(food.getCustomCode().get(2))) {
                    bf.write((String)food.getCustomCode().get(2));
                } else {
                    bf.newLine();
                }
            } else {
                bf.newLine();
            }
        } else {
            bf.newLine();
        }
        bf.newLine();
        bf.write("    //End Custom methodes");
        bf.newLine();
        bf.write("}");
        bf.close();
    }
}

