/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.plugin.Armor;

import java.io.IOException;
import java.util.ArrayList;
import net.modmaker.Export.Export;
import net.modmaker.IO.SaveManager;
import net.modmaker.Mod.Mod;
import net.modmaker.Utils.BlockItemHolder;
import net.modmaker.Utils.BufferedImageSeri;
import net.modmaker.Utils.EnumBlock;
import net.modmaker.plugin.Armor.Armor;
import net.modmaker.plugin.Armor.ArmorPanel;
import net.modmaker.plugin.PanelBase;
import net.modmaker.plugin.Plugin;
import net.modmaker.plugin.SaveBase;

class ArmorMaterial
extends SaveBase {
    public int maxDamagaeFactor = 1;
    public int enchantability = 15;
    public int[] damagereduction = new int[]{1, 3, 2, 1};
    public BufferedImageSeri texture1;
    public BufferedImageSeri texture2;
    public BlockItemHolder customCraftingMaterial = new BlockItemHolder(EnumBlock.leather);

    public ArmorMaterial(Mod mod, Plugin plugin) {
        super(plugin, mod);
        if (mod != null) {
            this.setName(this.getArmorMaterialName("Armor Material", mod));
        }
    }

    public void Load(String line) {
        if (line.startsWith("Name:")) {
            this.setName(line.substring("Name:".length()));
        } else if (line.startsWith("MaxDamage:")) {
            this.maxDamagaeFactor = Integer.parseInt(line.substring("MaxDamage:".length()));
        } else if (line.startsWith("Texture1:")) {
            this.texture1 = new BufferedImageSeri(line.substring("Texture1:".length()));
        } else if (line.startsWith("Texture2:")) {
            this.texture2 = new BufferedImageSeri(line.substring("Texture2:".length()));
        } else if (line.startsWith("CraftingMaterial:")) {
            this.customCraftingMaterial = new BlockItemHolder(line.substring("CraftingMaterial:".length()), this.getMod());
        } else if (line.startsWith("Enchantability:")) {
            this.enchantability = Integer.parseInt(line.substring("Enchantability:".length()));
        } else if (line.startsWith("damagereduction0: ")) {
            this.damagereduction[0] = Integer.parseInt(line.substring("damagereduction0:".length()));
        } else if (line.startsWith("damagereduction1: ")) {
            this.damagereduction[1] = Integer.parseInt(line.substring("damagereduction1:".length()));
        } else if (line.startsWith("damagereduction2: ")) {
            this.damagereduction[2] = Integer.parseInt(line.substring("damagereduction2:".length()));
        } else if (line.startsWith("damagereduction3: ")) {
            this.damagereduction[3] = Integer.parseInt(line.substring("damagereduction3:".length()));
        }
    }

    public void Save(SaveManager.BufWriter bf) throws IOException {
        bf.writeLine("Name:" + this.getName());
        bf.writeLine("MaxDamage:" + this.maxDamagaeFactor);
        bf.writeLine("Enchantability:" + this.enchantability);
        if (this.texture1 != null) {
            bf.writeLine("Texture1:" + this.texture1);
        }
        if (this.texture2 != null) {
            bf.writeLine("Texture2:" + this.texture2);
        }
        if (this.customCraftingMaterial != null) {
            bf.writeLine("CraftingMaterial:" + this.customCraftingMaterial.getData());
        }
        for (int i = 0; i < 4; ++i) {
            bf.writeLine("damagereduction" + i + ":" + this.damagereduction[i]);
        }
    }

    public void Check(ArrayList<String> log) {
        String err = Export.ContainsError((String)this.getName());
        if (err != null) {
            log.add("ArmorMaterial " + this.getName() + ": " + err);
        }
        if (this.texture1 == null) {
            log.add("ArmorMaterial " + this.getName() + ": Invalid Texture 1");
        } else if (this.texture1.getImage() == null) {
            log.add("ArmorMaterial " + this.getName() + ": Invalid Texture 1");
        }
        if (this.texture2 == null) {
            log.add("ArmorMaterial " + this.getName() + ": Invalid Texture 2");
        } else if (this.texture2.getImage() == null) {
            log.add("ArmorMaterial " + this.getName() + ": Invalid Texture 2");
        }
        if (this.maxDamagaeFactor < 0) {
            log.add("ArmorMaterial " + this.getName() + ": Duration < 0");
        }
        if (this.enchantability < 0) {
            log.add("ArmorMaterial " + this.getName() + ": Enchantability < 0");
        }
        if (this.damagereduction[0] < 0) {
            log.add("ArmorMaterial " + this.getName() + ": Damage reduction Helmet < 0");
        }
        if (this.damagereduction[1] < 0) {
            log.add("ArmorMaterial " + this.getName() + ": Damage reduction Plate < 0");
        }
        if (this.damagereduction[2] < 0) {
            log.add("ArmorMaterial " + this.getName() + ": Damage reduction Legs < 0");
        }
        if (this.damagereduction[3] < 0) {
            log.add("ArmorMaterial " + this.getName() + ": Damage reduction Boots < 0");
        }
    }

    public SaveBase getNewChild() {
        return new Armor(this.getPlugin(), this.getMod());
    }

    public PanelBase getNewChildPanel(SaveBase child) {
        return new ArmorPanel(child);
    }

    private String getArmorMaterialName(String prefix, Mod mod) {
        boolean isUnique = false;
        String name = prefix;
        int count = 0;
        while (!isUnique) {
            isUnique = true;
            for (SaveBase sb : mod.object) {
                if (!(sb instanceof ArmorMaterial) || !name.equals(sb.getName())) continue;
                name = prefix + "_" + count;
                ++count;
                isUnique = false;
            }
        }
        return name;
    }
}

