/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.plugin.Armor;

import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import net.modmaker.Export.Client;
import net.modmaker.Export.Export;
import net.modmaker.Export.Server;
import net.modmaker.MinecraftEvents.EventBase;
import net.modmaker.Mod.Mod;
import net.modmaker.events.Priority;
import net.modmaker.plugin.Armor.Armor;
import net.modmaker.plugin.Armor.ArmorMaterial;
import net.modmaker.plugin.Plugin;
import net.modmaker.plugin.SaveBase;

public class ExportScript {
    private static Export.ExportHint serverVarHigh;
    private static Export.ExportHint serverRender;
    private static Export.ExportHint serverVar;
    private static Export.ExportHint clientRender;
    private static Export.ExportTextureHint exportTexture;

    public static void Enable(Plugin plugin) {
        serverVarHigh = new Export.ExportHint(new ArrayList(), plugin){

            public void onExporting(BufferedWriter bf, Mod mod, File root) throws IOException {
                for (SaveBase sb : mod.object) {
                    if (!(sb instanceof ArmorMaterial)) continue;
                    ArmorMaterial material = (ArmorMaterial)sb;
                    bf.write("    public final static EnumArmorMaterial " + material.getName().replace(" ", "_") + " = EnumHelper.addArmorMaterial(\"" + material.getName() + "\", " + material.maxDamagaeFactor + ", new int[]{" + material.damagereduction[0] + ", " + material.damagereduction[1] + ", " + material.damagereduction[2] + ", " + material.damagereduction[3] + "}, " + material.enchantability + ");");
                    bf.newLine();
                }
            }
        };
        serverVar = new Export.ExportHint(new ArrayList(), plugin){

            public void onExporting(BufferedWriter bf, Mod mod, File root) throws IOException {
                for (SaveBase sb : mod.object) {
                    if (!(sb instanceof ArmorMaterial)) continue;
                    ArmorMaterial material = (ArmorMaterial)sb;
                    for (SaveBase child : material.getChildren()) {
                        if (!(child instanceof Armor)) continue;
                        Armor armor = (Armor)child;
                        bf.write("    public final static Armor_" + armor.getJavaName() + " " + armor.getJavaName() + " = new Armor_" + armor.getJavaName() + "();");
                        bf.newLine();
                        ExportScript.exportArmor(armor, material, root);
                    }
                }
            }
        };
        serverRender = new Export.ExportHint(new ArrayList(), plugin){

            public void onExporting(BufferedWriter bf, Mod mod, File root) throws IOException {
                for (SaveBase sb : mod.object) {
                    if (!(sb instanceof ArmorMaterial)) continue;
                    ArmorMaterial material = (ArmorMaterial)sb;
                    bf.write("        " + material.getName().replace(" ", "_") + ".customCraftingMaterial = " + material.customCraftingMaterial.getJavaName() + ";");
                    bf.newLine();
                }
            }
        };
        clientRender = new Export.ExportHint(new ArrayList(), plugin){

            public void onExporting(BufferedWriter bf, Mod mod, File root) throws IOException {
                for (SaveBase sb : mod.listAllSaveBase()) {
                    if (!(sb instanceof Armor)) continue;
                    Armor armor = (Armor)sb;
                    bf.write("        LanguageRegistry.addName(" + armor.getJavaName() + ", \"" + armor.getName() + "\");");
                    bf.newLine();
                }
            }
        };
        exportTexture = new Export.ExportTextureHint(){

            public void onExportTextureHint(Mod mod, File parent) throws IOException {
                for (SaveBase sb : mod.object) {
                    if (!(sb instanceof ArmorMaterial)) continue;
                    ArmorMaterial material = (ArmorMaterial)sb;
                    for (SaveBase child : material.getChildren()) {
                        if (!(child instanceof Armor)) continue;
                        Armor armor = (Armor)child;
                        ExportScript.exportTexture(armor, parent);
                    }
                    File tRoot = new File(parent.getPath() + "/armor");
                    tRoot.mkdirs();
                    ImageIO.write((RenderedImage)material.texture1.getImage(), "PNG", new File(tRoot + "/" + material.getName().replace(" ", "_") + "_1.png"));
                    ImageIO.write((RenderedImage)material.texture2.getImage(), "PNG", new File(tRoot + "/" + material.getName().replace(" ", "_") + "_2.png"));
                }
            }
        };
        Server.addVariables((Export.ExportHint)serverVarHigh, (Priority)Priority.HIGH);
        Server.addVariables((Export.ExportHint)serverVar);
        Server.addRenderInfo((Export.ExportHint)serverRender);
        Client.addRenderInfo((Export.ExportHint)clientRender);
        Export.addExportTextureHint((Export.ExportTextureHint)exportTexture);
    }

    public static void Disable() {
        Server.removeVariables((Export.ExportHint)serverVarHigh, (Priority)Priority.HIGH);
        Server.removeVariables((Export.ExportHint)serverVar);
        Server.removeRenderInfo((Export.ExportHint)serverRender);
        Client.removeRenderInfo((Export.ExportHint)clientRender);
        Export.removeExportTextureHint((Export.ExportTextureHint)exportTexture);
    }

    private static void exportTexture(Armor armor, File root) throws IOException {
        File tRoot = new File(root.getPath() + "/items");
        tRoot.mkdirs();
        ImageIO.write((RenderedImage)armor.getTexture().getImage(), "PNG", new File(tRoot + "/" + armor.getJavaName() + ".png"));
    }

    private static void exportArmor(Armor armor, ArmorMaterial material, File root) throws IOException {
        BufferedWriter bf = new BufferedWriter(new FileWriter(root.getPath() + "/Armor_" + armor.getJavaName() + ".java"));
        bf.write("package mods." + armor.getMod().name.replace(" ", "_") + ";");
        bf.newLine();
        bf.newLine();
        bf.write("import cpw.mods.fml.relauncher.Side;");
        bf.newLine();
        bf.write("import cpw.mods.fml.relauncher.SideOnly;");
        bf.newLine();
        bf.write("import net.minecraft.client.renderer.texture.IconRegister;");
        bf.newLine();
        bf.write("import net.minecraft.item.*;");
        bf.newLine();
        bf.write("import net.minecraft.src.*;");
        bf.newLine();
        bf.write("import net.minecraft.creativetab.CreativeTabs;");
        bf.newLine();
        bf.write("import net.minecraft.entity.player.EntityPlayer;");
        bf.newLine();
        bf.write("import net.minecraft.world.World;");
        bf.newLine();
        bf.write("import net.minecraft.entity.Entity;");
        bf.newLine();
        for (EventBase event : armor.getEvents()) {
            Iterator i$ = event.getExportHint().imports.iterator();
            while (i$.hasNext()) {
                String i;
                String str = i = (String)i$.next();
                if (i.startsWith("import ")) {
                    str = i.substring("imports: ".length());
                }
                if (str.endsWith(";")) {
                    str = str.substring(0, str.length() - 1);
                }
                bf.write("import " + str + ";");
                bf.newLine();
            }
        }
        bf.write("//Start Custom imports");
        bf.newLine();
        if (armor.getCustomCode() != null) {
            if (armor.getCustomCode().size() >= 1) {
                if (armor.getCustomCode().get(0) != null || "".equals(armor.getCustomCode().get(0))) {
                    bf.write((String)armor.getCustomCode().get(0));
                } else {
                    bf.newLine();
                }
            } else {
                bf.newLine();
            }
        } else {
            bf.newLine();
        }
        bf.newLine();
        bf.write("//End Custom imports");
        bf.newLine();
        bf.newLine();
        Export.writeCredits((BufferedWriter)bf, (Mod)armor.getMod());
        bf.newLine();
        bf.write("public class Armor_" + armor.getJavaName() + " extends ItemArmor{");
        bf.newLine();
        bf.newLine();
        bf.write("    public Armor_" + armor.getJavaName() + "(){");
        bf.newLine();
        bf.write("        super(" + armor.getId() + ", Server." + material.getName().replace(" ", "_") + ", 4, " + armor.type + ");");
        bf.newLine();
        bf.write("        setCreativeTab(CreativeTabs.tab" + armor.tab + ");");
        bf.newLine();
        bf.write("        setMaxStackSize(" + armor.maxStack + ");");
        bf.newLine();
        bf.write("        setUnlocalizedName(\"" + armor.getName() + "\");");
        if (armor.retItem != null) {
            bf.write("        setContainerItem(" + armor.retItem.getJavaName() + ");");
        }
        bf.newLine();
        if (armor.full3D) {
            bf.write("        setFull3D();");
        }
        bf.newLine();
        bf.write("        //Start Custom constructor");
        bf.newLine();
        if (armor.getCustomCode() != null) {
            if (armor.getCustomCode().size() >= 2) {
                if (armor.getCustomCode().get(1) != null || "".equals(armor.getCustomCode().get(1))) {
                    bf.write((String)armor.getCustomCode().get(1));
                } else {
                    bf.newLine();
                }
            } else {
                bf.newLine();
            }
        } else {
            bf.newLine();
        }
        bf.newLine();
        bf.write("        //End Custom constructor");
        bf.newLine();
        bf.write("    }");
        bf.newLine();
        bf.newLine();
        bf.write("    @SideOnly(Side.CLIENT)");
        bf.newLine();
        bf.write("    public void registerIcons(IconRegister iconRegister){");
        bf.newLine();
        bf.write("        itemIcon = iconRegister.registerIcon(\"" + armor.getMod().name.replace(" ", "_").toLowerCase() + ":" + armor.getJavaName() + "\");");
        bf.newLine();
        bf.write("    }");
        bf.newLine();
        bf.newLine();
        bf.write("    public String getArmorTexture(ItemStack par1, Entity entity, int slot, int layer){");
        bf.newLine();
        bf.write("        return \"" + armor.getMod().name.replace(" ", "_").toLowerCase() + ":/textures/armor/" + material.getName().replace(" ", "_") + "_" + (armor.type == 2 ? "2" : "1") + ".png\";");
        bf.newLine();
        bf.write("    }");
        bf.newLine();
        bf.newLine();
        if (!armor.action.equals("None")) {
            bf.write("    public EnumAction getItemUseAction(ItemStack par1ItemStack){");
            bf.newLine();
            bf.write("        return EnumAction." + armor.action.toLowerCase() + ";");
            bf.newLine();
            bf.write("    }");
            bf.newLine();
            bf.newLine();
        }
        if (armor.rotateWhenRendering) {
            bf.write("    public boolean shouldRotateAroundWhenRendering(){");
            bf.newLine();
            bf.write("        return true;");
            bf.newLine();
            bf.write("    }");
            bf.newLine();
            bf.newLine();
        }
        for (EventBase event : armor.getEvents()) {
            event.getExportHint().onExporting(bf, armor.getMod(), root);
        }
        bf.write("    //Start Custom methodes");
        bf.newLine();
        if (armor.getCustomCode() != null) {
            if (armor.getCustomCode().size() >= 3) {
                if (armor.getCustomCode().get(2) != null || "".equals(armor.getCustomCode().get(2))) {
                    bf.write((String)armor.getCustomCode().get(2));
                } else {
                    bf.newLine();
                }
            } else {
                bf.newLine();
            }
        } else {
            bf.newLine();
        }
        bf.newLine();
        bf.write("    //End Custom methodes");
        bf.newLine();
        bf.write("}");
        bf.close();
    }
}

