/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.plugin.Tool;

import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import net.modmaker.Console.Console;
import net.modmaker.Export.Client;
import net.modmaker.Export.Export;
import net.modmaker.Export.Server;
import net.modmaker.MinecraftEvents.EventBase;
import net.modmaker.Mod.Mod;
import net.modmaker.events.Priority;
import net.modmaker.plugin.Plugin;
import net.modmaker.plugin.SaveBase;
import net.modmaker.plugin.Tool.Tool;
import net.modmaker.plugin.Tool.ToolMaterial;

public class ExportScript {
    private static Export.ExportHint serverVarHigh;
    private static Export.ExportHint serverVarNormal;
    private static Export.ExportHint serverRender;
    private static Export.ExportHint clientRender;
    private static Export.ExportTextureHint exportTexture;

    public static void Enable(Plugin plugin) {
        serverVarHigh = new Export.ExportHint(new ArrayList(), plugin){

            public void onExporting(BufferedWriter bf, Mod mod, File root) throws IOException {
                for (SaveBase sb : mod.object) {
                    if (!(sb instanceof ToolMaterial)) continue;
                    ToolMaterial mat = (ToolMaterial)sb;
                    bf.write("    public final static EnumToolMaterial ToolMat_" + sb.getName().replace(" ", "_") + " = EnumHelper.addToolMaterial(\"" + sb.getName() + "\", " + mat.harvestLevel + ", " + mat.maxUses + ", " + mat.StrengthVsBlock + "f, " + mat.StrengthVsEntity + ", " + mat.enchanteability + ");");
                    bf.newLine();
                }
            }
        };
        serverVarNormal = new Export.ExportHint(new ArrayList(), plugin){

            public void onExporting(BufferedWriter bf, Mod mod, File root) throws IOException {
                for (SaveBase sb : mod.object) {
                    if (!(sb instanceof ToolMaterial)) continue;
                    ToolMaterial mat = (ToolMaterial)sb;
                    for (SaveBase child : mat.getChildren()) {
                        if (!(child instanceof Tool)) continue;
                        Tool tool = (Tool)child;
                        bf.write("    public final static Tool_" + tool.getJavaName() + " " + tool.getJavaName() + " = new Tool_" + tool.getJavaName() + "();");
                        bf.newLine();
                        ExportScript.exportToolClass(root, tool, mat);
                    }
                }
            }
        };
        serverRender = new Export.ExportHint(new ArrayList(), plugin){

            public void onExporting(BufferedWriter bf, Mod mod, File root) throws IOException {
                for (SaveBase sb : mod.object) {
                    ToolMaterial mat;
                    if (!(sb instanceof ToolMaterial) || (mat = (ToolMaterial)sb) == null || mat.customCraftingMaterial == null) continue;
                    bf.write("        ToolMat_" + mat.getName().replace(" ", "_") + ".customCraftingMaterial = " + mat.customCraftingMaterial.getJavaName() + ";");
                    bf.newLine();
                }
            }
        };
        clientRender = new Export.ExportHint(new ArrayList(), plugin){

            public void onExporting(BufferedWriter bf, Mod mod, File root) throws IOException {
                for (SaveBase sb : mod.object) {
                    if (!(sb instanceof ToolMaterial)) continue;
                    ToolMaterial mat = (ToolMaterial)sb;
                    for (SaveBase client : mat.getChildren()) {
                        if (!(client instanceof Tool)) continue;
                        Tool tool = (Tool)client;
                        bf.write("        LanguageRegistry.addName(" + tool.getJavaName() + ", \"" + tool.getName() + "\");");
                        bf.newLine();
                    }
                }
            }
        };
        exportTexture = new Export.ExportTextureHint(){

            public void onExportTextureHint(Mod mod, File parent) throws IOException {
                for (SaveBase sb : mod.listAllSaveBase()) {
                    try {
                        if (!(sb instanceof Tool)) continue;
                        Tool tool = (Tool)sb;
                        ExportScript.exportTexture(parent, tool);
                    }
                    catch (Exception e) {
                        Console.Err((Throwable)e);
                    }
                }
            }
        };
        Server.addVariables((Export.ExportHint)serverVarHigh, (Priority)Priority.HIGH);
        Server.addVariables((Export.ExportHint)serverVarNormal);
        Server.addRenderInfo((Export.ExportHint)serverRender);
        Client.addRenderInfo((Export.ExportHint)clientRender);
        Export.addExportTextureHint((Export.ExportTextureHint)exportTexture);
    }

    public static void Disable() {
        Server.removeVariables((Export.ExportHint)serverVarHigh, (Priority)Priority.HIGH);
        Server.removeVariables((Export.ExportHint)serverVarNormal);
        Server.removeRenderInfo((Export.ExportHint)serverRender);
        Client.removeRenderInfo((Export.ExportHint)clientRender);
        Export.removeExportTextureHint((Export.ExportTextureHint)exportTexture);
    }

    private static void exportTexture(File root, Tool tool) throws IOException {
        File tRoot = new File(root.getPath() + "/items");
        tRoot.mkdirs();
        ImageIO.write((RenderedImage)tool.getTexture().getImage(), "PNG", new File(tRoot.getPath() + "/" + tool.getJavaName() + ".png"));
    }

    private static void exportToolClass(File root, Tool tool, ToolMaterial mat) throws IOException {
        BufferedWriter bf = new BufferedWriter(new FileWriter(root.getPath() + "/Tool_" + tool.getJavaName() + ".java"));
        bf.write("package mods." + tool.getMod().name.replace(" ", "_") + ";");
        bf.newLine();
        bf.newLine();
        bf.write("import cpw.mods.fml.relauncher.Side;");
        bf.newLine();
        bf.write("import cpw.mods.fml.relauncher.SideOnly;");
        bf.newLine();
        bf.write("import net.minecraft.client.renderer.texture.IconRegister;");
        bf.newLine();
        bf.write("import net.minecraft.creativetab.CreativeTabs;");
        bf.newLine();
        bf.write("import net.minecraft.entity.player.EntityPlayer;");
        bf.newLine();
        bf.write("import net.minecraft.item.*;");
        bf.newLine();
        bf.write("import net.minecraft.world.World;");
        bf.newLine();
        for (EventBase event : tool.getEvents()) {
            Iterator i$ = event.getExportHint().imports.iterator();
            while (i$.hasNext()) {
                String i;
                String str = i = (String)i$.next();
                if (i.startsWith("import ")) {
                    str = i.substring("imports: ".length());
                }
                if (str.endsWith(";")) {
                    str = str.substring(0, str.length() - 1);
                }
                bf.write("import " + str + ";");
                bf.newLine();
            }
        }
        bf.write("//Start Custom imports");
        bf.newLine();
        if (tool.getCustomCode() != null) {
            if (tool.getCustomCode().size() >= 1) {
                if (tool.getCustomCode().get(0) != null || "".equals(tool.getCustomCode().get(0))) {
                    bf.write((String)tool.getCustomCode().get(0));
                } else {
                    bf.newLine();
                }
            } else {
                bf.newLine();
            }
        } else {
            bf.newLine();
        }
        bf.newLine();
        bf.write("//End Custom imports");
        bf.newLine();
        bf.newLine();
        Export.writeCredits((BufferedWriter)bf, (Mod)tool.getMod());
        bf.newLine();
        bf.write("public class Tool_" + tool.getJavaName() + " extends Item" + tool.type + "{");
        bf.newLine();
        bf.write("    public Tool_" + tool.getJavaName() + "(){");
        bf.newLine();
        bf.write("        super(" + tool.getId() + ", Server.ToolMat_" + mat.getName().replace(" ", "_") + ");");
        bf.newLine();
        bf.write("        setCreativeTab(CreativeTabs.tab" + tool.tab + ");");
        bf.newLine();
        bf.write("        setMaxStackSize(" + tool.maxStack + ");");
        bf.newLine();
        bf.write("        setUnlocalizedName(\"" + tool.getName() + "\");");
        if (tool.retItem != null) {
            bf.write("        setContainerItem(" + tool.retItem.getJavaName() + ");");
        }
        bf.newLine();
        if (tool.full3D) {
            bf.write("        setFull3D();");
        }
        bf.newLine();
        bf.write("        //Start Custom constructor");
        bf.newLine();
        if (tool.getCustomCode() != null) {
            if (tool.getCustomCode().size() >= 2) {
                if (tool.getCustomCode().get(1) != null || "".equals(tool.getCustomCode().get(1))) {
                    bf.write((String)tool.getCustomCode().get(1));
                } else {
                    bf.newLine();
                }
            } else {
                bf.newLine();
            }
        } else {
            bf.newLine();
        }
        bf.newLine();
        bf.write("        //End Custom constructor");
        bf.newLine();
        bf.write("    }");
        bf.newLine();
        bf.newLine();
        bf.write("    @SideOnly(Side.CLIENT)");
        bf.newLine();
        bf.write("    public void registerIcons(IconRegister iconRegister){");
        bf.newLine();
        bf.write("        itemIcon = iconRegister.registerIcon(\"" + tool.getMod().name.replace(" ", "_").toLowerCase() + ":" + tool.getJavaName() + "\");");
        bf.newLine();
        bf.write("    }");
        bf.newLine();
        bf.newLine();
        if (!tool.action.equals("None")) {
            bf.write("    public EnumAction getItemUseAction(ItemStack par1ItemStack){");
            bf.newLine();
            bf.write("        return EnumAction." + tool.action.toLowerCase() + ";");
            bf.newLine();
            bf.write("    }");
            bf.newLine();
            bf.newLine();
        }
        if (tool.rotateWhenRendering) {
            bf.write("    public boolean shouldRotateAroundWhenRendering(){");
            bf.newLine();
            bf.write("        return true;");
            bf.newLine();
            bf.write("    }");
            bf.newLine();
            bf.newLine();
        }
        for (EventBase event : tool.getEvents()) {
            event.getExportHint().onExporting(bf, tool.getMod(), root);
        }
        bf.write("    //Start Custom methodes");
        bf.newLine();
        if (tool.getCustomCode() != null) {
            if (tool.getCustomCode().size() >= 3) {
                if (tool.getCustomCode().get(2) != null || "".equals(tool.getCustomCode().get(2))) {
                    bf.write((String)tool.getCustomCode().get(2));
                } else {
                    bf.newLine();
                }
            } else {
                bf.newLine();
            }
        } else {
            bf.newLine();
        }
        bf.newLine();
        bf.write("    //End Custom methodes");
        bf.newLine();
        bf.write("}");
        bf.close();
    }
}

