/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.plugin.Tool;

import java.io.IOException;
import java.util.ArrayList;
import net.modmaker.Export.Export;
import net.modmaker.IO.SaveManager;
import net.modmaker.MinecraftEvents.Actions.ReturnStatement;
import net.modmaker.MinecraftEvents.EventBase;
import net.modmaker.Mod.Mod;
import net.modmaker.Utils.BlockItemHolder;
import net.modmaker.Utils.BufferedImageSeri;
import net.modmaker.Utils.Unique;
import net.modmaker.plugin.ItemBase;
import net.modmaker.plugin.PanelBase;
import net.modmaker.plugin.Plugin;
import net.modmaker.plugin.SaveBase;

public class Tool
extends ItemBase {
    public BufferedImageSeri backup = null;
    public boolean isTransparrent = false;
    public String tab = "Tools";
    public int maxStack = 1;
    public int maxDamage = 0;
    public int lifeSpawn = 6000;
    public boolean full3D = true;
    public boolean rotateWhenRendering = false;
    public String action = "Block";
    public String potionEffect = null;
    public String information = "";
    public String type = "Pickaxe";
    public BlockItemHolder retItem;

    public Tool(Plugin plugin, Mod mod) {
        super(plugin, mod);
        if (mod != null) {
            this.setName(Unique.getItemName((String)"Tool", (Mod)mod));
        }
        ArrayList events = this.getEvents();
        for (EventBase event : events) {
            if (event.getName().equals("hitEntity")) {
                event.setReturnStatement(new ReturnStatement("super.hitEntity(itemStack, hittedEntity, attackingEntity);"));
                continue;
            }
            if (event.getName().equals("onBlockDestroyed")) {
                event.setReturnStatement(new ReturnStatement("super.onBlockDestroyed(itemStack, world, blockX, blockY, blockZ, blockSide, entity);"));
                continue;
            }
            if (event.getName().equals("onItemRightClick")) {
                event.setReturnStatement(new ReturnStatement("super.onItemRightClick(itemStack, world, player);"));
                continue;
            }
            if (!event.getName().equals("onItemuse")) continue;
            event.setReturnStatement(new ReturnStatement("super.onItemuse(itemStack, player, world, blockX, blockY, blockZ, blockSide, x, y, z);"));
        }
    }

    public void Load(String line) {
        if (line.startsWith("Name:")) {
            this.setName(line.substring("name:".length()));
        } else if (line.startsWith("Id:")) {
            this.setId(Integer.parseInt(line.substring("Id:".length())));
        } else if (line.startsWith("Tab:")) {
            this.tab = line.substring("tab:".length());
        } else if (line.startsWith("Texture:")) {
            this.setTexture(new BufferedImageSeri(line.substring("texture:".length())));
        } else if (line.startsWith("Backup:")) {
            this.backup = new BufferedImageSeri(line.substring("Backup:".length()));
        } else if (line.startsWith("Transparent:")) {
            this.isTransparrent = Boolean.parseBoolean(line.substring("isTransparrent".length()));
        } else if (line.startsWith("CustomCode_")) {
            int i = Integer.parseInt(line.substring("CustomCode_".length(), "CustomCode_".length() + 1));
            String code = line.substring("CustomCode_a:".length());
            if (this.getCustomCode() == null) {
                ArrayList<String> cc = new ArrayList<String>();
                cc.add(i, code);
                this.setCustomCode(cc);
            } else {
                ArrayList cc = this.getCustomCode();
                cc.add(i, code);
                this.setCustomCode(cc);
            }
        } else if (line.startsWith("maxStack:")) {
            this.maxStack = Integer.parseInt(line.substring("maxStack:".length()));
        } else if (line.startsWith("maxDamage:")) {
            this.maxDamage = Integer.parseInt(line.substring("maxDamage:".length()));
        } else if (line.startsWith("lifeSpawn:")) {
            this.lifeSpawn = Integer.parseInt(line.substring("lifeSpawn:".length()));
        } else if (line.startsWith("full3D:")) {
            this.full3D = Boolean.parseBoolean(line.substring("full3D:".length()));
        } else if (line.startsWith("rotateWhenRendering:")) {
            this.rotateWhenRendering = Boolean.parseBoolean(line.substring("rotateWhenRendering:".length()));
        } else if (line.startsWith("action:")) {
            this.action = line.substring("action:".length());
        } else if (line.startsWith("Type:")) {
            this.type = line.substring("Type:".length());
        } else if (line.startsWith("retItem:")) {
            this.retItem = new BlockItemHolder(line.substring("retItem:".length()), this.getMod());
        }
    }

    public void Save(SaveManager.BufWriter bf) throws IOException {
        bf.writeLine("Name:" + this.getName());
        bf.writeLine("Id:" + this.getId());
        bf.writeLine("Tab:" + this.tab);
        if (this.getTexture() != null) {
            bf.writeLine("Texture:" + this.getTexture().toString());
        }
        if (this.backup != null) {
            bf.writeLine("Backup:" + this.backup.toString());
        }
        bf.writeLine("Transparent:" + this.isTransparrent);
        bf.writeLine("maxStack:" + this.maxStack);
        bf.writeLine("maxDamage:" + this.maxDamage);
        bf.writeLine("lifeSpawn:" + this.lifeSpawn);
        bf.writeLine("full3D:" + this.full3D);
        bf.writeLine("rotateWhenRendering:" + this.rotateWhenRendering);
        bf.writeLine("action:" + this.action);
        bf.writeLine("Type:" + this.type);
        if (this.retItem != null) {
            bf.writeLine("retItem:" + this.retItem.getData());
        }
        if (this.getCustomCode() != null) {
            for (int a = 0; a < this.getCustomCode().size(); ++a) {
                if (this.getCustomCode().get(a) == null && !"".equals(this.getCustomCode().get(a))) continue;
                bf.writeLine("CustomCode_" + a + ":" + ((String)this.getCustomCode().get(a)).replace("\n", "<br>"));
            }
        }
    }

    public void Check(ArrayList<String> log) {
        String err = Export.ContainsError((String)this.getName());
        if (err != null) {
            log.add("Tool " + this.getName() + ": " + err);
        }
        if (this.getTexture() == null) {
            log.add("Tool " + this.getName() + ": Invalid Texture");
        } else if (this.getTexture().getImage() == null) {
            log.add("Tool " + this.getName() + ": Invalid Texture");
        }
        if (this.getId() < 400 || this.getId() > 2255 && this.getId() < 2266) {
            log.add("Tool " + this.getName() + ": Invalid Id:" + this.getId());
        }
        if (this.maxStack < 1) {
            log.add("Tool " + this.getName() + ": Invalid max stack: " + this.maxStack);
        }
        if (this.maxDamage < 0) {
            log.add("Tool " + this.getName() + ": Invalid max Damage" + this.maxDamage);
        }
        if (this.lifeSpawn < 0) {
            log.add("Tool " + this.getName() + ": Invalid lifeSpawn: " + this.lifeSpawn);
        }
    }

    public SaveBase getNewChild() {
        return null;
    }

    public PanelBase getNewChildPanel(SaveBase child) {
        return null;
    }

    public String getJavaName() {
        return this.getName().replace(" ", "_");
    }
}

