/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.plugin.Tool;

import java.io.IOException;
import java.util.ArrayList;
import net.modmaker.Export.Export;
import net.modmaker.IO.SaveManager;
import net.modmaker.Mod.Mod;
import net.modmaker.Utils.BlockItemHolder;
import net.modmaker.plugin.PanelBase;
import net.modmaker.plugin.Plugin;
import net.modmaker.plugin.SaveBase;
import net.modmaker.plugin.Tool.Tool;
import net.modmaker.plugin.Tool.ToolPanel;

public class ToolMaterial
extends SaveBase {
    public int harvestLevel = 0;
    public int maxUses = 59;
    public int StrengthVsBlock = 4;
    public int StrengthVsEntity = 0;
    public int enchanteability = 15;
    public BlockItemHolder customCraftingMaterial;

    public ToolMaterial(Plugin plugin, Mod mod) {
        super(plugin, mod);
        if (mod != null) {
            this.setName(ToolMaterial.getToolMaterialName("Tool Material", mod));
        }
    }

    public void Load(String line) {
        if (line.startsWith("Name:")) {
            this.setName(line.substring("Name:".length()));
        } else if (line.startsWith("DamageVSEntity:")) {
            this.StrengthVsEntity = Integer.parseInt(line.substring("DamageVSEntity:".length()));
        } else if (line.startsWith("DamageVSBlocks:")) {
            this.StrengthVsBlock = Integer.parseInt(line.substring("DamageVSBlocks:".length()));
        } else if (line.startsWith("Enchantability:")) {
            this.enchanteability = Integer.parseInt(line.substring("Enchantability:".length()));
        } else if (line.startsWith("HarverstLevel:")) {
            this.harvestLevel = Integer.parseInt(line.substring("HarverstLevel:".length()));
        } else if (line.startsWith("MaxUses:")) {
            this.maxUses = Integer.parseInt(line.substring("MaxUses:".length()));
        } else if (line.startsWith("CraftingMaterial:")) {
            this.customCraftingMaterial = new BlockItemHolder(line.substring("CraftingMaterial:".length()), this.getMod());
        }
    }

    public void Save(SaveManager.BufWriter bf) throws IOException {
        bf.writeLine("Name:" + this.getName());
        bf.writeLine("DamageVSEntity:" + this.StrengthVsEntity);
        bf.writeLine("DamageVSBlocks:" + this.StrengthVsBlock);
        bf.writeLine("Enchantability:" + this.enchanteability);
        bf.writeLine("HarverstLevel:" + this.harvestLevel);
        bf.writeLine("MaxUses:" + this.maxUses);
        if (this.customCraftingMaterial != null) {
            bf.writeLine("CraftingMaterial:" + this.customCraftingMaterial.getData());
        }
    }

    public void Check(ArrayList<String> log) {
        String err = Export.ContainsError((String)this.getName());
        if (err != null) {
            log.add("Tool " + this.getName() + ": " + err);
        }
        if (this.StrengthVsBlock < 0) {
            log.add("Tool " + this.getName() + ": StrengthVsBlock < 0");
        }
        if (this.StrengthVsEntity < 0) {
            log.add("Tool " + this.getName() + ": StrengthVsEntity < 0");
        }
        if (this.enchanteability < 0) {
            log.add("Tool " + this.getName() + ": enchanteability < 0");
        }
        if (this.harvestLevel < 0) {
            log.add("Tool " + this.getName() + ": harvestLevel < 0");
        }
        if (this.maxUses < 0) {
            log.add("Tool " + this.getName() + ": maxUses < 0");
        }
    }

    public SaveBase getNewChild() {
        return new Tool(this.getPlugin(), this.getMod());
    }

    public PanelBase getNewChildPanel(SaveBase child) {
        return new ToolPanel(child);
    }

    public static String getToolMaterialName(String prefix, Mod mod) {
        boolean isUnique = false;
        String name = prefix;
        int count = 0;
        while (!isUnique) {
            isUnique = true;
            for (SaveBase sb : mod.object) {
                if (!(sb instanceof ToolMaterial) || !name.equals(sb.getName())) continue;
                name = prefix + "_" + count;
                ++count;
                isUnique = false;
            }
        }
        return name;
    }
}

