/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.plugin.Tool;

import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.modmaker.Console.Console;
import net.modmaker.Gui.Dialogs.ItemChooser;
import net.modmaker.Gui.Tree;
import net.modmaker.Utils.BlockItemHolder;
import net.modmaker.events.Listeners.UpdateListener;
import net.modmaker.events.UpdateEvent;
import net.modmaker.plugin.PanelBase;
import net.modmaker.plugin.SaveBase;
import net.modmaker.plugin.Tool.ToolMaterial;

public class ToolMaterialPanel
extends PanelBase
implements UpdateListener {
    private String backupName;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSpinner jSpinner1;
    private JSpinner jSpinner2;
    private JSpinner jSpinner3;
    private JSpinner jSpinner4;
    private JSpinner jSpinner5;
    private JTextField jTextField1;

    public ToolMaterialPanel(SaveBase obj) {
        super(obj);
        this.initComponents();
        this.Load();
        this.jTextField1.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (ToolMaterialPanel.this.jTextField1.getText() != null) {
                    ToolMaterialPanel.this.object.setName(ToolMaterialPanel.this.jTextField1.getText());
                    Tree.getTree().UpdateTree();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (ToolMaterialPanel.this.jTextField1.getText() != null) {
                    ToolMaterialPanel.this.object.setName(ToolMaterialPanel.this.jTextField1.getText());
                    Tree.getTree().UpdateTree();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (ToolMaterialPanel.this.jTextField1.getText() != null) {
                    ToolMaterialPanel.this.object.setName(ToolMaterialPanel.this.jTextField1.getText());
                    Tree.getTree().UpdateTree();
                }
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabel2 = new JLabel();
        this.jSpinner1 = new JSpinner();
        this.jLabel3 = new JLabel();
        this.jSpinner2 = new JSpinner();
        this.jSeparator1 = new JSeparator();
        this.jLabel4 = new JLabel();
        this.jSpinner3 = new JSpinner();
        this.jLabel5 = new JLabel();
        this.jSpinner4 = new JSpinner();
        this.jSpinner5 = new JSpinner();
        this.jLabel6 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jButton1 = new JButton();
        this.jLabel9 = new JLabel();
        this.setBackground(new Color(100, 100, 100));
        this.jLabel1.setText("Name:");
        this.jTextField1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ToolMaterialPanel.this.jTextField1FocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                ToolMaterialPanel.this.jTextField1FocusLost(evt);
            }
        });
        this.jLabel2.setText("HarvestLevel:");
        this.jSpinner1.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.jSpinner1.setToolTipText("<html>\nThe level of material this tool can harvest\n<br>\nGold = 0, Diamond = 3, Iron = 2, Stone = 1, Wood = 0\n</html>");
        this.jLabel3.setText("Max Uses:");
        this.jSpinner2.setToolTipText("<html>\nThe number of uses this material allows\n<br>\nGold = 32, Diamond = 1561, Iron = 250, Stone = 131, Wood = 59\n</html>");
        this.jSeparator1.setBackground(new Color(100, 100, 100));
        this.jSeparator1.setForeground(new Color(51, 51, 51));
        this.jSeparator1.setOrientation(1);
        this.jLabel4.setText("Strength vs Blocks: ");
        this.jSpinner3.setToolTipText("<html>\nThe strength of this tool material against block which it is effective against\n<br>\nGold = 12, Diamond = 8, Iron = 6, Stone = 4, Wood = 2\n</html>");
        this.jLabel5.setText("Strength vs Entity:");
        this.jSpinner4.setToolTipText("<html>\nDamage versus entities\n<br>\nGold = 0, Diamond = 3, Iron = 2, Stone = 1, Wood = 0\n</html>");
        this.jSpinner5.setToolTipText("<html>\nDefines the natural enchantability factor of the material.\n<br>\nGold = 22, Diamond = 10, Iron = 14, Stone = 5, Wood = 15\n</html>");
        this.jLabel6.setText("Enchantability:");
        this.jSeparator2.setBackground(new Color(100, 100, 100));
        this.jSeparator2.setForeground(new Color(51, 51, 51));
        this.jLabel7.setText("Hover over the fields for help");
        this.jButton1.setText(" ");
        this.jButton1.setToolTipText("<html>\nThe item that is needed to repair this material\n<br>\nGold: ingotGold, Diamond: diamond, Iron: ingotIron, Stone: cobbleStone, Wood: planks");
        this.jButton1.setOpaque(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolMaterialPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel9.setText("Crafting Material:");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jLabel8).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.jLabel3).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextField1).addComponent(this.jSpinner1).addComponent(this.jSpinner2).addComponent(this.jButton1, -2, 100, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel4).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSpinner5).addComponent(this.jSpinner4, GroupLayout.Alignment.TRAILING, -2, 100, -2).addComponent(this.jSpinner3, -2, 100, -2)))).addGap(0, 107, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jSpinner3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jSpinner4, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinner5, -2, -1, -2).addComponent(this.jLabel6))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jSpinner1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinner2, -2, -1, -2).addComponent(this.jLabel3)))).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1, -2, 25, -2).addComponent(this.jLabel9))).addComponent(this.jSeparator1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addGap(43, 43, 43).addComponent(this.jLabel8).addContainerGap(118, Short.MAX_VALUE)));
    }

    private void jTextField1FocusGained(FocusEvent evt) {
        if (this.jTextField1.getText() != null && !"".equals(this.jTextField1.getText())) {
            this.backupName = this.jTextField1.getText();
        }
    }

    private void jTextField1FocusLost(FocusEvent evt) {
        if (this.jTextField1.getText() == null || "".equals(this.jTextField1.getText())) {
            if (this.backupName != null && !"".equals(this.backupName)) {
                this.jTextField1.setText(this.backupName);
            } else {
                this.jTextField1.setText("[No Name]");
            }
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            ItemChooser tc = ItemChooser.getItemChooser();
            tc.setTabVisible(0, false);
            tc.setVisible(this.object.getMod());
            if (tc.getReturnState() == 1) {
                BlockItemHolder bih = tc.getSelectedObject();
                tc.setTabVisible(0, true);
                if (bih != null) {
                    ToolMaterial tm = (ToolMaterial)this.object;
                    this.setCraftingMaterial(bih);
                    tm.customCraftingMaterial = bih;
                }
            } else if (tc.getReturnState() == 2) {
                this.setCraftingMaterial(null);
                ((ToolMaterial)this.object).customCraftingMaterial = null;
            }
        }
        catch (Throwable e) {
            Console.Err((Throwable)e);
        }
    }

    private void setCraftingMaterial(BlockItemHolder item) {
        BlockItemHolder old = ((ToolMaterial)this.object).customCraftingMaterial;
        if (old != null) {
            old.removeUpdateListener((UpdateListener)this);
        }
        if (item != null) {
            this.jButton1.setText(item.getName());
            if (item.getTexture() != null) {
                if (item.getTexture().getImage() != null) {
                    this.jButton1.setIcon(new ImageIcon(item.getTexture().getImage()));
                } else {
                    this.jButton1.setIcon(null);
                }
            } else {
                this.jButton1.setIcon(null);
            }
            item.addUpdateListener((UpdateListener)this);
        } else {
            this.jButton1.setText("<none>");
            this.jButton1.setIcon(null);
        }
    }

    public void Save() {
        ToolMaterial material = (ToolMaterial)this.object;
        material.harvestLevel = this.jSpinner1.getValue().hashCode();
        material.maxUses = this.jSpinner2.getValue().hashCode();
        material.StrengthVsBlock = this.jSpinner3.getValue().hashCode();
        material.StrengthVsEntity = this.jSpinner4.getValue().hashCode();
        material.enchanteability = this.jSpinner5.getValue().hashCode();
    }

    public void Load() {
        ToolMaterial material = (ToolMaterial)this.object;
        if (material.getName() == null) {
            material.setName(ToolMaterial.getToolMaterialName("Tool_Material", material.getMod()));
        }
        this.jTextField1.setText(material.getName());
        this.jSpinner1.setValue(material.harvestLevel);
        this.jSpinner2.setValue(material.maxUses);
        this.jSpinner3.setValue(material.StrengthVsBlock);
        this.jSpinner4.setValue(material.StrengthVsEntity);
        this.jSpinner5.setValue(material.enchanteability);
        if (material.customCraftingMaterial != null) {
            material.customCraftingMaterial.addUpdateListener(new UpdateListener(){

                public void onUpdate(UpdateEvent event) {
                    ToolMaterialPanel.this.setCraftingMaterial(((ToolMaterial)ToolMaterialPanel.this.object).customCraftingMaterial);
                }
            });
            if (material.customCraftingMaterial.isInitialized()) {
                this.setCraftingMaterial(material.customCraftingMaterial);
            }
        }
    }

    public void onUpdate(UpdateEvent event) {
        BlockItemHolder item = ((ToolMaterial)this.object).customCraftingMaterial;
        if (item != null) {
            if (item.getTexture() != null) {
                if (item.getTexture().getImage() != null) {
                    this.jButton1.setIcon(new ImageIcon(item.getTexture().getImage()));
                } else {
                    this.jButton1.setIcon(null);
                }
            } else {
                this.jButton1.setIcon(null);
            }
            this.jButton1.setText(item.getName());
        }
    }
}

