/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class ProgramUpdater {
    public static void main(String[] arg) {
        int a;
        String value;
        String cmd;
        String[] args;
        File f = new File("Update.dat");
        for (String str : arg) {
            try {
                if (!str.contains(":")) continue;
                args = str.split(":");
                cmd = args[0];
                value = args[1];
                for (a = 2; a < args.length; ++a) {
                    value = value + ":" + args[a];
                }
                if (cmd.equalsIgnoreCase("Rename")) {
                    ProgramUpdater.Rename(value);
                    continue;
                }
                if (cmd.equalsIgnoreCase("Copy")) {
                    ProgramUpdater.Copy(value);
                    continue;
                }
                if (cmd.equalsIgnoreCase("Delete")) {
                    ProgramUpdater.Delete(value);
                    continue;
                }
                if (cmd.equalsIgnoreCase("Run")) {
                    ProgramUpdater.Run(value);
                    continue;
                }
                if (!cmd.equalsIgnoreCase("Batch")) continue;
                f = new File(value);
            }
            catch (Throwable e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                JOptionPane.showMessageDialog(null, "Something went wrong:\n\n" + sw.toString(), "Error", 0);
                System.exit(1);
            }
        }
        if (!f.exists()) {
            System.out.println("Deathly's Mod Editor: Program Updater 1.0");
            System.out.println("Copyright \u00a9 Deathlykiller. All rights reserved");
            System.out.println();
            System.out.println("Usage: <cmd>:<value>");
            System.out.println("-----------------------------");
            System.out.println("| cmd     |  value          |");
            System.out.println("-----------------------------");
            System.out.println("| Rename  | [file1]>[file2] |");
            System.out.println("| Copy    | [file1]>[file2] |");
            System.out.println("| Delete  | [file1]         |");
            System.out.println("| Run     | [program]       |");
            System.out.println("| Batch   | [file]          |");
            System.out.println("-----------------------------");
            System.out.println("Example:");
            System.out.println("  1. Rename:C:/someFile.txt>C:/nowItisThis.yml");
            System.out.println("  2. Copy:C:/someFile.txt>C:/nowItisThis.yml");
            System.out.println("  3. Delete:C:/someFile.txt");
            System.out.println("  4. Run:\"C:/Program Files/Java/jre7/bin/java.exe\" \"-jar\" \"someJar.jar\"");
            System.out.println("  5. Batch:C:/Update.dat");
        } else {
            try {
                String line;
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                File parentIsRunning = new File("temp.temp");
                BufferedReader bf = new BufferedReader(new FileReader(f));
                int tick = 0;
                while (parentIsRunning.exists()) {
                    Thread.sleep(10L);
                    if (++tick <= 500) continue;
                }
                Thread.sleep(1000L);
                while ((line = bf.readLine()) != null) {
                    if (!line.contains(":")) continue;
                    args = line.split(":");
                    cmd = args[0];
                    value = args[1];
                    for (a = 2; a < args.length; ++a) {
                        value = value + ":" + args[a];
                    }
                    if (cmd.equalsIgnoreCase("Rename")) {
                        ProgramUpdater.Rename(value);
                        continue;
                    }
                    if (cmd.equalsIgnoreCase("Copy")) {
                        ProgramUpdater.Copy(value);
                        continue;
                    }
                    if (cmd.equalsIgnoreCase("Delete")) {
                        ProgramUpdater.Delete(value);
                        continue;
                    }
                    if (!cmd.equalsIgnoreCase("Run")) continue;
                    ProgramUpdater.Run(value);
                }
                bf.close();
                Runtime.getRuntime().exec("java -jar \"Deathly's Mod Editor.jar\"");
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                JOptionPane.showMessageDialog(null, "Something went wrong:\n\n" + sw.toString(), "Error", 0);
            }
            f.delete();
        }
    }

    private static void Rename(String value) {
        String[] args = value.split(">");
        String fName1 = args[0];
        String fName2 = args[1];
        File f1 = new File(fName1);
        if (!f1.exists()) {
            JOptionPane.showMessageDialog(null, "Something went wrong:\n\nCannot Find File:\n" + f1.getPath(), "Error", 0);
            System.exit(1);
        }
        File f2 = new File(fName2);
        f2.getParentFile().mkdirs();
        boolean succeed = f1.renameTo(f2);
        if (!succeed) {
            JOptionPane.showMessageDialog(null, "Something went wrong:\n\nFailed to rename File:\n" + f1.getPath() + "\n\nTo:\n" + f2.getPath(), "Error", 0);
            System.exit(1);
        }
    }

    private static void Copy(String value) throws IOException {
        String[] args = value.split(">");
        String fName1 = args[0];
        String fName2 = args[1];
        File f1 = new File(fName1);
        if (!f1.exists()) {
            JOptionPane.showMessageDialog(null, "Something went wrong:\n\nCannot Find File:\n" + f1.getPath(), "Error", 0);
            System.exit(1);
        }
        File f2 = new File(fName2);
        f2.getParentFile().mkdirs();
        FileInputStream in = new FileInputStream(f1);
        FileOutputStream out = new FileOutputStream(f2);
        byte[] buffer = new byte[1024];
        int i = 0;
        while (((InputStream)in).read(buffer, i, 1024) != -1) {
            ((OutputStream)out).write(buffer, i, 1024);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private static void Delete(String value) {
        String fName1 = value;
        File f1 = new File(fName1);
        f1.delete();
    }

    private static void Run(String program) throws IOException, InterruptedException {
        String line;
        Process p = Runtime.getRuntime().exec(program);
        BufferedReader bf = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = bf.readLine()) != null) {
            System.out.println(line);
        }
        int ret = p.exitValue();
        if (ret != 0) {
            throw new IOException("Program failed to run: " + program);
        }
    }
}

