/*
 * Decompiled with CFR 0.152.
 */
package mickkay.scenter;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.io.File;
import java.io.IOException;
import mickkay.scenter.PlayerLoggedInEventHandler;
import mickkay.scenter.ScenterMod;
import mickkay.scenter.config.ScenterModConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CommonProxy {
    private static final String MINECRAFT_KEY_PREFIX = "minecraft:";
    protected final Logger logger = LogManager.getLogger((String)ScenterMod.class.getName());
    protected File standardConfigFile;
    protected ScenterModConfig config = null;
    private boolean enabled;
    private int detectionRadius;

    public void init(File standardConfigFile) throws Exception {
        this.standardConfigFile = standardConfigFile;
        this.reloadConfiguration();
    }

    protected void reloadConfiguration() throws IOException {
        this.logger.info(String.format("Loading configuration", new Object[0]));
        this.config = new ScenterModConfig(this.standardConfigFile);
        this.enabled = this.config.isEnabled();
        this.detectionRadius = this.config.getDetectionRadius();
        this.config.save();
    }

    public void registerEventHandlers() {
        FMLCommonHandler.instance().bus().register((Object)new PlayerLoggedInEventHandler());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getDetectionRadius() {
        return this.detectionRadius;
    }

    public void setDetectionRadius(int scanRadius) {
        this.detectionRadius = scanRadius;
    }

    public abstract void onSingleplayerLoggedIn(PlayerEvent.PlayerLoggedInEvent var1);
}

