/*
 * Decompiled with CFR 0.152.
 */
package mickkay.scenter.config.defaults;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class Defaults {
    private static final String COLOR_GOLD = "FFFF47";
    private static final String COLOR_IRON = "FFD9B3";
    private static final String COLOR_COAL = "000000";
    private static final String COLOR_LAPIS = "0A0AFF";
    private static final String COLOR_DIAMOND = "85FFFF";
    private static final String COLOR_REDSTONE = "FF0A0A";
    private static final String COLOR_GLOWSTONE = "FFD24D";
    private static final String COLOR_EMERALD = "80FF9F";
    private static final String COLOR_NETHER_QUARZ = "BAA882";
    private Map<String, BlockDefault> map = new LinkedHashMap<String, BlockDefault>();

    public Defaults() {
        this.addBlock(Blocks.field_150365_q, COLOR_COAL);
        this.addBlock(Blocks.field_150366_p, COLOR_IRON);
        this.addBlock(Blocks.field_150352_o, COLOR_GOLD);
        this.addBlock(Blocks.field_150482_ag, COLOR_DIAMOND);
        this.addBlock(Blocks.field_150412_bA, COLOR_EMERALD);
        this.addBlock(Blocks.field_150369_x, COLOR_LAPIS);
        this.addBlock(new Block[]{Blocks.field_150450_ax, Blocks.field_150439_ay}, COLOR_REDSTONE, "and Glowing Redstone");
        this.addBlock(Blocks.field_150426_aN, COLOR_GLOWSTONE);
        this.addBlock(Blocks.field_150449_bY, COLOR_NETHER_QUARZ);
    }

    private void addBlock(Block block, String color) {
        BlockDefault entry = new BlockDefault(new Block[]{block}, color);
        this.map.put(this.getName(block), entry);
    }

    private void addBlock(Block block, String color, String comment) {
        BlockDefault entry = new BlockDefault(new Block[]{block}, color, comment);
        this.map.put(this.getName(block), entry);
    }

    private void addBlock(Block[] block, String color, String comment) {
        BlockDefault entry = new BlockDefault(block, color, comment);
        this.map.put(this.getName(block[0]), entry);
    }

    public BlockDefault getBlockDefault(int blockId) {
        return this.map.get(blockId);
    }

    public Collection<BlockDefault> getBlockDefaults() {
        return this.map.values();
    }

    private String getName(Block block) {
        return Block.field_149771_c.func_148750_c((Object)block);
    }

    public static class BlockDefault {
        public final Block[] block;
        public final String comment;
        public final String color;

        public BlockDefault(Block[] block, String color) {
            this.block = block;
            this.color = color;
            this.comment = null;
        }

        public BlockDefault(Block[] block, String color, String comment) {
            this.block = block;
            this.comment = comment;
            this.color = color;
        }
    }
}

