/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.modules;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.darkhax.wawla.modules.Module;
import net.darkhax.wawla.util.Utilities;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class ModuleEntityEquipment
extends Module {
    private static String[] itemTypes = new String[]{"heldItem", "feet", "leggings", "chestplate", "helmet"};

    public ModuleEntityEquipment(boolean enabled) {
        super(enabled);
    }

    @Override
    public void onWailaEntityDescription(Entity entity, List<String> tooltip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        if (entity instanceof EntityLiving && config.getConfig("wawla.showEquipment")) {
            String ench = StatCollector.func_74838_a((String)"tooltip.wawla") + ": ";
            EntityLiving living = (EntityLiving)entity;
            for (int i = 0; i < 5; ++i) {
                ItemStack stack = living.func_71124_b(i);
                if (stack == null) continue;
                tooltip.add(StatCollector.func_74838_a((String)("tooltip.waila." + itemTypes[i])) + ": " + stack.func_82833_r());
                Enchantment[] enchantments = Utilities.getEnchantmentsFromStack(stack, false);
                if (!accessor.getPlayer().func_70093_af()) continue;
                for (int x = 0; x < enchantments.length; ++x) {
                    String name = StatCollector.func_74838_a((String)enchantments[x].func_77320_a());
                    if (ench.contains(name)) continue;
                    ench = ench + name + ", ";
                }
            }
            if (accessor.getPlayer().func_70093_af() && !ench.equals("Enchantments: ")) {
                ench = ench.substring(0, ench.length() - 2);
            }
        }
    }

    @Override
    public void onWailaRegistrar(IWailaRegistrar register) {
        register.addConfig("Wawla", "wawla.showEquipment");
    }
}

