/*
 * Decompiled with CFR 0.152.
 */
package com.aesireanempire.eplus;

import com.aesireanempire.eplus.Events;
import com.aesireanempire.eplus.api.EplusPlugin;
import com.aesireanempire.eplus.blocks.Blocks;
import com.aesireanempire.eplus.commands.EplusCommands;
import com.aesireanempire.eplus.handlers.ConfigurationHandler;
import com.aesireanempire.eplus.handlers.LanguageHandler;
import com.aesireanempire.eplus.handlers.PluginHandler;
import com.aesireanempire.eplus.handlers.Version;
import com.aesireanempire.eplus.inventory.TileEnchantTable;
import com.aesireanempire.eplus.items.Items;
import com.aesireanempire.eplus.lib.EnchantmentHelp;
import com.aesireanempire.eplus.network.GuiHandler;
import com.aesireanempire.eplus.network.packets.ChannelHandler;
import com.aesireanempire.eplus.network.packets.IPacket;
import com.aesireanempire.eplus.network.proxies.CommonProxy;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Logger;

@Mod(name="Enchanting Plus", modid="eplus")
public class EnchantingPlus {
    public static final boolean Debug = Boolean.parseBoolean(System.getenv("DEBUG"));
    @Mod.Instance(value="eplus")
    public static EnchantingPlus INSTANCE;
    public static Logger log;
    @SidedProxy(clientSide="com.aesireanempire.eplus.network.proxies.ClientProxy", serverSide="com.aesireanempire.eplus.network.proxies.CommonProxy")
    public static CommonProxy proxy;
    public static Map<Integer, String> itemMap;
    private static EnumMap<Side, FMLEmbeddedChannel> channels;

    public static void sendPacketToServer(IPacket packet) {
        channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        channels.get(Side.CLIENT).writeOutbound(new Object[]{packet});
    }

    public static void sendPacketToPlayer(IPacket packet, EntityPlayer player) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        channels.get(Side.SERVER).writeOutbound(new Object[]{packet});
    }

    public static void sendPacketToAllClients(IPacket packet) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        channels.get(Side.SERVER).writeOutbound(new Object[]{packet});
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.registerTileEntity(TileEnchantTable.class);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)new GuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new Events());
        channels = NetworkRegistry.INSTANCE.newChannel("eplus", new io.netty.channel.ChannelHandler[]{new ChannelHandler()});
        proxy.registerTickHandlers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        NBTTagList list = new NBTTagList();
        PluginHandler.initPlugins(event.getModState());
        ConfigurationHandler.loadEnchantments();
        proxy.registerEnchantments();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        log = event.getModLog();
        ConfigurationHandler.init(event.getSuggestedConfigurationFile());
        Version.init(event.getVersionProperties());
        Version.check();
        event.getModMetadata().version = Version.getCurrentModVersion().toString();
        PluginHandler.init(event.getAsmData().getAll(EplusPlugin.class.getCanonicalName()));
        PluginHandler.initPlugins(event.getModState());
        try {
            LanguageHandler.getInstance().addLanguages("/assets/eplus/lang/langs.txt");
        }
        catch (NullPointerException e) {
            log.error(String.format("Can not load %s", "/assets/eplus/lang/langs.txt"));
        }
        LanguageHandler.getInstance().loadLangauges();
        Blocks.init();
        Items.init();
    }

    @Mod.EventHandler
    public void processIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage imcMessage : event.getMessages()) {
            String name;
            NBTTagCompound nbtBase;
            int i;
            NBTTagList enchantments;
            NBTTagCompound nbtValue;
            if (imcMessage.key.equalsIgnoreCase("enchant-tooltip")) {
                if (imcMessage.isStringMessage()) {
                    String[] strings = imcMessage.getStringValue().split(":");
                    if (!EnchantmentHelp.putToolTips(strings[0], strings[1])) continue;
                    log.info(String.format("Add custom enchantment tool-tip for %s. Request sent from %s", strings[0], imcMessage.getSender()));
                    continue;
                }
                if (imcMessage.isNBTMessage()) {
                    nbtValue = imcMessage.getNBTValue();
                    enchantments = nbtValue.func_150295_c("Enchantments", 10);
                    for (i = 0; i < enchantments.func_74745_c(); ++i) {
                        String description;
                        nbtBase = enchantments.func_150305_b(i);
                        name = nbtBase.func_74779_i("Name");
                        if (!EnchantmentHelp.putToolTips(name, description = nbtBase.func_74779_i("Description"))) continue;
                        log.info(String.format("Add custom enchantment tool-tip for %s. Request sent from %s", name, imcMessage.getSender()));
                    }
                    continue;
                }
                log.warn(String.format("Invalid IMC Message from %s", imcMessage.getSender()));
                continue;
            }
            if (imcMessage.key.equalsIgnoreCase("blacklist-enchantment")) {
                if (imcMessage.isStringMessage()) {
                    String string = imcMessage.getStringValue();
                    if (!EnchantmentHelp.putBlackList(string)) continue;
                    log.info(String.format("Add custom enchantment blacklist for %s. Request sent from %s", string, imcMessage.getSender()));
                    continue;
                }
                if (imcMessage.isNBTMessage()) {
                    nbtValue = imcMessage.getNBTValue();
                    enchantments = nbtValue.func_150295_c("Enchantments", 10);
                    for (i = 0; i < enchantments.func_74745_c(); ++i) {
                        nbtBase = enchantments.func_150305_b(i);
                        name = nbtBase.func_74779_i("Name");
                        if (!EnchantmentHelp.putBlackList(name)) continue;
                        log.info(String.format("Add custom enchantment blacklist for %s. Request sent from %s", name, imcMessage.getSender()));
                    }
                    continue;
                }
                log.warn(String.format("Invalid IMC Message from %s", imcMessage.getSender()));
                continue;
            }
            if (!imcMessage.key.equalsIgnoreCase("blacklist-item")) continue;
            if (imcMessage.isStringMessage()) {
                Integer itemId = Integer.valueOf(imcMessage.getStringValue());
                if (!EnchantmentHelp.putBlackListItem(itemId)) continue;
                log.info(String.format("Add custom item blacklist for item id %d. Request sent from %s", itemId, imcMessage.getSender()));
                continue;
            }
            if (imcMessage.isNBTMessage()) {
                nbtValue = imcMessage.getNBTValue();
                enchantments = nbtValue.func_150295_c("items", 10);
                for (i = 0; i < enchantments.func_74745_c(); ++i) {
                    nbtBase = enchantments.func_150305_b(i);
                    Integer itemId = Integer.valueOf(nbtBase.func_74779_i("itemId"));
                    if (!EnchantmentHelp.putBlackListItem(itemId)) continue;
                    log.info(String.format("Add custom item blacklist for item id %d. Request sent from %s", itemId, imcMessage.getSender()));
                }
                continue;
            }
            log.warn(String.format("Invalid IMC Message from %s", imcMessage.getSender()));
        }
    }

    private void registerTileEntity(Class<? extends TileEntity> tileEntity) {
        GameRegistry.registerTileEntity(tileEntity, (String)("eplus:" + tileEntity.getSimpleName()));
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new EplusCommands());
    }

    static {
        itemMap = new HashMap<Integer, String>();
    }
}

