/*
 * Decompiled with CFR 0.152.
 */
package com.aesireanempire.eplus.inventory;

import com.aesireanempire.eplus.helper.EnchantHelper;
import com.aesireanempire.eplus.inventory.SlotEnchant;
import com.aesireanempire.eplus.inventory.SlotEnchantTable;
import com.aesireanempire.eplus.inventory.TileEnchantTable;
import com.aesireanempire.eplus.lib.ConfigurationSettings;
import com.aesireanempire.eplus.lib.EnchantmentHelp;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class ContainerEnchantTable
extends Container {
    public final World worldObj;
    public final IInventory tableInventory = new SlotEnchantTable(this, "Enchant", true, 1);
    final TileEnchantTable tileEnchantTable;
    private final int xPos;
    private final int yPos;
    private final int zPos;
    private final EntityPlayer player;
    private Map<Integer, Integer> enchantments;

    public ContainerEnchantTable(InventoryPlayer par1InventoryPlayer, World par2World, int par3, int par4, int par5, TileEnchantTable tileEntity) {
        int l;
        this.worldObj = par2World;
        this.xPos = par3;
        this.yPos = par4;
        this.zPos = par5;
        this.tileEnchantTable = tileEntity;
        this.player = par1InventoryPlayer.field_70458_d;
        int guiOffest = 26;
        this.func_75146_a(new SlotEnchant(this, this.tableInventory, 0, 11 + guiOffest, 17));
        for (l = 0; l < 3; ++l) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.func_75146_a(new Slot((IInventory)par1InventoryPlayer, i1 + l * 9 + 9, 17 + i1 * 18 + guiOffest, 91 + l * 18));
            }
        }
        for (l = 0; l < 9; ++l) {
            this.func_75146_a(new Slot((IInventory)par1InventoryPlayer, l, 17 + l * 18 + guiOffest, 149));
        }
        for (int k = 0; k < 4; ++k) {
            final int armorType = k;
            this.func_75146_a(new Slot((IInventory)par1InventoryPlayer, 39 - k, 7, 24 + k * 19){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(ItemStack par1ItemStack) {
                    Item item = par1ItemStack == null ? null : par1ItemStack.func_77973_b();
                    return item != null && item.isValidArmor(par1ItemStack, armorType, (Entity)ContainerEnchantTable.this.player);
                }
            });
        }
        if (this.tileEnchantTable.itemInTable != null) {
            this.player.func_70099_a(this.tileEnchantTable.itemInTable, 0.2f);
            this.tileEnchantTable.itemInTable = null;
        }
        this.enchantments = new HashMap<Integer, Integer>();
    }

    public float bookCases() {
        float temp = ConfigurationSettings.minimumBook;
        for (int j = -1; j <= 1; ++j) {
            for (int k = -1; k <= 1; ++k) {
                if (j == 0 && k == 0 || !this.worldObj.func_147437_c(this.xPos + k, this.yPos, this.zPos + j) || !this.worldObj.func_147437_c(this.xPos + k, this.yPos + 1, this.zPos + j)) continue;
                temp += ForgeHooks.getEnchantPower((World)this.worldObj, (int)(this.xPos + k * 2), (int)this.yPos, (int)(this.zPos + j * 2));
                temp += ForgeHooks.getEnchantPower((World)this.worldObj, (int)(this.xPos + k * 2), (int)(this.yPos + 1), (int)(this.zPos + j * 2));
                if (k == 0 || j == 0) continue;
                temp += ForgeHooks.getEnchantPower((World)this.worldObj, (int)(this.xPos + k * 2), (int)this.yPos, (int)(this.zPos + j));
                temp += ForgeHooks.getEnchantPower((World)this.worldObj, (int)(this.xPos + k * 2), (int)(this.yPos + 1), (int)(this.zPos + j));
                temp += ForgeHooks.getEnchantPower((World)this.worldObj, (int)(this.xPos + k), (int)this.yPos, (int)(this.zPos + j * 2));
                temp += ForgeHooks.getEnchantPower((World)this.worldObj, (int)(this.xPos + k), (int)(this.yPos + 1), (int)(this.zPos + j * 2));
            }
        }
        return temp * 2.0f;
    }

    public boolean func_75145_c(EntityPlayer par1EntityPlayer) {
        return par1EntityPlayer.func_70092_e((double)this.xPos + 0.5, (double)this.yPos + 0.5, (double)this.zPos + 0.5) <= 64.0 && !par1EntityPlayer.field_70128_L;
    }

    public boolean canPurchase(EntityPlayer player, int cost) throws Exception {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (ConfigurationSettings.needsBookShelves && (float)cost > this.bookCases()) {
            throw new Exception("Not enough bookcases. Required " + cost);
        }
        if (player.field_71068_ca < cost) {
            throw new Exception("Not enough levels. Required " + cost);
        }
        return true;
    }

    public void checkItems() {
        if (!ItemStack.func_77989_b((ItemStack)this.tileEnchantTable.itemInTable, (ItemStack)this.tableInventory.func_70301_a(0))) {
            this.func_75141_a(0, this.tileEnchantTable.itemInTable);
            this.worldObj.func_147471_g(this.tileEnchantTable.field_145851_c, this.tileEnchantTable.field_145848_d, this.tileEnchantTable.field_145849_e);
            this.func_75130_a(this.tableInventory);
        }
    }

    public int disenchantmentCost(int enchantmentId, int enchantmentLevel, Integer level) {
        ItemStack itemStack = this.tableInventory.func_70301_a(0);
        if (itemStack == null) {
            return 0;
        }
        Enchantment enchantment = Enchantment.field_77331_b[enchantmentId];
        int maxLevel = enchantment.func_77325_b();
        if (enchantmentLevel > maxLevel) {
            return 0;
        }
        int averageCost = (enchantment.func_77321_a(level.intValue()) + enchantment.func_77317_b(level.intValue())) / 2;
        int enchantability = itemStack.func_77973_b().func_77619_b();
        if (enchantability <= 1) {
            enchantability = 10;
        }
        int adjustedCost = (int)((double)(averageCost * (enchantmentLevel - level - maxLevel)) / ((double)maxLevel * (double)enchantability));
        if (!ConfigurationSettings.needsBookShelves) {
            int temp = (int)((float)adjustedCost * (60.0f / (this.bookCases() + 1.0f)));
            if ((temp /= 20) > adjustedCost) {
                adjustedCost = temp;
            }
        }
        adjustedCost = (int)((double)adjustedCost * ((double)ConfigurationSettings.CostFactor / 4.0));
        adjustedCost = enchantability > 1 ? (int)((double)adjustedCost * (Math.log(enchantability) / 2.0)) : (adjustedCost /= 10);
        int enchantmentCost = this.enchantmentCost(enchantmentId, level - 1, enchantmentLevel);
        return Math.min(adjustedCost, -enchantmentCost);
    }

    public void enchant(EntityPlayer player, HashMap<Integer, Integer> map, HashMap<Integer, Integer> levels, int cost) throws Exception {
        Integer level;
        ItemStack itemstack = this.tableInventory.func_70301_a(0);
        HashMap<Integer, Integer> temp = new HashMap<Integer, Integer>();
        int serverCost = 0;
        if (itemstack == null) {
            return;
        }
        for (Integer enchantId : map.keySet()) {
            level = map.get(enchantId);
            Integer startingLevel = this.enchantments.get(enchantId);
            if (level > startingLevel) {
                serverCost += this.enchantmentCost(enchantId, level, startingLevel);
                continue;
            }
            if (level >= startingLevel) continue;
            serverCost += this.disenchantmentCost(enchantId, level, startingLevel);
        }
        if (cost != serverCost) {
            throw new Exception("Cost is different on client and server");
        }
        for (Integer enchantId : this.enchantments.keySet()) {
            level = this.enchantments.get(enchantId);
            if (level == 0 || map.containsKey(enchantId)) continue;
            map.put(enchantId, level);
        }
        for (Integer enchantId : map.keySet()) {
            level = map.get(enchantId);
            if (level != 0) continue;
            temp.put(enchantId, level);
        }
        for (Integer object : temp.keySet()) {
            map.remove(object);
        }
        if (this.canPurchase(player, serverCost)) {
            ItemStack itemStack = EnchantHelper.setEnchantments(map, itemstack, levels, player);
            this.tableInventory.func_70299_a(0, itemStack);
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_82242_a(-cost);
            }
        }
        this.func_75130_a(this.tableInventory);
    }

    public int enchantmentCost(int enchantmentId, int enchantmentLevel, Integer level) {
        ItemStack itemStack = this.tableInventory.func_70301_a(0);
        if (itemStack == null) {
            return 0;
        }
        Enchantment enchantment = Enchantment.field_77331_b[enchantmentId];
        int maxLevel = enchantment.func_77325_b();
        if (enchantmentLevel > maxLevel) {
            return 0;
        }
        int averageCost = (enchantment.func_77321_a(enchantmentLevel) + enchantment.func_77317_b(enchantmentLevel)) / 2;
        int enchantability = itemStack.func_77973_b().func_77619_b();
        if (enchantability < 1) {
            enchantability = 1;
        }
        int adjustedCost = (int)((double)(averageCost * (enchantmentLevel - level + maxLevel)) / ((double)maxLevel * (double)enchantability));
        if (!ConfigurationSettings.needsBookShelves) {
            int temp = (int)((float)adjustedCost * (60.0f / (this.bookCases() + 1.0f)));
            if ((temp /= 20) > adjustedCost) {
                adjustedCost = temp;
            }
        }
        adjustedCost = (int)((double)adjustedCost * ((double)ConfigurationSettings.CostFactor / 3.0));
        adjustedCost = enchantability > 1 ? (int)((double)adjustedCost * (Math.log(enchantability) / 2.0)) : (adjustedCost /= 10);
        return Math.max(1, adjustedCost);
    }

    public Map<Integer, Integer> getEnchantments() {
        return this.enchantments;
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        super.func_75134_a(par1EntityPlayer);
        for (int i = 0; i < this.tableInventory.func_70302_i_(); ++i) {
            ItemStack stack = this.tableInventory.func_70301_a(i);
            if (stack == null || par1EntityPlayer.field_71071_by.func_70441_a(stack)) continue;
            par1EntityPlayer.func_70099_a(stack, 0.2f);
        }
    }

    public void func_75130_a(IInventory par1IInventory) {
        super.func_75130_a(par1IInventory);
        this.tileEnchantTable.func_145831_w().func_147471_g(this.tileEnchantTable.field_145851_c, this.tileEnchantTable.field_145848_d, this.tileEnchantTable.field_145849_e);
        this.readItems();
    }

    private void readItems() {
        ItemStack itemStack = this.tableInventory.func_70301_a(0);
        LinkedHashMap<Integer, Integer> temp = new LinkedHashMap<Integer, Integer>();
        LinkedHashMap<Integer, Integer> temp2 = new LinkedHashMap<Integer, Integer>();
        if (itemStack != null && !EnchantmentHelp.isBlackListed(itemStack.func_77973_b())) {
            if (EnchantHelper.isItemEnchantable(itemStack)) {
                this.addEnchantsFor(itemStack, temp);
            } else if (EnchantHelper.isItemEnchanted(itemStack) && EnchantHelper.isNewItemEnchantable(itemStack.func_77973_b())) {
                temp.putAll(EnchantmentHelper.func_82781_a((ItemStack)itemStack));
                for (Enchantment obj : Enchantment.field_77331_b) {
                    if (obj == null) continue;
                    boolean add = true;
                    for (Object enc : ((HashMap)temp).keySet()) {
                        Enchantment enchantment = Enchantment.field_77331_b[(Integer)enc];
                        if (enchantment == null || obj.func_77326_a(enchantment) && enchantment.func_77326_a(obj)) continue;
                        add = false;
                    }
                    if (!add) continue;
                    this.addEnchantFor(itemStack, temp2, obj);
                }
                temp.putAll(temp2);
            }
            if (this.enchantments != temp) {
                this.enchantments = temp;
            }
        } else {
            this.enchantments = temp;
        }
    }

    private void addEnchantsFor(ItemStack itemStack, HashMap<Integer, Integer> temp) {
        for (Enchantment obj : Enchantment.field_77331_b) {
            this.addEnchantFor(itemStack, temp, obj);
        }
    }

    private void addEnchantFor(ItemStack itemStack, HashMap<Integer, Integer> temp, Enchantment obj) {
        if (obj != null && EnchantHelper.canEnchantItem(itemStack, obj) && !EnchantmentHelp.isBlackListed(obj)) {
            temp.put(obj.field_77352_x, 0);
        }
    }

    public void repair(EntityPlayer player, int cost, int amount) throws Exception {
        ItemStack itemStack = this.tableInventory.func_70301_a(0);
        boolean flag = true;
        if (itemStack == null) {
            return;
        }
        if (itemStack.func_77942_o()) {
            flag = !itemStack.func_77978_p().func_74764_b("charge");
        }
        int serverCost = this.repairCost(player);
        if ((!itemStack.func_77948_v() || serverCost == 0) && flag) {
            return;
        }
        if (this.canPurchase(player, serverCost)) {
            int maxCost = this.repairCostMax(player);
            double percAmnt = (double)serverCost / (double)maxCost;
            int remain = itemStack.func_77952_i();
            int maxDamage = itemStack.func_77958_k();
            double remainNet = (double)remain * percAmnt;
            double newDamage = (double)remain - remainNet;
            newDamage = newDamage <= 0.0 ? 0.0 : newDamage;
            itemStack.func_77964_b((int)newDamage);
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_82242_a(-serverCost);
            }
        }
        this.func_75130_a(this.tableInventory);
    }

    public int repairCostMax(EntityPlayer player) {
        ItemStack itemStack = this.tableInventory.func_70301_a(0);
        if (itemStack == null) {
            return 0;
        }
        if (!itemStack.func_77948_v() || !itemStack.func_77951_h()) {
            return 0;
        }
        int cost = 0;
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
        for (Integer enchantment : enchantments.keySet()) {
            Integer enchantmentLevel = (Integer)enchantments.get(enchantment);
            cost += this.enchantmentCost(enchantment, enchantmentLevel, 0);
        }
        int maxDamage = itemStack.func_77958_k();
        int displayDamage = itemStack.func_77952_i();
        int enchantability = itemStack.func_77973_b().func_77619_b();
        if (enchantability <= 1) {
            enchantability = 10;
        }
        double percentDamage = 1.0 - (double)(maxDamage - displayDamage) / (double)maxDamage;
        double totalCost = percentDamage * (double)cost / (double)enchantability;
        return (int)Math.max(1.0, totalCost *= (double)(2 * ConfigurationSettings.RepairFactor));
    }

    public int repairCost(EntityPlayer player) {
        int costMax = this.repairCostMax(player);
        if (costMax == 0) {
            return 0;
        }
        if (player.field_71075_bZ.field_75098_d) {
            return costMax;
        }
        return Math.min(player.field_71068_ca, costMax);
    }

    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int par2) {
        ItemStack itemStack = null;
        Slot slot = (Slot)this.field_75151_b.get(par2);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            ItemStack tempStack = stack.func_77946_l();
            itemStack = stack.func_77946_l();
            tempStack.field_77994_a = 1;
            if (par2 != 0) {
                Slot slot1 = (Slot)this.field_75151_b.get(0);
                if (!slot1.func_75216_d() && slot1.func_75214_a(tempStack) && this.func_75135_a(tempStack, 0, 1, false)) {
                    --stack.field_77994_a;
                    itemStack = stack.func_77946_l();
                }
            } else if (!this.mergeItemStack2(stack)) {
                return null;
            }
            if (stack.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (itemStack.field_77994_a == stack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(par1EntityPlayer, stack);
        }
        return itemStack;
    }

    private boolean mergeItemStack2(ItemStack stack) {
        ItemStack itemstack1;
        Slot slot;
        int k;
        boolean flag1 = false;
        if (stack.func_77985_e()) {
            for (k = 40; stack.field_77994_a > 0 && k >= 1; --k) {
                slot = (Slot)this.field_75151_b.get(k);
                itemstack1 = slot.func_75211_c();
                if (itemstack1 == null || itemstack1 != stack || stack.func_77981_g() && stack.func_77960_j() != itemstack1.func_77960_j() || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack1)) continue;
                int l = itemstack1.field_77994_a + stack.field_77994_a;
                if (l <= stack.func_77976_d()) {
                    stack.field_77994_a = 0;
                    itemstack1.field_77994_a = l;
                    slot.func_75218_e();
                    flag1 = true;
                    continue;
                }
                if (itemstack1.field_77994_a >= stack.func_77976_d()) continue;
                stack.field_77994_a -= stack.func_77976_d() - itemstack1.field_77994_a;
                itemstack1.field_77994_a = stack.func_77976_d();
                slot.func_75218_e();
                flag1 = true;
            }
        }
        if (stack.field_77994_a > 0) {
            for (k = 40; k >= 1; --k) {
                slot = (Slot)this.field_75151_b.get(k);
                itemstack1 = slot.func_75211_c();
                if (itemstack1 != null || !slot.func_75214_a(stack)) continue;
                slot.func_75215_d(stack.func_77946_l());
                slot.func_75218_e();
                stack.field_77994_a = 0;
                flag1 = true;
                break;
            }
        }
        return flag1;
    }

    public boolean currentItemIs(Item item) {
        ItemStack itemStack = this.tableInventory.func_70301_a(0);
        return itemStack != null && item.equals(itemStack.func_77973_b());
    }
}

