/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl;

import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.utils.NBTUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class DataAccessorEntity
implements IWailaEntityAccessor {
    public World world;
    public EntityPlayer player;
    public MovingObjectPosition mop;
    public Vec3 renderingvec = null;
    public Entity entity;
    public NBTTagCompound remoteNbt = null;
    public long timeLastUpdate = System.currentTimeMillis();
    public double partialFrame;
    public static DataAccessorEntity instance = new DataAccessorEntity();

    public void set(World _world, EntityPlayer _player, MovingObjectPosition _mop) {
        this.set(_world, _player, _mop, null, 0.0);
    }

    public void set(World _world, EntityPlayer _player, MovingObjectPosition _mop, EntityLivingBase viewEntity, double partialTicks) {
        this.world = _world;
        this.player = _player;
        this.mop = _mop;
        this.entity = _mop.field_72308_g;
        if (viewEntity != null) {
            double px = viewEntity.field_70142_S + (viewEntity.field_70165_t - viewEntity.field_70142_S) * partialTicks;
            double py = viewEntity.field_70137_T + (viewEntity.field_70163_u - viewEntity.field_70137_T) * partialTicks;
            double pz = viewEntity.field_70136_U + (viewEntity.field_70161_v - viewEntity.field_70136_U) * partialTicks;
            this.renderingvec = Vec3.func_72443_a((double)((double)_mop.field_72311_b - px), (double)((double)_mop.field_72312_c - py), (double)((double)_mop.field_72309_d - pz));
            this.partialFrame = partialTicks;
        }
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public MovingObjectPosition getPosition() {
        return this.mop;
    }

    @Override
    public NBTTagCompound getNBTData() {
        if (this.entity == null) {
            return null;
        }
        if (this.isTagCorrect(this.remoteNbt)) {
            return this.remoteNbt;
        }
        NBTTagCompound tag = new NBTTagCompound();
        this.entity.func_70109_d(tag);
        return tag;
    }

    private boolean isTagCorrect(NBTTagCompound tag) {
        if (tag == null) {
            this.timeLastUpdate = System.currentTimeMillis() - 250L;
            return false;
        }
        int x = tag.func_74762_e("x");
        int y = tag.func_74762_e("y");
        int z = tag.func_74762_e("z");
        if (x == this.mop.field_72311_b && y == this.mop.field_72312_c && z == this.mop.field_72309_d) {
            return true;
        }
        this.timeLastUpdate = System.currentTimeMillis() - 250L;
        return false;
    }

    @Override
    public int getNBTInteger(NBTTagCompound tag, String keyname) {
        return NBTUtil.getNBTInteger(tag, keyname);
    }

    @Override
    public Vec3 getRenderingPosition() {
        return this.renderingvec;
    }

    @Override
    public double getPartialFrame() {
        return this.partialFrame;
    }

    public boolean isTimeElapsed(long time) {
        return System.currentTimeMillis() - this.timeLastUpdate >= time;
    }

    public void resetTimer() {
        this.timeLastUpdate = System.currentTimeMillis();
    }
}

