/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import codechicken.lib.gui.GuiDraw;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.overlay.IconUI;
import mcp.mobius.waila.overlay.OverlayConfig;
import mcp.mobius.waila.overlay.OverlayRenderer;
import mcp.mobius.waila.utils.Constants;
import net.minecraft.item.ItemStack;

public class Tooltip {
    public static int TabSpacing = 8;
    public static int IconSize = 8;
    ArrayList<Line> lines = new ArrayList();
    int w;
    int h;
    int x;
    int y;
    int ty;
    int offsetX;
    int maxStringW;
    Point pos;
    boolean hasIcon = false;
    ItemStack stack;
    int[] columnsWidth;
    int columnsWidthMono;
    int[] columnsPos;
    int ncolumns = 0;

    public Tooltip(List<String> textData, ItemStack stack) {
        this(textData, true);
        this.stack = stack;
    }

    public Tooltip(List<String> textData, boolean hasIcon) {
        int i;
        for (String s : textData) {
            this.lines.add(new Line(s));
        }
        for (Line l : this.lines) {
            this.ncolumns = Math.max(this.ncolumns, l.ncolumns);
        }
        this.columnsWidth = new int[this.ncolumns];
        this.columnsPos = new int[this.ncolumns];
        for (Line l : this.lines) {
            for (int i2 = 0; i2 < l.ncolumns; ++i2) {
                if (l.ncolumns <= 1 || this.ncolumns == 1) continue;
                this.columnsWidth[i2] = Math.max(this.columnsWidth[i2], l.columnsWidth[i2]);
            }
            this.columnsWidthMono = Math.max(this.columnsWidthMono, l.columnsWidth[0]);
        }
        this.maxStringW = 0;
        for (i = 0; i < this.ncolumns; ++i) {
            this.maxStringW += this.columnsWidth[i];
        }
        this.maxStringW += this.ncolumns * TabSpacing;
        this.maxStringW = Math.max(this.maxStringW, this.columnsWidthMono);
        for (i = 0; i < this.ncolumns - 1; ++i) {
            this.columnsPos[i + 1] = this.columnsWidth[i] + this.columnsPos[i];
        }
        this.pos = new Point(ConfigHandler.instance().getConfig("general", Constants.CFG_WAILA_POSX, 0), ConfigHandler.instance().getConfig("general", Constants.CFG_WAILA_POSY, 0));
        this.hasIcon = hasIcon;
        int paddingW = hasIcon ? 29 : 13;
        int paddingH = hasIcon ? 24 : 0;
        this.offsetX = hasIcon ? 24 : 6;
        this.w = this.maxStringW + paddingW;
        this.h = Math.max(paddingH, 10 + 10 * this.lines.size());
        Dimension size = GuiDraw.displaySize();
        this.x = ((int)((float)size.width / OverlayConfig.scale) - this.w - 1) * this.pos.x / 10000;
        this.y = ((int)((float)size.height / OverlayConfig.scale) - this.h - 1) * this.pos.y / 10000;
        this.ty = (this.h - 10 * this.lines.size()) / 2;
    }

    public void drawStrings() {
        for (int i = 0; i < this.lines.size(); ++i) {
            for (int c = 0; c < this.lines.get((int)i).ncolumns; ++c) {
                int offX = 0;
                for (int is = 0; is < this.lines.get((int)i).columns.get(c).size(); ++is) {
                    String s = this.lines.get((int)i).columns.get(c).get(is);
                    if (s.startsWith(SpecialChars.WailaStyle + SpecialChars.WailaIcon)) {
                        offX += IconSize;
                        continue;
                    }
                    if (s.startsWith(SpecialChars.ALIGNRIGHT)) {
                        offX += this.columnsWidth[c] - GuiDraw.getStringWidth((String)this.lines.get((int)i).columns.get(c).get(is + 1));
                        continue;
                    }
                    GuiDraw.drawString((String)s, (int)(this.x + this.offsetX + this.columnsPos[c] + c * TabSpacing + offX), (int)(this.y + this.ty + 10 * i), (int)OverlayConfig.fontcolor, (boolean)true);
                    offX += GuiDraw.getStringWidth((String)s);
                }
            }
        }
    }

    public void drawIcons() {
        for (int i = 0; i < this.lines.size(); ++i) {
            for (int c = 0; c < this.lines.get((int)i).ncolumns; ++c) {
                int offX = 0;
                for (String s : this.lines.get((int)i).columns.get(c)) {
                    if (s.startsWith(SpecialChars.WailaStyle + SpecialChars.WailaIcon)) {
                        OverlayRenderer.renderIcon(this.x + this.offsetX + this.columnsPos[c] + c * TabSpacing + offX, this.y + this.ty + 10 * i, IconSize, IconSize, IconUI.bySymbol(s));
                        offX += IconSize;
                        continue;
                    }
                    offX += GuiDraw.getStringWidth((String)s);
                }
            }
        }
    }

    private class Line {
        String[] columnsRaw;
        ArrayList<ArrayList<String>> columns = new ArrayList();
        int ncolumns;
        int[] columnsWidth;
        int lineWidth;

        public Line(String text) {
            this.columnsRaw = text.split(SpecialChars.TAB);
            this.ncolumns = this.columnsRaw.length;
            this.columnsWidth = new int[this.ncolumns];
            this.lineWidth = 0;
            for (String s : this.columnsRaw) {
                this.columns.add(this.parseString(s));
            }
            for (int i = 0; i < this.ncolumns; ++i) {
                for (String s : this.columns.get(i)) {
                    if (s.startsWith(SpecialChars.WailaStyle + SpecialChars.WailaIcon)) {
                        int n = i;
                        this.columnsWidth[n] = this.columnsWidth[n] + IconSize;
                        continue;
                    }
                    if (s.startsWith(SpecialChars.WailaStyle + SpecialChars.WailaStyle)) {
                        int n = i;
                        this.columnsWidth[n] = this.columnsWidth[n] + 0;
                        continue;
                    }
                    int n = i;
                    this.columnsWidth[n] = this.columnsWidth[n] + GuiDraw.getStringWidth((String)s);
                }
                this.lineWidth += this.columnsWidth[i];
            }
        }

        ArrayList<String> parseString(String s) {
            ArrayList<String> retList = new ArrayList<String>();
            Pattern pattern = Pattern.compile(SpecialChars.WailaStyle + "..");
            Matcher matcher = pattern.matcher(s);
            int prevIndex = 0;
            while (matcher.find()) {
                String substring = s.substring(prevIndex, matcher.start());
                if (!substring.equals("")) {
                    retList.add(substring);
                }
                retList.add(s.substring(matcher.start(), matcher.end()));
                prevIndex = matcher.end();
            }
            retList.add(s.substring(prevIndex));
            return retList;
        }
    }
}

