/*
 * Decompiled with CFR 0.152.
 */
package magicwands;

import magicwands.MagicWands;
import magicwands.WandCoord3D;
import magicwands.WandItem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class BreakWand
extends WandItem {
    protected static final int BREAK_XORES = 100;
    protected static final int BREAK_ALL = 10;
    protected static final int BREAK_WEAK = 1;

    public BreakWand(boolean reinforced) {
        super(reinforced);
        this.func_77656_e(reinforced ? 120 : 15);
    }

    @Override
    public boolean canAlter(int keys, Block block) {
        switch (keys) {
            case 100: {
                return (block != Blocks.field_150357_h || MagicWands.bedrock) && !BreakWand.isOre(block);
            }
            case 10: {
                return block != Blocks.field_150357_h || MagicWands.bedrock;
            }
            case 1: {
                return block == Blocks.field_150362_t || block == Blocks.field_150433_aE || block == Blocks.field_150480_ab || block == Blocks.field_150395_bd || block instanceof BlockFlower || block instanceof BlockCrops || block instanceof BlockLiquid;
            }
        }
        return false;
    }

    @Override
    public boolean doMagic(EntityPlayer entityplayer, World world, WandCoord3D start, WandCoord3D end, WandCoord3D info, WandCoord3D clicked_current, int keys, Block idOrig, Block id, int meta) {
        boolean damage;
        if (MagicWands.disableNotify) {
            world.field_72999_e = true;
        }
        if (damage = this.do_Breaking(world, start, end, clicked_current, keys, entityplayer)) {
            world.func_72908_a((double)clicked_current.x, (double)clicked_current.y, (double)clicked_current.z, "random.explode", 2.5f, 0.5f + world.field_73012_v.nextFloat() * 0.3f);
        }
        if (MagicWands.disableNotify) {
            world.field_72999_e = false;
        }
        return damage;
    }

    @Override
    public double[] getParticleColor() {
        return new double[]{0.5, 0.5, 0.5};
    }

    @Override
    public boolean isTooFar(int keys, int range, int max, int range2d) {
        return this.reinforced ? range - 250 > max : range - 50 > max;
    }

    private boolean do_Breaking(World world, WandCoord3D start, WandCoord3D end, WandCoord3D clicked, int keys, EntityPlayer entityplayer) {
        Block blockAt;
        int Z;
        int Y;
        int X;
        int cnt = 0;
        for (X = start.x; X <= end.x; ++X) {
            for (Y = start.y; Y <= end.y; ++Y) {
                for (Z = start.z; Z <= end.z; ++Z) {
                    blockAt = world.func_147439_a(X, Y, Z);
                    if (blockAt == Blocks.field_150350_a || !this.canAlter(keys, blockAt)) continue;
                    ++cnt;
                }
            }
        }
        if (cnt == 0) {
            if (!world.field_72995_K) {
                entityplayer.func_146105_b((IChatComponent)new ChatComponentTranslation("message.wand.nowork", new Object[0]));
            }
            return false;
        }
        for (X = start.x; X <= end.x; ++X) {
            for (Y = start.y; Y <= end.y; ++Y) {
                for (Z = start.z; Z <= end.z; ++Z) {
                    blockAt = world.func_147439_a(X, Y, Z);
                    if (blockAt == Blocks.field_150350_a || !this.canAlter(keys, blockAt)) continue;
                    int metaAt = world.func_72805_g(X, Y, Z);
                    blockAt.func_149664_b(world, X, Y, Z, metaAt);
                    world.func_147468_f(X, Y, Z);
                    if (field_77697_d.nextInt(cnt / 50 + 1) != 0) continue;
                    this.particles(world, X, Y, Z, 1);
                }
            }
        }
        return true;
    }
}

