/*
 * Decompiled with CFR 0.152.
 */
package magicwands;

import magicwands.MagicWands;
import magicwands.WandCoord3D;
import magicwands.WandItem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSign;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class BuildWand
extends WandItem {
    protected static final int BUILD_BOX = 100;
    protected static final int BUILD_ROOM = 10;
    protected static final int BUILD_FRAME = 1;
    protected static final int BUILD_WATER = 110;
    protected static final int BUILD_TORCHES = 101;
    protected static final int BUILD_CAVES = 11;
    protected static final int BUILD_LAVA = 111;

    public BuildWand(boolean reinforced) {
        super(reinforced);
        this.func_77656_e(reinforced ? 200 : 30);
    }

    @Override
    public boolean canAlter(int keys, Block block) {
        if (block == Blocks.field_150350_a || block == Blocks.field_150362_t || block == Blocks.field_150433_aE || block == Blocks.field_150480_ab || block == Blocks.field_150395_bd || block instanceof BlockCrops || block instanceof BlockFlower) {
            return true;
        }
        switch (keys) {
            case 1: 
            case 10: 
            case 11: 
            case 100: {
                return block instanceof BlockLiquid;
            }
            case 110: 
            case 111: {
                return block == Blocks.field_150478_aa || block instanceof BlockLiquid;
            }
        }
        return false;
    }

    @Override
    public boolean doMagic(EntityPlayer entityplayer, World world, WandCoord3D start, WandCoord3D end, WandCoord3D info, WandCoord3D clicked_current, int keys, Block idOrig, Block id, int meta) {
        boolean flag;
        if (id != info.id && (keys == 100 || keys == 10 || keys == 1 || keys == 101)) {
            this.error(entityplayer, clicked_current, "notsamecorner");
            return false;
        }
        if (!(meta == info.meta || keys != 100 && keys != 10 && keys != 1 && keys != 101 || id == Blocks.field_150434_aF || id == Blocks.field_150436_aH || id == Blocks.field_150362_t && (meta & 3) == (info.meta & 3))) {
            this.error(entityplayer, clicked_current, "notsamecorner");
            return false;
        }
        if (MagicWands.disableNotify) {
            world.field_72999_e = true;
        }
        if ((flag = this.do_Building(world, start, end, clicked_current, keys, entityplayer, idOrig)) && keys != 110) {
            world.func_72908_a((double)clicked_current.x, (double)clicked_current.y, (double)clicked_current.z, "random.pop", (world.field_73012_v.nextFloat() + 0.7f) / 2.0f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.4f);
        }
        if (flag && keys == 110) {
            world.func_72908_a((double)clicked_current.x, (double)clicked_current.y, (double)clicked_current.z, "liquid.splash", (world.field_73012_v.nextFloat() + 0.7f) / 2.0f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.4f);
        }
        if (MagicWands.disableNotify) {
            world.field_72999_e = false;
        }
        return flag;
    }

    @Override
    public double[] getParticleColor() {
        return new double[]{1.0, 0.8, 0.0};
    }

    @Override
    public boolean isTooFar(int keys, int range, int max, int range2d) {
        switch (keys) {
            case 1: 
            case 10: 
            case 100: 
            case 101: 
            case 110: 
            case 111: {
                return this.reinforced ? range - 400 > max : range - 50 > max;
            }
            case 11: {
                return this.reinforced ? range2d - 1600 > max : range2d - 200 > max;
            }
        }
        return true;
    }

    @Override
    protected boolean isIncompatibleBlock(Block block) {
        return block == Blocks.field_150350_a || block == Blocks.field_150326_M || block == Blocks.field_150332_K || block instanceof BlockBed || block instanceof BlockDoor || block instanceof BlockSign;
    }

    private boolean do_Building(World world, WandCoord3D start, WandCoord3D end, WandCoord3D clicked, int keys, EntityPlayer entityplayer, Block idOrig) {
        int Y = 0;
        Block id = clicked.id;
        int meta = clicked.meta;
        ItemStack neededStack = BuildWand.getNeededItem(id, meta);
        int multiplier = BuildWand.getNeededCount(id, meta);
        int affected = 0;
        boolean FREE = MagicWands.free || entityplayer.field_71075_bZ.field_75098_d;
        switch (keys) {
            case 100: {
                int Z;
                int X;
                int neededItems = 0;
                for (X = start.x; X <= end.x; ++X) {
                    for (Z = start.z; Z <= end.z; ++Z) {
                        for (Y = start.y; Y <= end.y; ++Y) {
                            if (!this.canPlace(world, X, Y, Z, id, keys)) continue;
                            neededItems += multiplier;
                        }
                    }
                }
                if (neededItems == 0) {
                    if (!world.field_72995_K) {
                        entityplayer.func_146105_b((IChatComponent)new ChatComponentTranslation("message.wand.nowork", new Object[0]));
                    }
                    return false;
                }
                if (this.consumeItems(neededStack, entityplayer, neededItems, clicked)) {
                    for (X = start.x; X <= end.x; ++X) {
                        for (Z = start.z; Z <= end.z; ++Z) {
                            for (Y = start.y; Y <= end.y; ++Y) {
                                if (!this.canPlace(world, X, Y, Z, id, keys)) continue;
                                world.func_147465_d(X, Y, Z, id, meta, 3);
                                if (field_77697_d.nextInt(neededItems / 50 + 1) == 0) {
                                    this.particles(world, X, Y, Z, 0);
                                }
                                ++affected;
                            }
                        }
                    }
                    if (idOrig == Blocks.field_150349_c && affected > 0) {
                        for (int run = 0; run <= 1; ++run) {
                            if (run == 0) {
                                Y = start.y;
                            }
                            if (run == 1) {
                                Y = end.y;
                            }
                            for (X = start.x; X <= end.x; ++X) {
                                for (Z = start.z; Z <= end.z; ++Z) {
                                    if (world.func_147439_a(X, Y, Z) != Blocks.field_150346_d || world.func_147439_a(X, Y + 1, Z) != Blocks.field_150350_a && world.func_147439_a(X, Y + 1, Z).func_149686_d()) continue;
                                    world.func_147449_b(X, Y, Z, (Block)Blocks.field_150349_c);
                                }
                            }
                        }
                    }
                    return affected > 0;
                }
                return false;
            }
            case 10: {
                int Z;
                int X;
                int neededItems = 0;
                for (X = start.x; X <= end.x; ++X) {
                    for (Z = start.z; Z <= end.z; ++Z) {
                        for (Y = start.y; Y <= end.y; ++Y) {
                            if (X != start.x && Y != start.y && Z != start.z && X != end.x && Y != end.y && Z != end.z || !this.canPlace(world, X, Y, Z, id, keys)) continue;
                            neededItems += multiplier;
                        }
                    }
                }
                if (neededItems == 0) {
                    if (!world.field_72995_K) {
                        entityplayer.func_146105_b((IChatComponent)new ChatComponentTranslation("message.wand.nowork", new Object[0]));
                    }
                    return false;
                }
                if (this.consumeItems(neededStack, entityplayer, neededItems, clicked)) {
                    for (X = start.x; X <= end.x; ++X) {
                        for (Z = start.z; Z <= end.z; ++Z) {
                            for (Y = start.y; Y <= end.y; ++Y) {
                                if (X != start.x && Y != start.y && Z != start.z && X != end.x && Y != end.y && Z != end.z || !this.canPlace(world, X, Y, Z, id, keys)) continue;
                                world.func_147465_d(X, Y, Z, id, meta, 3);
                                if (field_77697_d.nextInt(neededItems / 50 + 1) == 0) {
                                    this.particles(world, X, Y, Z, 0);
                                }
                                ++affected;
                            }
                        }
                    }
                    if (idOrig == Blocks.field_150349_c && affected > 0) {
                        for (int run = 0; run <= 1; ++run) {
                            if (run == 0) {
                                Y = start.y;
                            }
                            if (run == 1) {
                                Y = end.y;
                            }
                            for (X = start.x; X <= end.x; ++X) {
                                for (Z = start.z; Z <= end.z; ++Z) {
                                    if (world.func_147439_a(X, Y, Z) != Blocks.field_150346_d || world.func_147439_a(X, Y + 1, Z) != Blocks.field_150350_a && world.func_147439_a(X, Y + 1, Z).func_149686_d()) continue;
                                    world.func_147449_b(X, Y, Z, (Block)Blocks.field_150349_c);
                                }
                            }
                        }
                    }
                    return affected > 0;
                }
                return false;
            }
            case 1: {
                int Z;
                int X;
                int neededItems = 0;
                for (X = start.x; X <= end.x; ++X) {
                    for (Z = start.z; Z <= end.z; ++Z) {
                        for (Y = start.y; Y <= end.y; ++Y) {
                            if (!(X == start.x && Y == start.y || Y == start.y && Z == start.z || Z == start.z && X == start.x || X == start.x && Y == end.y || X == end.x && Y == start.y || Y == start.y && Z == end.z || Y == end.y && Z == start.z || Z == start.z && X == end.x || Z == end.z && X == start.x || X == end.x && Y == end.y || Y == end.y && Z == end.z) && (Z != end.z || X != end.x) || !this.canPlace(world, X, Y, Z, id, keys)) continue;
                            neededItems += multiplier;
                        }
                    }
                }
                if (neededItems == 0) {
                    if (!world.field_72995_K) {
                        entityplayer.func_146105_b((IChatComponent)new ChatComponentTranslation("message.wand.nowork", new Object[0]));
                    }
                    return false;
                }
                if (this.consumeItems(neededStack, entityplayer, neededItems, clicked)) {
                    for (X = start.x; X <= end.x; ++X) {
                        for (Z = start.z; Z <= end.z; ++Z) {
                            for (Y = start.y; Y <= end.y; ++Y) {
                                if (!(X == start.x && Y == start.y || Y == start.y && Z == start.z || Z == start.z && X == start.x || X == start.x && Y == end.y || X == end.x && Y == start.y || Y == start.y && Z == end.z || Y == end.y && Z == start.z || Z == start.z && X == end.x || Z == end.z && X == start.x || X == end.x && Y == end.y || Y == end.y && Z == end.z) && (Z != end.z || X != end.x) || !this.canPlace(world, X, Y, Z, id, keys)) continue;
                                world.func_147465_d(X, Y, Z, id, meta, 3);
                                if (field_77697_d.nextInt(neededItems / 50 + 1) == 0) {
                                    this.particles(world, X, Y, Z, 0);
                                }
                                ++affected;
                            }
                        }
                    }
                    if (idOrig == Blocks.field_150349_c && affected > 0) {
                        for (int run = 0; run <= 1; ++run) {
                            if (run == 0) {
                                Y = start.y;
                            }
                            if (run == 1) {
                                Y = end.y;
                            }
                            for (X = start.x; X <= end.x; ++X) {
                                for (Z = start.z; Z <= end.z; ++Z) {
                                    if (!(X == start.x && Y == start.y || Y == start.y && Z == start.z || Z == start.z && X == start.x || X == start.x && Y == end.y || X == end.x && Y == start.y || Y == start.y && Z == end.z || Y == end.y && Z == start.z || Z == start.z && X == end.x || Z == end.z && X == start.x || X == end.x && Y == end.y || Y == end.y && Z == end.z) && (Z != end.z || X != end.x) || world.func_147439_a(X, Y, Z) != Blocks.field_150346_d || world.func_147439_a(X, Y + 1, Z) != Blocks.field_150350_a && world.func_147439_a(X, Y + 1, Z).func_149686_d()) continue;
                                    world.func_147449_b(X, Y, Z, (Block)Blocks.field_150349_c);
                                }
                            }
                        }
                    }
                    return affected > 0;
                }
                return false;
            }
            case 101: {
                int Z;
                int X;
                int neededItems = 0;
                for (X = start.x; X <= end.x; X += 5) {
                    for (Z = start.z; Z <= end.z; Z += 5) {
                        for (Y = start.y; Y <= end.y; ++Y) {
                            if (!this.canPlace(world, X, Y, Z, id, keys)) continue;
                            neededItems += multiplier;
                        }
                    }
                }
                if (neededItems == 0) {
                    if (!world.field_72995_K) {
                        entityplayer.func_146105_b((IChatComponent)new ChatComponentTranslation("message.wand.nowork", new Object[0]));
                    }
                    return false;
                }
                if (this.consumeItems(neededStack, entityplayer, neededItems, clicked)) {
                    for (X = start.x; X <= end.x; X += 5) {
                        for (Z = start.z; Z <= end.z; Z += 5) {
                            for (Y = start.y; Y <= end.y; ++Y) {
                                if (!this.canPlace(world, X, Y, Z, id, keys)) continue;
                                world.func_147465_d(X, Y, Z, id, meta, 3);
                                this.particles(world, X, Y, Z, 0);
                                ++affected;
                            }
                        }
                    }
                    return affected > 0;
                }
                return false;
            }
            case 110: {
                Block blockAt;
                int Z;
                int X;
                if (!this.reinforced && !FREE) {
                    this.error(entityplayer, clicked, "cantfillwater");
                    return false;
                }
                Item bucket = Items.field_151131_as;
                if (!FREE) {
                    int neededItems = 0;
                    for (X = start.x; X <= end.x; ++X) {
                        for (Z = start.z; Z <= end.z; ++Z) {
                            for (Y = start.y; Y <= end.y; ++Y) {
                                blockAt = world.func_147439_a(X, Y, Z);
                                if (!this.canAlter(keys, blockAt)) continue;
                                ++neededItems;
                            }
                        }
                    }
                    if (neededItems == 0) {
                        if (!world.field_72995_K) {
                            entityplayer.func_146105_b((IChatComponent)new ChatComponentTranslation("message.wand.nowork", new Object[0]));
                        }
                        return false;
                    }
                }
                if (BuildWand.emptyBuckets(bucket, entityplayer, 2)) {
                    for (X = start.x; X <= end.x; ++X) {
                        for (Z = start.z; Z <= end.z; ++Z) {
                            for (Y = start.y; Y <= end.y; ++Y) {
                                blockAt = world.func_147439_a(X, Y, Z);
                                if (!this.canAlter(keys, blockAt)) continue;
                                world.func_147449_b(X, Y, Z, (Block)Blocks.field_150358_i);
                                ++affected;
                            }
                        }
                    }
                    if (affected == 0) {
                        return false;
                    }
                    for (X = start.x; X <= end.x; ++X) {
                        for (Z = start.z; Z <= end.z; ++Z) {
                            for (Y = start.y; Y <= end.y; ++Y) {
                                blockAt = world.func_147439_a(X, Y, Z);
                                if (blockAt != Blocks.field_150358_i) continue;
                                world.func_147444_c(X, Y, Z, (Block)Blocks.field_150358_i);
                                if (!world.func_147437_c(X, Y + 1, Z)) continue;
                                this.particles(world, X, Y, Z, 2);
                            }
                        }
                    }
                    return true;
                }
                this.error(entityplayer, clicked, "toofewwater");
                return false;
            }
            case 111: {
                Block blockAt;
                int Z;
                int X;
                if (!this.reinforced && !FREE) {
                    this.error(entityplayer, clicked, "cantfilllava");
                    return false;
                }
                Item bucket = Items.field_151129_at;
                int neededItems = 0;
                if (!FREE) {
                    for (X = start.x; X <= end.x; ++X) {
                        for (Z = start.z; Z <= end.z; ++Z) {
                            for (Y = start.y; Y <= end.y; ++Y) {
                                blockAt = world.func_147439_a(X, Y, Z);
                                if (!this.canAlter(keys, blockAt)) continue;
                                ++neededItems;
                            }
                        }
                    }
                    if (neededItems == 0) {
                        if (!world.field_72995_K) {
                            entityplayer.func_146105_b((IChatComponent)new ChatComponentTranslation("message.wand.nowork", new Object[0]));
                        }
                        return false;
                    }
                }
                if (BuildWand.emptyBuckets(bucket, entityplayer, neededItems)) {
                    for (X = start.x; X <= end.x; ++X) {
                        for (Z = start.z; Z <= end.z; ++Z) {
                            for (Y = start.y; Y <= end.y; ++Y) {
                                blockAt = world.func_147439_a(X, Y, Z);
                                if (!this.canAlter(keys, blockAt)) continue;
                                world.func_147449_b(X, Y, Z, (Block)Blocks.field_150356_k);
                                ++affected;
                            }
                        }
                    }
                    if (affected == 0) {
                        return false;
                    }
                    for (X = start.x; X <= end.x; ++X) {
                        for (Z = start.z; Z <= end.z; ++Z) {
                            for (Y = start.y; Y <= end.y; ++Y) {
                                blockAt = world.func_147439_a(X, Y, Z);
                                if (blockAt != Blocks.field_150356_k) continue;
                                world.func_147444_c(X, Y, Z, (Block)Blocks.field_150356_k);
                            }
                        }
                    }
                    return true;
                }
                this.error(entityplayer, clicked, "toofewlava");
                return false;
            }
            case 11: {
                if (!this.reinforced && !FREE) {
                    this.error(entityplayer, clicked, "cantfillcave");
                    return false;
                }
                long cnt = 0L;
                for (int X = start.x; X <= end.x; ++X) {
                    for (int Z = start.z; Z <= end.z; ++Z) {
                        boolean underground = false;
                        for (Y = 127; Y > 1; --Y) {
                            Block blockAt = world.func_147439_a(X, Y, Z);
                            boolean surfaceBlock = BuildWand.isSurface(blockAt);
                            if (!underground && surfaceBlock) {
                                underground = true;
                                continue;
                            }
                            if (!underground || !this.canAlter(keys, blockAt)) continue;
                            world.func_147449_b(X, Y, Z, Blocks.field_150348_b);
                            ++cnt;
                        }
                    }
                }
                if (cnt > 0L) {
                    if (!world.field_72995_K) {
                        entityplayer.func_146105_b((IChatComponent)new ChatComponentText(cnt + StatCollector.func_74838_a((String)"result.wand.fill")));
                    }
                    return true;
                }
                if (!world.field_72995_K) {
                    entityplayer.func_146105_b((IChatComponent)new ChatComponentTranslation("message.wand.nocave", new Object[0]));
                }
                return false;
            }
        }
        return false;
    }
}

