/*
 * Decompiled with CFR 0.152.
 */
package magicwands;

import magicwands.MagicWands;
import magicwands.WandCoord3D;
import magicwands.WandItem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class MineWand
extends WandItem {
    protected static final int MINE_ALL = 100;
    protected static final int MINE_DIRT = 10;
    protected static final int MINE_WOOD = 1;
    protected static final int MINE_ORES = 110;

    public MineWand(boolean reinforced) {
        super(reinforced);
        this.func_77656_e(reinforced ? 120 : 15);
    }

    @Override
    public boolean canAlter(int keys, Block block) {
        switch (keys) {
            case 100: {
                return !(block == Blocks.field_150357_h && !MagicWands.bedrock || block == Blocks.field_150343_Z && !MagicWands.obsidian);
            }
            case 10: {
                return block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150354_m || block == Blocks.field_150351_n || block == Blocks.field_150362_t || block == Blocks.field_150458_ak || block == Blocks.field_150433_aE || block == Blocks.field_150425_aM || block == Blocks.field_150395_bd || block instanceof BlockFlower;
            }
            case 1: {
                return block.func_149688_o() == Material.field_151575_d;
            }
            case 110: {
                return !(!MineWand.isMiningOre(block) || block == Blocks.field_150357_h && !MagicWands.bedrock || block == Blocks.field_150343_Z && !MagicWands.obsidian);
            }
        }
        return false;
    }

    @Override
    public boolean doMagic(EntityPlayer entityplayer, World world, WandCoord3D start, WandCoord3D end, WandCoord3D info, WandCoord3D clicked_current, int keys, Block idOrig, Block id, int meta) {
        boolean damage;
        if (MagicWands.disableNotify) {
            world.field_72999_e = true;
        }
        if (damage = this.do_Mining(world, start, end, clicked_current, keys, entityplayer)) {
            world.func_72908_a((double)clicked_current.x, (double)clicked_current.y, (double)clicked_current.z, "random.explode", 2.5f, 0.5f + world.field_73012_v.nextFloat() * 0.3f);
        }
        if (MagicWands.disableNotify) {
            world.field_72999_e = false;
        }
        return damage;
    }

    @Override
    public double[] getParticleColor() {
        return new double[]{0.01, 0.8, 1.0};
    }

    @Override
    public boolean isTooFar(int keys, int range, int max, int range2d) {
        switch (keys) {
            case 10: 
            case 100: {
                return this.reinforced ? range - 250 > max : range - 50 > max;
            }
            case 1: {
                return this.reinforced ? range2d - 400 > max : range2d - 50 > max;
            }
            case 110: {
                return this.reinforced ? range2d - 60 > max : range2d - 30 > max;
            }
        }
        return true;
    }

    private boolean do_Mining(World world, WandCoord3D start, WandCoord3D end, WandCoord3D clicked, int keys, EntityPlayer entityplayer) {
        Block blockAt;
        int Z;
        int Y;
        int X;
        boolean FREE;
        int blocks2Dig = 0;
        if (keys == 100 && start.x == end.x && start.y == end.y && start.z == end.z && !MagicWands.obsidian && world.func_147439_a(start.x, start.y, start.z) == Blocks.field_150343_Z) {
            Blocks.field_150343_Z.func_149664_b(world, start.x, start.y, start.z, 0);
            Blocks.field_150343_Z.func_149636_a(world, entityplayer, start.x, start.y, start.z, 0);
            this.particles(world, start.x, start.y, start.z, 1);
            return true;
        }
        boolean bl = FREE = MagicWands.free || entityplayer.field_71075_bZ.field_75098_d;
        if (keys == 110) {
            int max;
            Block blockAt2;
            int Z2;
            int Y2;
            int X2;
            for (X2 = start.x; X2 <= end.x; ++X2) {
                for (Y2 = 1; Y2 < 128; ++Y2) {
                    for (Z2 = start.z; Z2 <= end.z; ++Z2) {
                        blockAt2 = world.func_147439_a(X2, Y2, Z2);
                        if (!MineWand.isMiningOre(blockAt2)) continue;
                        if (blockAt2 == Blocks.field_150450_ax || blockAt2 == Blocks.field_150439_ay || blockAt2 == Blocks.field_150369_x) {
                            blocks2Dig += 4;
                            continue;
                        }
                        ++blocks2Dig;
                    }
                }
            }
            int n = max = this.reinforced || FREE ? 1024 : 512;
            if (blocks2Dig - max > 10) {
                this.error(entityplayer, clicked, "toomanytodig (" + blocks2Dig + ", limit = " + max + ").");
                return true;
            }
            int surface = 127;
            long cnt = 0L;
            for (X2 = start.x; X2 <= end.x; ++X2) {
                for (Z2 = start.z; Z2 <= end.z; ++Z2) {
                    boolean underground = false;
                    for (Y2 = 127; Y2 > 1; --Y2) {
                        blockAt2 = world.func_147439_a(X2, Y2, Z2);
                        if (!underground && world.func_147437_c(X2, Y2, Z2)) {
                            surface = Y2;
                        }
                        boolean surfaceBlock = MineWand.isSurface(blockAt2);
                        if (!underground && surfaceBlock) {
                            underground = true;
                        }
                        if (!MineWand.isMiningOre(blockAt2)) continue;
                        int metaAt = world.func_72805_g(X2, Y2, Z2);
                        world.func_147449_b(X2, Y2, Z2, Blocks.field_150348_b);
                        blockAt2.func_149664_b(world, X2, surface, Z2, metaAt);
                        blockAt2.func_149636_a(world, entityplayer, X2, surface, Z2, metaAt);
                        ++cnt;
                    }
                }
            }
            if (cnt == 0L) {
                if (!world.field_72995_K) {
                    entityplayer.func_146105_b((IChatComponent)new ChatComponentTranslation("result.wand.mine", new Object[0]));
                }
                return false;
            }
            return true;
        }
        for (X = start.x; X <= end.x; ++X) {
            for (Y = start.y; Y <= end.y; ++Y) {
                for (Z = start.z; Z <= end.z; ++Z) {
                    blockAt = world.func_147439_a(X, Y, Z);
                    if (blockAt == null || !this.canAlter(keys, blockAt)) continue;
                    if (blockAt == Blocks.field_150450_ax || blockAt == Blocks.field_150439_ay || blockAt == Blocks.field_150369_x) {
                        blocks2Dig += 4;
                        continue;
                    }
                    ++blocks2Dig;
                }
            }
        }
        if (blocks2Dig >= (this.reinforced || FREE ? 1024 : 512)) {
            this.error(entityplayer, clicked, "toomanytodig (" + blocks2Dig + ", limit = " + Integer.toString(this.reinforced || FREE ? 1024 : 512) + ").");
            return false;
        }
        if (blocks2Dig == 0) {
            if (!world.field_72995_K) {
                entityplayer.func_146105_b((IChatComponent)new ChatComponentTranslation("message.wand.nowork", new Object[0]));
            }
            return false;
        }
        for (X = start.x; X <= end.x; ++X) {
            for (Y = start.y; Y <= end.y; ++Y) {
                for (Z = start.z; Z <= end.z; ++Z) {
                    blockAt = world.func_147439_a(X, Y, Z);
                    int metaAt = world.func_72805_g(X, Y, Z);
                    if (blockAt == null || !this.canAlter(keys, blockAt)) continue;
                    world.func_147468_f(X, Y, Z);
                    blockAt.func_149664_b(world, X, Y, Z, metaAt);
                    blockAt.func_149636_a(world, entityplayer, X, Y, Z, metaAt);
                    if (field_77697_d.nextInt(blocks2Dig / 50 + 1) != 0) continue;
                    this.particles(world, X, Y, Z, 1);
                }
            }
        }
        return true;
    }
}

