/*
 * Decompiled with CFR 0.152.
 */
package magicwands;

import java.util.ArrayList;
import magicwands.MagicWands;
import magicwands.WandCoord3D;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public abstract class WandItem
extends Item {
    static ArrayList<Block> m_ores = new ArrayList();
    static ArrayList<Block> ores = new ArrayList();
    public final boolean reinforced;

    public WandItem(boolean reinforced) {
        this.func_77637_a(MagicWands.wands);
        this.func_77625_d(1);
        this.reinforced = reinforced;
        this.func_77656_e(reinforced ? 200 : 30);
    }

    public abstract boolean canAlter(int var1, Block var2);

    public abstract boolean doMagic(EntityPlayer var1, World var2, WandCoord3D var3, WandCoord3D var4, WandCoord3D var5, WandCoord3D var6, int var7, Block var8, Block var9, int var10);

    public abstract double[] getParticleColor();

    public abstract boolean isTooFar(int var1, int var2, int var3, int var4);

    public boolean isTooFar(WandCoord3D a, WandCoord3D b, int keys, boolean free) {
        if (free) {
            return a.getDistance(b) > 1500.0;
        }
        return this.isTooFar(keys, (int)a.getDistance(b), 10, (int)a.getDistanceFlat(b));
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int l, float par8, float par9, float par10) {
        int keys;
        Block id = world.func_147439_a(i, j, k);
        int meta = world.func_72805_g(i, j, k);
        Block idOrig = id;
        if (id == Blocks.field_150349_c) {
            id = Blocks.field_150346_d;
        }
        if (id == Blocks.field_150437_az) {
            id = Blocks.field_150429_aA;
        }
        if (id == Blocks.field_150413_aR) {
            id = Blocks.field_150416_aS;
        }
        WandCoord3D clicked_current = new WandCoord3D(i, j, k, id, meta);
        if (this.isIncompatibleBlock(id)) {
            this.error(entityplayer, clicked_current, "cantbuild");
            return true;
        }
        if (!itemstack.func_77942_o()) {
            itemstack.field_77990_d = new NBTTagCompound();
        }
        if ((keys = itemstack.field_77990_d.func_74762_e("Keys")) == 0) {
            world.func_72908_a((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f), id.field_149762_H.func_150496_b(), (id.field_149762_H.func_150497_c() + 1.0f) / 2.0f, id.field_149762_H.func_150494_d() * 0.8f);
            clicked_current.writeToNBT(itemstack.field_77990_d, "Start");
            this.particles(world, clicked_current, 0);
            itemstack.field_77990_d.func_74757_a("Started", true);
            return true;
        }
        clicked_current.writeToNBT(itemstack.field_77990_d, "End");
        if (!itemstack.field_77990_d.func_74767_n("Started")) {
            this.error(entityplayer, clicked_current, "nostart");
            return true;
        }
        WandCoord3D Info = WandCoord3D.getFromNBT(itemstack.field_77990_d, "Start");
        WandCoord3D Start = Info.copy();
        WandCoord3D End = clicked_current.copy();
        WandCoord3D.findEnds(Start, End);
        if (this.isTooFar(Start, End, keys, MagicWands.free || entityplayer.field_71075_bZ.field_75098_d)) {
            this.error(entityplayer, clicked_current, "toofar");
            return true;
        }
        boolean damage = this.doMagic(entityplayer, world, Start, End, Info, clicked_current, keys, idOrig, id, meta);
        if (damage) {
            itemstack.field_77990_d.func_74757_a("Started", false);
            if (!MagicWands.free && !entityplayer.field_71075_bZ.field_75098_d) {
                itemstack.func_77972_a(1, (EntityLivingBase)entityplayer);
                return true;
            }
        }
        return true;
    }

    protected boolean canPlace(World world, int i, int j, int k, Block block, int keys) {
        if (this.canAlter(keys, world.func_147439_a(i, j, k))) {
            if (block.func_149742_c(world, i, j, k)) {
                return true;
            }
            if (block == Blocks.field_150434_aF || block == Blocks.field_150436_aH || block == Blocks.field_150488_af || block == Blocks.field_150456_au || block == Blocks.field_150452_aw || block == Blocks.field_150433_aE) {
                return false;
            }
            return !(block instanceof BlockTorch) && !(block instanceof BlockFlower);
        }
        return false;
    }

    protected boolean consumeItems(ItemStack neededStack, EntityPlayer entityplayer, int neededItems, WandCoord3D clicked) {
        ItemStack currentItem;
        int t;
        if (MagicWands.free || entityplayer.field_71075_bZ.field_75098_d) {
            return true;
        }
        int invItems = 0;
        for (t = 0; !(t >= entityplayer.field_71071_by.func_70302_i_() || (currentItem = entityplayer.field_71071_by.func_70301_a(t)) != null && currentItem.func_77969_a(neededStack) && (invItems += currentItem.field_77994_a) == neededItems); ++t) {
        }
        if (neededItems > invItems) {
            this.error(entityplayer, clicked, "toofewitems (needed " + neededItems + ", you have " + invItems + ").");
            return false;
        }
        for (t = entityplayer.field_71071_by.func_70302_i_() - 1; t >= 0; --t) {
            currentItem = entityplayer.field_71071_by.func_70301_a(t);
            if (currentItem == null || !currentItem.func_77969_a(neededStack)) continue;
            int stackSize = currentItem.field_77994_a;
            if (stackSize < neededItems) {
                entityplayer.field_71071_by.func_70299_a(t, null);
                neededItems -= stackSize;
                continue;
            }
            if (stackSize < neededItems) continue;
            entityplayer.field_71071_by.func_70298_a(t, neededItems);
            neededItems = 0;
            break;
        }
        return true;
    }

    protected void error(EntityPlayer entityplayer, WandCoord3D pos, String reason) {
        entityplayer.field_70170_p.func_72908_a((double)pos.x, (double)pos.y, (double)pos.z, "damage.fallsmall", (entityplayer.field_70170_p.field_73012_v.nextFloat() + 0.7f) / 2.0f, 0.5f + entityplayer.field_70170_p.field_73012_v.nextFloat() * 0.3f);
        if (!entityplayer.field_70170_p.field_72995_K) {
            entityplayer.func_146105_b((IChatComponent)new ChatComponentTranslation("error.wand." + reason, new Object[0]));
        }
        this.particles(entityplayer.field_70170_p, pos.x, pos.y, pos.z, 3);
    }

    protected boolean isIncompatibleBlock(Block id) {
        return false;
    }

    protected void particles(World world, int i, int j, int k, int effect) {
        double d = 0.0625;
        if (effect == 1) {
            world.func_72869_a("smoke", (double)i + 0.5, (double)j + 0.5, (double)k + 0.5, 0.0, 0.0, 0.0);
            return;
        }
        if (effect == 2) {
            world.func_72869_a("splash", (double)i + 0.5, (double)j + 1.0, (double)k + 0.5, 0.0, 0.0, 0.0);
            return;
        }
        double R = 0.0;
        double G = 0.0;
        double B = 0.0;
        if (effect == 0) {
            double[] color = this.getParticleColor();
            R = color[0];
            G = color[1];
            B = color[2];
        } else {
            R = 0.8;
        }
        for (int l = 0; l < 6; ++l) {
            double d1 = (float)i + field_77697_d.nextFloat();
            double d2 = (float)j + field_77697_d.nextFloat();
            double d3 = (float)k + field_77697_d.nextFloat();
            if (l == 0 && !world.func_147439_a(i, j + 1, k).func_149662_c()) {
                d2 = (double)(j + 1) + d;
            }
            if (l == 1 && !world.func_147439_a(i, j - 1, k).func_149662_c()) {
                d2 = (double)(j + 0) - d;
            }
            if (l == 2 && !world.func_147439_a(i, j, k + 1).func_149662_c()) {
                d3 = (double)(k + 1) + d;
            }
            if (l == 3 && !world.func_147439_a(i, j, k - 1).func_149662_c()) {
                d3 = (double)(k + 0) - d;
            }
            if (l == 4 && !world.func_147439_a(i + 1, j, k).func_149662_c()) {
                d1 = (double)(i + 1) + d;
            }
            if (l == 5 && !world.func_147439_a(i - 1, j, k).func_149662_c()) {
                d1 = (double)(i + 0) - d;
            }
            if (!(d1 < (double)i || d1 > (double)(i + 1) || d2 < 0.0 || d2 > (double)(j + 1) || d3 < (double)k) && !(d3 > (double)(k + 1))) continue;
            world.func_72869_a("reddust", d1, d2, d3, R, G, B);
        }
    }

    protected void particles(World world, WandCoord3D c, int effect) {
        this.particles(world, c.x, c.y, c.z, effect);
    }

    public static int getNeededCount(Block id, int meta) {
        if (id instanceof BlockSlab) {
            return 2;
        }
        return 1;
    }

    public static ItemStack getNeededItem(Block id, int meta) {
        if (id == Blocks.field_150362_t) {
            return new ItemStack(id, 1, meta & 3);
        }
        if (id == Blocks.field_150348_b || id == Blocks.field_150365_q || id == Blocks.field_150435_aG || id == Blocks.field_150330_I || id == Blocks.field_150342_X || id == Blocks.field_150480_ab || id instanceof BlockStairs || id == Blocks.field_150458_ak || id == Blocks.field_150482_ag || id == Blocks.field_150369_x || id instanceof BlockRedstoneOre || id == Blocks.field_150426_aN || id == Blocks.field_150432_aD || id == Blocks.field_150433_aE || id == Blocks.field_150417_aV) {
            return new ItemStack(id, 1, meta);
        }
        return new ItemStack(id.func_149650_a(meta, field_77697_d, 0), 1, id.func_149692_a(meta));
    }

    public static boolean isSurface(Block blockAt) {
        return blockAt == Blocks.field_150346_d || blockAt == Blocks.field_150349_c || blockAt == Blocks.field_150348_b || blockAt == Blocks.field_150351_n || blockAt == Blocks.field_150322_A || blockAt == Blocks.field_150354_m || blockAt == Blocks.field_150357_h || blockAt == Blocks.field_150365_q || blockAt == Blocks.field_150366_p || blockAt == Blocks.field_150352_o || blockAt == Blocks.field_150482_ag || blockAt == Blocks.field_150369_x;
    }

    protected static boolean emptyBuckets(Item bucketId, EntityPlayer entityplayer, int neededItems) {
        ItemStack currentItem;
        int t;
        if (MagicWands.free || entityplayer.field_71075_bZ.field_75098_d) {
            return true;
        }
        int itemsInInventory = 0;
        for (t = 0; t < entityplayer.field_71071_by.func_70302_i_(); ++t) {
            currentItem = entityplayer.field_71071_by.func_70301_a(t);
            if (currentItem == null || currentItem.func_77973_b() != bucketId) continue;
            ++itemsInInventory;
        }
        if (itemsInInventory < neededItems) {
            return false;
        }
        for (t = entityplayer.field_71071_by.func_70302_i_() - 1; t >= 0; --t) {
            currentItem = entityplayer.field_71071_by.func_70301_a(t);
            if (currentItem == null || currentItem.func_77973_b() != bucketId) continue;
            entityplayer.field_71071_by.func_70299_a(t, new ItemStack(Items.field_151133_ar));
            if (--neededItems != 0) continue;
            return true;
        }
        return false;
    }

    protected static boolean isMiningOre(Block id) {
        return m_ores.contains(id);
    }

    protected static boolean isOre(Block id) {
        return ores.contains(id);
    }
}

