/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.client.tickhandler;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import tonius.simplyjetpacks.SimplyJetpacks;
import tonius.simplyjetpacks.SyncTracker;
import tonius.simplyjetpacks.item.jetpack.JetpackParticleType;
import tonius.simplyjetpacks.network.PacketHandler;
import tonius.simplyjetpacks.network.message.MessageKeyboardSync;

@SideOnly(value=Side.CLIENT)
public class ClientTickHandler {
    private static Minecraft mc = Minecraft.func_71410_x();
    private static boolean lastJumpState = false;
    private static boolean lastForwardState = false;
    private static boolean lastBackwardState = false;
    private static boolean lastLeftState = false;
    private static boolean lastRightState = false;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent evt) {
        if (ClientTickHandler.mc.field_71439_g != null && !mc.func_147113_T()) {
            if (evt.phase == TickEvent.Phase.START) {
                ClientTickHandler.tickStart();
            } else {
                ClientTickHandler.tickEnd();
            }
        }
    }

    private static void tickStart() {
        boolean jumpState = ClientTickHandler.mc.field_71474_y.field_74314_A.func_151470_d();
        boolean forwardState = ClientTickHandler.mc.field_71474_y.field_74351_w.func_151470_d();
        boolean backwardState = ClientTickHandler.mc.field_71474_y.field_74368_y.func_151470_d();
        boolean leftState = ClientTickHandler.mc.field_71474_y.field_74370_x.func_151470_d();
        boolean rightState = ClientTickHandler.mc.field_71474_y.field_74366_z.func_151470_d();
        if (jumpState != lastJumpState || forwardState != lastForwardState || backwardState != lastBackwardState || leftState != lastLeftState || rightState != lastRightState) {
            lastJumpState = jumpState;
            lastForwardState = forwardState;
            lastBackwardState = backwardState;
            lastLeftState = leftState;
            lastRightState = rightState;
            PacketHandler.instance.sendToServer((IMessage)new MessageKeyboardSync(jumpState, forwardState, backwardState, leftState, rightState));
            SyncTracker.processKeyUpdate((EntityPlayer)ClientTickHandler.mc.field_71439_g, jumpState, forwardState, backwardState, leftState, rightState);
        }
    }

    private static void tickEnd() {
        Iterator<Integer> itr = SyncTracker.getJetpackStates().keySet().iterator();
        while (itr.hasNext()) {
            int currentEntity = itr.next();
            Entity entity = ClientTickHandler.mc.field_71441_e.func_73045_a(currentEntity);
            if (entity == null || !(entity instanceof EntityLivingBase)) {
                itr.remove();
                continue;
            }
            JetpackParticleType particle = SyncTracker.getJetpackStates().get(currentEntity);
            if (particle != null) {
                SimplyJetpacks.proxy.showJetpackParticles((World)ClientTickHandler.mc.field_71441_e, (EntityLivingBase)entity, particle);
                continue;
            }
            itr.remove();
        }
    }
}

