/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import tonius.simplyjetpacks.config.SJConfig;
import tonius.simplyjetpacks.item.jetpack.Jetpack;
import tonius.simplyjetpacks.setup.SJCreativeTab;
import tonius.simplyjetpacks.setup.SJItems;
import tonius.simplyjetpacks.util.StackUtils;

public class ItemJetpack
extends ItemArmor
implements ISpecialArmor,
IEnergyContainerItem {
    protected IIcon[] icons = null;

    public ItemJetpack() {
        super(ItemArmor.ArmorMaterial.IRON, 2, 1);
        this.func_77655_b("simplyjetpacks.jetpack");
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.setNoRepair();
        this.func_77637_a(SJCreativeTab.tab);
        this.icons = new IIcon[Jetpack.getHighestMeta() + 1];
    }

    public Jetpack getJetpack(ItemStack itemStack) {
        return Jetpack.getJetpack(itemStack.func_77960_j());
    }

    public ItemStack getChargedItem(ItemJetpack item, int meta) {
        ItemStack full = new ItemStack((Item)item, 1, meta);
        while (item.getEnergyStored(full) < item.getMaxEnergyStored(full)) {
            item.receiveEnergy(full, item.getMaxEnergyStored(full), false);
        }
        return full;
    }

    public void toggle(ItemStack itemStack, EntityPlayer player) {
        Jetpack jetpack = this.getJetpack(itemStack);
        if (jetpack != null) {
            jetpack.toggle(itemStack, player);
        }
    }

    public void toggleHoverMode(ItemStack itemStack, EntityPlayer player) {
        Jetpack jetpack = this.getJetpack(itemStack);
        if (jetpack != null) {
            jetpack.toggleHoverMode(itemStack, player);
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        Jetpack jetpack = this.getJetpack(itemStack);
        if (jetpack != null) {
            return "item.simplyjetpacks." + jetpack.getBaseName();
        }
        return super.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        Jetpack jetpack = this.getJetpack(itemStack);
        if (jetpack != null) {
            jetpack.addInformation(itemStack, player, list, this.getEnergyStored(itemStack));
        }
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        Jetpack jetpack = this.getJetpack(itemStack);
        if (jetpack != null) {
            return jetpack.rarity;
        }
        return super.func_77613_e(itemStack);
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        block1: {
            block3: {
                Jetpack jetpack;
                block2: {
                    jetpack = this.getJetpack(itemStack);
                    if (jetpack == null || !jetpack.hasArmoredVersion() || !player.func_70093_af()) break block1;
                    if (!jetpack.isArmored()) break block2;
                    jetpack.removeArmor(itemStack, player);
                    if (world.field_72995_K) break block3;
                    EntityItem item = player.func_70099_a(new ItemStack((Item)SJItems.components, 1, jetpack.getPlatingMeta()), 0.0f);
                    item.field_145804_b = 0;
                    break block3;
                }
                InventoryPlayer inv = player.field_71071_by;
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack currentStack = inv.func_70301_a(i);
                    if (currentStack == null || currentStack.func_77973_b() != SJItems.components || currentStack.func_77960_j() != jetpack.getPlatingMeta()) continue;
                    inv.func_70298_a(i, 1);
                    jetpack.applyArmor(itemStack, player);
                    break;
                }
            }
            return itemStack;
        }
        return super.func_77659_a(itemStack, world, player);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        Jetpack jetpack = this.getJetpack(itemStack);
        if (jetpack != null) {
            jetpack.useJetpack((EntityLivingBase)player, itemStack, this, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i <= Jetpack.getHighestMeta(); ++i) {
            Jetpack jetpack = Jetpack.getJetpack(i);
            if (jetpack == null || !jetpack.isVisible()) continue;
            if (jetpack.hasEmptyItem()) {
                list.add(new ItemStack((Item)this, 1, i));
            }
            list.add(this.getChargedItem(this, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        for (int i = 0; i <= Jetpack.getHighestMeta(); ++i) {
            Jetpack jetpack = Jetpack.getJetpack(i);
            if (jetpack == null) continue;
            this.icons[i] = register.func_94245_a("simplyjetpacks:" + jetpack.getBaseName());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        return damage < this.icons.length ? this.icons[damage] : null;
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack itemStack, Entity entity, int slot, String type) {
        Jetpack jetpack = this.getJetpack(itemStack);
        if (jetpack != null) {
            return "simplyjetpacks:textures/armor/" + jetpack.getBaseName() + ".png";
        }
        return null;
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        Jetpack jetpack = this.getJetpack(itemStack);
        if (jetpack != null) {
            return jetpack.hasDamageBar();
        }
        return true;
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        double stored = this.getMaxEnergyStored(itemStack) - this.getEnergyStored(itemStack) + 1;
        double max = this.getMaxEnergyStored(itemStack) + 1;
        return stored / max;
    }

    public boolean func_77616_k(ItemStack itemStack) {
        Jetpack jetpack = this.getJetpack(itemStack);
        return this.func_77619_b() > 0 ? (jetpack != null ? jetpack.enchantable : false) : false;
    }

    public int func_77619_b() {
        return SJConfig.jetpackEnchantability;
    }

    public boolean isBookEnchantable(ItemStack itemStack, ItemStack book) {
        return this.func_77616_k(itemStack);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        Jetpack jetpack = this.getJetpack(armor);
        if (jetpack != null) {
            return jetpack.getProperties(player, this, armor, source, damage, slot);
        }
        return null;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        Jetpack jetpack = this.getJetpack(armor);
        if (jetpack != null) {
            return jetpack.getArmorDisplay(player, this, armor, slot);
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack armor, DamageSource source, int damage, int slot) {
        Jetpack jetpack = this.getJetpack(armor);
        if (jetpack != null) {
            jetpack.damageArmor(entity, this, armor, source, damage, slot);
        }
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int energy = this.getEnergyStored(container);
        Jetpack jetpack = this.getJetpack(container);
        int maxInput = jetpack != null ? jetpack.energyCapacity : 0;
        int energyReceived = Math.min(this.getMaxEnergyStored(container) - energy, Math.min(maxReceive, maxInput));
        if (!simulate) {
            StackUtils.getNBT(container).func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        int energy = this.getEnergyStored(container);
        Jetpack jetpack = this.getJetpack(container);
        int maxOutput = jetpack != null ? jetpack.energyCapacity : 0;
        int energyExtracted = Math.min(energy, Math.min(maxExtract, maxOutput));
        if (!simulate) {
            StackUtils.getNBT(container).func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return StackUtils.getNBT(container).func_74762_e("Energy");
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        Jetpack jetpack = this.getJetpack(container);
        return jetpack != null ? jetpack.energyCapacity : 0;
    }
}

