/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import tonius.simplyjetpacks.item.MetaItem;
import tonius.simplyjetpacks.setup.SJCreativeTab;
import tonius.simplyjetpacks.util.StringUtils;

public class ItemMeta
extends Item {
    protected final Map<Integer, MetaItem> metaItems;
    protected final int highestMeta;
    protected final String fallbackName;
    protected IIcon[] icons = null;

    public ItemMeta(Map<Integer, MetaItem> names, String fallbackName) {
        this.metaItems = names;
        int highestMeta = 0;
        for (int i : names.keySet()) {
            if (i <= highestMeta) continue;
            highestMeta = i;
        }
        this.highestMeta = highestMeta;
        this.fallbackName = fallbackName;
        this.icons = new IIcon[highestMeta + 1];
        this.func_77655_b("simplyjetpacks." + fallbackName);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(SJCreativeTab.tab);
    }

    public MetaItem getMetaItem(ItemStack itemStack) {
        return this.metaItems.get(itemStack.func_77960_j());
    }

    public String func_77667_c(ItemStack itemStack) {
        MetaItem metaItem = this.getMetaItem(itemStack);
        if (metaItem != null) {
            return "item.simplyjetpacks." + metaItem.name;
        }
        return super.func_77658_a();
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        MetaItem metaItem = this.getMetaItem(itemStack);
        if (metaItem != null) {
            return metaItem.rarity;
        }
        return super.func_77613_e(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        MetaItem metaItem = this.getMetaItem(itemStack);
        if (metaItem != null && metaItem.tooltipLines.length > 0) {
            if (StringUtils.canShowDetails()) {
                for (int i = 0; i < metaItem.tooltipLines.length; ++i) {
                    list.add(StringUtils.translate(metaItem.tooltipLines[i]));
                }
            } else {
                list.add(StringUtils.getShiftText());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i <= this.highestMeta; ++i) {
            if (this.metaItems.get(i) == null) continue;
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        for (int i = 0; i <= this.highestMeta; ++i) {
            MetaItem metaItem = this.metaItems.get(i);
            if (metaItem == null) continue;
            this.icons[i] = register.func_94245_a("simplyjetpacks:" + metaItem.name);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        return damage < this.icons.length ? this.icons[damage] : null;
    }
}

