/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item.jetpack;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.ISpecialArmor;
import tonius.simplyjetpacks.SyncTracker;
import tonius.simplyjetpacks.config.SJConfig;
import tonius.simplyjetpacks.item.ItemJetpack;
import tonius.simplyjetpacks.item.jetpack.JetpackArmored;
import tonius.simplyjetpacks.item.jetpack.JetpackCreative;
import tonius.simplyjetpacks.item.jetpack.JetpackParticleType;
import tonius.simplyjetpacks.item.jetpack.JetpackPotato;
import tonius.simplyjetpacks.setup.JetpackIcon;
import tonius.simplyjetpacks.util.StackUtils;
import tonius.simplyjetpacks.util.StringUtils;

public class Jetpack {
    private static Map<Integer, Jetpack> jetpacks = new HashMap<Integer, Jetpack>();
    private static int highestMeta;
    public int tier;
    public boolean enchantable;
    public EnumRarity rarity;
    public int energyCapacity;
    public int energyPerTick;
    public double speedVertical;
    public double accelVertical;
    public float speedSideways;
    public int energyPerTickHover;
    public double speedVerticalHover;
    public double speedVerticalHoverSlow;
    public boolean emergencyHoverMode;

    public Jetpack(int meta, int tier, boolean enchantable, EnumRarity rarity, int energyCapacity, int energyPerTick, double speedVertical, double accelVertical, float speedSideways, double speedVerticalHover, double speedVerticalHoverSlow, boolean emergencyHoverMode) {
        this.tier = tier;
        this.enchantable = enchantable;
        this.rarity = rarity;
        this.energyCapacity = energyCapacity;
        this.energyPerTick = energyPerTick;
        this.speedVertical = speedVertical;
        this.accelVertical = accelVertical;
        this.speedSideways = speedSideways;
        this.energyPerTickHover = (int)((double)energyPerTick / 1.5);
        this.speedVerticalHover = speedVerticalHover;
        this.speedVerticalHoverSlow = speedVerticalHoverSlow;
        this.emergencyHoverMode = emergencyHoverMode;
        Jetpack.addJetpack(meta, this);
    }

    public static Jetpack getJetpack(int meta) {
        return jetpacks.get(meta);
    }

    public static int getHighestMeta() {
        return highestMeta;
    }

    public static void addJetpack(int meta, Jetpack jetpack) {
        jetpacks.put(meta, jetpack);
        if (highestMeta < meta) {
            highestMeta = meta;
        }
    }

    public static void reconstructJetpacks() {
        new JetpackPotato(0, 0, SJConfig.tuberousEnergyCapacity, SJConfig.tuberousEnergyPerTick, SJConfig.tuberousSpeedVertical, SJConfig.tuberousAccelVertical);
        new Jetpack(1, 1, SJConfig.leadstoneEnchantable, EnumRarity.common, SJConfig.leadstoneEnergyCapacity, SJConfig.leadstoneEnergyPerTick, SJConfig.leadstoneSpeedVertical, SJConfig.leadstoneAccelVertical, (float)SJConfig.leadstoneSpeedSideways, SJConfig.leadstoneSpeedVerticalHover, SJConfig.leadstoneSpeedVerticalHoverSlow, SJConfig.leadstoneEmergencyHoverMode);
        new Jetpack(2, 2, SJConfig.hardenedEnchantable, EnumRarity.common, SJConfig.hardenedEnergyCapacity, SJConfig.hardenedEnergyPerTick, SJConfig.hardenedSpeedVertical, SJConfig.hardenedAccelVertical, (float)SJConfig.hardenedSpeedSideways, SJConfig.hardenedSpeedVerticalHover, SJConfig.hardenedSpeedVerticalHoverSlow, SJConfig.hardenedEmergencyHoverMode);
        new Jetpack(3, 3, SJConfig.reinforcedEnchantable, EnumRarity.uncommon, SJConfig.reinforcedEnergyCapacity, SJConfig.reinforcedEnergyPerTick, SJConfig.reinforcedSpeedVertical, SJConfig.reinforcedAccelVertical, (float)SJConfig.reinforcedSpeedSideways, SJConfig.reinforcedSpeedVerticalHover, SJConfig.reinforcedSpeedVerticalHoverSlow, SJConfig.reinforcedEmergencyHoverMode);
        new Jetpack(4, 4, SJConfig.resonantEnchantable, EnumRarity.rare, SJConfig.resonantEnergyCapacity, SJConfig.resonantEnergyPerTick, SJConfig.resonantSpeedVertical, SJConfig.resonantAccelVertical, (float)SJConfig.resonantSpeedSideways, SJConfig.resonantSpeedVerticalHover, SJConfig.resonantSpeedVerticalHoverSlow, SJConfig.resonantEmergencyHoverMode);
        new JetpackArmored(101, 1, SJConfig.leadstoneEnchantable, EnumRarity.common, SJConfig.leadstoneEnergyCapacity, SJConfig.leadstoneEnergyPerTick, SJConfig.leadstoneSpeedVertical, SJConfig.leadstoneAccelVertical, (float)SJConfig.leadstoneSpeedSideways, SJConfig.leadstoneSpeedVerticalHover, SJConfig.leadstoneSpeedVerticalHoverSlow, SJConfig.leadstoneEmergencyHoverMode, SJConfig.leadstoneArmorDisplay, SJConfig.leadstoneArmorAbsorption, SJConfig.leadstoneArmorEnergyPerHit);
        new JetpackArmored(102, 2, SJConfig.hardenedEnchantable, EnumRarity.common, SJConfig.hardenedEnergyCapacity, SJConfig.hardenedEnergyPerTick, SJConfig.hardenedSpeedVertical, SJConfig.hardenedAccelVertical, (float)SJConfig.hardenedSpeedSideways, SJConfig.hardenedSpeedVerticalHover, SJConfig.hardenedSpeedVerticalHoverSlow, SJConfig.hardenedEmergencyHoverMode, SJConfig.hardenedArmorDisplay, SJConfig.hardenedArmorAbsorption, SJConfig.hardenedArmorEnergyPerHit);
        new JetpackArmored(103, 3, SJConfig.reinforcedEnchantable, EnumRarity.uncommon, SJConfig.reinforcedEnergyCapacity, SJConfig.reinforcedEnergyPerTick, SJConfig.reinforcedSpeedVertical, SJConfig.reinforcedAccelVertical, (float)SJConfig.reinforcedSpeedSideways, SJConfig.reinforcedSpeedVerticalHover, SJConfig.reinforcedSpeedVerticalHoverSlow, SJConfig.reinforcedEmergencyHoverMode, SJConfig.reinforcedArmorDisplay, SJConfig.reinforcedArmorAbsorption, SJConfig.reinforcedArmorEnergyPerHit);
        new JetpackArmored(104, 4, SJConfig.resonantEnchantable, EnumRarity.rare, SJConfig.resonantEnergyCapacity, SJConfig.resonantEnergyPerTick, SJConfig.resonantSpeedVertical, SJConfig.resonantAccelVertical, (float)SJConfig.resonantSpeedSideways, SJConfig.resonantSpeedVerticalHover, SJConfig.resonantSpeedVerticalHoverSlow, SJConfig.resonantEmergencyHoverMode, SJConfig.resonantArmorDisplay, SJConfig.resonantArmorAbsorption, SJConfig.resonantArmorEnergyPerHit);
        new JetpackCreative(9001, SJConfig.creativeEnchantable, SJConfig.creativeSpeedVertical, SJConfig.creativeAccelVertical, (float)SJConfig.creativeSpeedSideways, SJConfig.creativeSpeedVerticalHover, SJConfig.creativeSpeedVerticalHoverSlow, SJConfig.creativeEmergencyHoverMode, SJConfig.creativeArmorDisplay, SJConfig.creativeArmorAbsorption, 0);
        new JetpackIcon(9002);
    }

    public String getBaseName() {
        return "jetpack." + this.tier;
    }

    public boolean isArmored() {
        return false;
    }

    public boolean hasArmoredVersion() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    public boolean hasEmptyItem() {
        return true;
    }

    public boolean hasDamageBar() {
        return true;
    }

    public int getPlatingMeta() {
        return this.tier + 120;
    }

    public void useJetpack(EntityLivingBase user, ItemStack armor, ItemJetpack item, boolean force) {
        if (this.isOn(armor)) {
            double currentAccel;
            boolean hoverMode = this.isHoverModeOn(armor);
            double hoverSpeed = this.getHoverSpeed(armor, user);
            boolean jumpKeyDown = true;
            double d = currentAccel = user.field_70181_x < 0.3 ? this.accelVertical * 2.5 : this.accelVertical;
            if (!force && user instanceof EntityPlayer && !SyncTracker.isJumpKeyDown((EntityPlayer)user)) {
                jumpKeyDown = false;
            }
            if (jumpKeyDown || hoverMode && !user.field_70122_E && user.field_70181_x < 0.0) {
                int usedPower;
                int n = usedPower = hoverMode ? this.energyPerTickHover : this.energyPerTick;
                if (!user.field_70170_p.field_72995_K) {
                    item.extractEnergy(armor, usedPower, false);
                }
                if (item.getEnergyStored(armor) > 0) {
                    user.field_70181_x = jumpKeyDown ? (!hoverMode ? Math.min(user.field_70181_x + currentAccel, this.speedVertical) : Math.min(user.field_70181_x + currentAccel, this.speedVerticalHover)) : Math.min(user.field_70181_x + currentAccel, -hoverSpeed);
                    if (user instanceof EntityPlayer) {
                        if (SyncTracker.isForwardKeyDown((EntityPlayer)user)) {
                            user.func_70060_a(0.0f, this.speedSideways, this.speedSideways);
                        }
                        if (SyncTracker.isBackwardKeyDown((EntityPlayer)user)) {
                            user.func_70060_a(0.0f, -this.speedSideways, this.speedSideways * 0.8f);
                        }
                        if (SyncTracker.isLeftKeyDown((EntityPlayer)user)) {
                            user.func_70060_a(this.speedSideways, 0.0f, this.speedSideways);
                        }
                        if (SyncTracker.isRightKeyDown((EntityPlayer)user)) {
                            user.func_70060_a(-this.speedSideways, 0.0f, this.speedSideways);
                        }
                    }
                    if (!user.field_70170_p.field_72995_K) {
                        user.field_70143_R = 0.0f;
                        if (user instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)user).field_71135_a.field_147365_f = 0;
                        }
                    }
                }
            }
        }
        if (!(user.field_70170_p.field_72995_K || !this.emergencyHoverMode || item.getEnergyStored(armor) <= 0 || this.isHoverModeOn(armor) && this.isOn(armor))) {
            if (user.field_70163_u < -5.0) {
                this.doEmergencyHoverMode(armor, user);
            } else if (user instanceof EntityPlayer && !((EntityPlayer)user).field_71075_bZ.field_75098_d && user.field_70143_R - 1.2f >= user.func_110143_aJ()) {
                for (int i = 0; i <= 10; ++i) {
                    if (user.field_70170_p.func_147437_c(Math.round((float)user.field_70165_t - 0.5f), Math.round((float)user.field_70163_u) - i, Math.round((float)user.field_70161_v - 0.5f))) continue;
                    this.doEmergencyHoverMode(armor, user);
                    break;
                }
            }
        }
    }

    public void doEmergencyHoverMode(ItemStack armor, EntityLivingBase user) {
        StackUtils.getNBT(armor).func_74757_a("JetpackOn", true);
        StackUtils.getNBT(armor).func_74757_a("JetpackHoverModeOn", true);
        if (user instanceof EntityPlayer) {
            ((EntityPlayer)user).func_145747_a((IChatComponent)new ChatComponentText("\u00a7c" + StringUtils.translate("chat.jetpack.emergencyHoverMode")));
        }
    }

    public boolean isOn(ItemStack itemStack) {
        return StackUtils.getNBT(itemStack).func_74767_n("JetpackOn");
    }

    public JetpackParticleType particleToShow(ItemStack itemStack, ItemJetpack item, EntityLivingBase user) {
        boolean jumpKeyDown = true;
        if (user instanceof EntityPlayer && !SyncTracker.isJumpKeyDown((EntityPlayer)user)) {
            jumpKeyDown = false;
        }
        if (this.isOn(itemStack) && item.getEnergyStored(itemStack) > 0 && (jumpKeyDown || this.isHoverModeOn(itemStack) && !user.field_70122_E && user.field_70181_x < 0.0)) {
            return this.getParticleType(itemStack);
        }
        return null;
    }

    public void toggle(ItemStack itemStack, EntityPlayer player) {
        String msg = "";
        if (this.isOn(itemStack)) {
            msg = StringUtils.translate("chat.jetpack.engine") + " " + "\u00a7c" + StringUtils.translate("chat.disabled");
            itemStack.field_77990_d.func_74757_a("JetpackOn", false);
        } else {
            msg = StringUtils.translate("chat.jetpack.engine") + " " + "\u00a7a" + StringUtils.translate("chat.enabled");
            itemStack.field_77990_d.func_74757_a("JetpackOn", true);
        }
        player.func_145747_a((IChatComponent)new ChatComponentText(msg));
    }

    public boolean isHoverModeOn(ItemStack itemStack) {
        return StackUtils.getNBT(itemStack).func_74767_n("JetpackHoverModeOn");
    }

    public void toggleHoverMode(ItemStack itemStack, EntityPlayer player) {
        String msg = "";
        if (this.isHoverModeOn(itemStack)) {
            msg = StringUtils.translate("chat.jetpack.hoverMode") + " " + "\u00a7c" + StringUtils.translate("chat.disabled");
            itemStack.field_77990_d.func_74757_a("JetpackHoverModeOn", false);
        } else {
            msg = StringUtils.translate("chat.jetpack.hoverMode") + " " + "\u00a7a" + StringUtils.translate("chat.enabled");
            itemStack.field_77990_d.func_74757_a("JetpackHoverModeOn", true);
        }
        player.func_145747_a((IChatComponent)new ChatComponentText(msg));
    }

    public double getHoverSpeed(ItemStack jetpack, EntityLivingBase user) {
        if (SJConfig.invertHoverSneakingBehavior) {
            return user.func_70093_af() ? this.speedVerticalHoverSlow : this.speedVerticalHover;
        }
        return user.func_70093_af() ? this.speedVerticalHover : this.speedVerticalHoverSlow;
    }

    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, int energyStored) {
        list.add(StringUtils.getChargeText(this.tier == 9001, energyStored, this.energyCapacity));
        if (StringUtils.canShowDetails()) {
            list.add(StringUtils.getStateText(this.isOn(itemStack)));
            list.add(StringUtils.getHoverModeText(this.isHoverModeOn(itemStack)));
            int currentTickEnergy = this.isHoverModeOn(itemStack) ? this.energyPerTickHover : this.energyPerTick;
            list.add(StringUtils.getEnergyUsageText(currentTickEnergy));
            list.add(StringUtils.getArmoredText(this.isArmored()));
            list.add(StringUtils.getParticlesText(this.getParticleType(itemStack)));
            list.add("\u00a7a" + StringUtils.translate("tooltip.jetpack.description.1"));
            list.add("\u00a7a" + StringUtils.translate("tooltip.jetpack.description.2"));
            if (this.hasArmoredVersion() && SJConfig.enableCraftingArmorPlating) {
                list.add(StringUtils.getArmorText(this.isArmored()));
                if (!this.isArmored()) {
                    list.add(StringUtils.getRequiredArmorText(this.getPlatingMeta() - 120));
                }
            }
        } else {
            list.add(StringUtils.getShiftText());
        }
    }

    public JetpackParticleType getParticleType(ItemStack jetpack) {
        int particle = StackUtils.getNBT(jetpack).func_74762_e("JetpackParticleType");
        JetpackParticleType particleType = JetpackParticleType.values()[particle];
        if (particleType != null) {
            return particleType;
        }
        return JetpackParticleType.DEFAULT;
    }

    public void setParticleType(ItemStack jetpack, JetpackParticleType particle) {
        StackUtils.getNBT(jetpack).func_74768_a("JetpackParticleType", particle.ordinal());
    }

    public void applyArmor(ItemStack itemStack, EntityPlayer player) {
        itemStack.func_77964_b(itemStack.func_77960_j() + 100);
        player.field_70170_p.func_72956_a((Entity)player, "random.anvil_use", 0.8f, 0.9f + player.func_70681_au().nextFloat() * 0.2f);
    }

    public void removeArmor(ItemStack itemStack, EntityPlayer player) {
        itemStack.func_77964_b(itemStack.func_77960_j() - 100);
        player.field_70170_p.func_72956_a((Entity)player, "random.break", 1.0f, 0.9f + player.func_70681_au().nextFloat() * 0.2f);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemJetpack item, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, 1.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemJetpack item, ItemStack armor, int slot) {
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemJetpack item, ItemStack armor, DamageSource source, int damage, int slot) {
    }
}

