/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.setup;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import tonius.simplyjetpacks.SimplyJetpacks;
import tonius.simplyjetpacks.config.SJConfig;
import tonius.simplyjetpacks.integration.TEItems;
import tonius.simplyjetpacks.integration.TERecipes;
import tonius.simplyjetpacks.item.ItemJetpack;
import tonius.simplyjetpacks.item.ItemMeta;
import tonius.simplyjetpacks.item.MetaItem;
import tonius.simplyjetpacks.item.jetpack.Jetpack;
import tonius.simplyjetpacks.recipes.JetpackUpgradingRecipe;

public class SJItems {
    public static ItemJetpack jetpacks = null;
    public static ItemMeta components = null;
    public static ItemMeta particleCustomizers = null;
    private static boolean teAvailable = false;

    public static void preInit() {
        SJItems.constructItems();
        SJItems.registerItems();
    }

    public static void init() {
        teAvailable = TEItems.init();
        SJItems.registerRecipes();
        SJItems.doIMC();
    }

    private static void constructItems() {
        SimplyJetpacks.logger.info("Constructing items");
        Jetpack.reconstructJetpacks();
        jetpacks = new ItemJetpack();
        HashMap<Integer, MetaItem> componentsMap = new HashMap<Integer, MetaItem>();
        String[] leatherStrapTooltips = new String[]{"tooltip.leatherStrap.description.1", "tooltip.leatherStrap.description.2"};
        componentsMap.put(0, new MetaItem("leatherStrap", leatherStrapTooltips, EnumRarity.common));
        String[] thrusterTooltips = new String[]{"tooltip.thruster.description.1", "tooltip.thruster.description.2"};
        componentsMap.put(11, new MetaItem("thruster.1", thrusterTooltips, EnumRarity.common));
        componentsMap.put(12, new MetaItem("thruster.2", thrusterTooltips, EnumRarity.common));
        componentsMap.put(13, new MetaItem("thruster.3", thrusterTooltips, EnumRarity.uncommon));
        componentsMap.put(14, new MetaItem("thruster.4", thrusterTooltips, EnumRarity.rare));
        String[] armorPlatingTooltips = new String[]{"tooltip.armorPlating.description.1", "tooltip.armorPlating.description.2"};
        componentsMap.put(121, new MetaItem("armorPlating.1", armorPlatingTooltips, EnumRarity.common));
        componentsMap.put(122, new MetaItem("armorPlating.2", armorPlatingTooltips, EnumRarity.common));
        componentsMap.put(123, new MetaItem("armorPlating.3", armorPlatingTooltips, EnumRarity.common));
        componentsMap.put(124, new MetaItem("armorPlating.4", armorPlatingTooltips, EnumRarity.rare));
        components = new ItemMeta(componentsMap, "components");
        HashMap<Integer, MetaItem> particlesMap = new HashMap<Integer, MetaItem>();
        String[] particlesTooltips = new String[]{"tooltip.particleCustomizers.description.1", "tooltip.particleCustomizers.description.2"};
        particlesMap.put(0, new MetaItem("particle.0", particlesTooltips, EnumRarity.common));
        particlesMap.put(1, new MetaItem("particle.1", particlesTooltips, EnumRarity.common));
        particlesMap.put(2, new MetaItem("particle.2", particlesTooltips, EnumRarity.common));
        particlesMap.put(3, new MetaItem("particle.3", particlesTooltips, EnumRarity.common));
        particleCustomizers = new ItemMeta(particlesMap, "particleCustomizers");
    }

    private static void registerItems() {
        SimplyJetpacks.logger.info("Registering items");
        GameRegistry.registerItem((Item)jetpacks, (String)"jetpacks");
        GameRegistry.registerItem((Item)components, (String)"components");
        GameRegistry.registerItem((Item)particleCustomizers, (String)"particleCustomizers");
    }

    private static void registerRecipes() {
        SimplyJetpacks.logger.info("Registering recipes");
        if (teAvailable) {
            if (SJConfig.enableCraftingPotatoJetpack) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(jetpacks.getChargedItem(jetpacks, 0).func_77946_l(), new Object[]{"S S", "NPN", "R R", Character.valueOf('S'), Items.field_151007_F, Character.valueOf('N'), "nuggetTin", Character.valueOf('P'), TEItems.capacitorPotato.func_77946_l(), Character.valueOf('R'), "dustRedstone"}));
            }
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)components, 1, 0), new Object[]{"LIL", "LIL", Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('I'), "ingotIron"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)components, 1, 11), new Object[]{"ICI", "PGP", "DSD", Character.valueOf('I'), "ingotLead", Character.valueOf('P'), Blocks.field_150359_w, Character.valueOf('C'), TEItems.powerCoilGold.func_77946_l(), Character.valueOf('G'), "gearCopper", Character.valueOf('D'), TEItems.dynamoSteam.func_77946_l(), Character.valueOf('S'), TEItems.pneumaticServo.func_77946_l()}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)components, 1, 12), new Object[]{"ICI", "PGP", "DSD", Character.valueOf('I'), "ingotInvar", Character.valueOf('P'), Blocks.field_150451_bX, Character.valueOf('C'), TEItems.powerCoilGold.func_77946_l(), Character.valueOf('G'), "gearBronze", Character.valueOf('D'), TEItems.dynamoReactant.func_77946_l(), Character.valueOf('S'), TEItems.pneumaticServo.func_77946_l()}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)components, 1, 13), new Object[]{"ICI", "PGP", "DSD", Character.valueOf('I'), "ingotElectrum", Character.valueOf('P'), "ingotSignalum", Character.valueOf('C'), TEItems.powerCoilGold.func_77946_l(), Character.valueOf('G'), "gearInvar", Character.valueOf('D'), TEItems.dynamoMagmatic.func_77946_l(), Character.valueOf('S'), TEItems.pneumaticServo.func_77946_l()}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)components, 1, 14), new Object[]{"ICI", "PGP", "DSD", Character.valueOf('I'), "ingotEnderium", Character.valueOf('P'), "ingotLumium", Character.valueOf('C'), TEItems.powerCoilGold.func_77946_l(), Character.valueOf('G'), "gearElectrum", Character.valueOf('D'), TEItems.dynamoEnervation.func_77946_l(), Character.valueOf('S'), TEItems.pneumaticServo.func_77946_l()}));
            if (SJConfig.enableCraftingArmorPlating) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)components, 1, 121), new Object[]{"TIT", "III", "TIT", Character.valueOf('I'), "ingotIron", Character.valueOf('T'), "ingotTin"}));
            }
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)jetpacks, 1, 1), new Object[]{"IBI", "IJI", "T T", Character.valueOf('I'), "ingotLead", Character.valueOf('B'), TEItems.capacitorBasic.func_77946_l(), Character.valueOf('T'), new ItemStack((Item)components, 1, 11), Character.valueOf('J'), new ItemStack((Item)components, 1, 0)}));
            GameRegistry.addRecipe((IRecipe)new JetpackUpgradingRecipe(new ItemStack((Item)jetpacks, 1, 2), new Object[]{"IBI", "IJI", "T T", Character.valueOf('I'), "ingotInvar", Character.valueOf('B'), TEItems.capacitorHardened.func_77946_l(), Character.valueOf('T'), new ItemStack((Item)components, 1, 12), Character.valueOf('J'), new ItemStack((Item)jetpacks, 1, 1)}));
            GameRegistry.addRecipe((IRecipe)new JetpackUpgradingRecipe(new ItemStack((Item)jetpacks, 1, 3), new Object[]{"IBI", "IJI", "T T", Character.valueOf('I'), "ingotElectrum", Character.valueOf('B'), TEItems.capacitorReinforced.func_77946_l(), Character.valueOf('T'), new ItemStack((Item)components, 1, 13), Character.valueOf('J'), new ItemStack((Item)jetpacks, 1, 2)}));
            GameRegistry.addRecipe((IRecipe)new JetpackUpgradingRecipe(new ItemStack((Item)jetpacks, 1, 4), new Object[]{"IBI", "IJI", "T T", Character.valueOf('I'), "ingotEnderium", Character.valueOf('B'), TEItems.capacitorResonant.func_77946_l(), Character.valueOf('T'), new ItemStack((Item)components, 1, 14), Character.valueOf('J'), new ItemStack((Item)jetpacks, 1, 3)}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)particleCustomizers, 1, 0), new Object[]{" D ", "DCD", " D ", Character.valueOf('C'), "dustCoal", Character.valueOf('D'), Blocks.field_150478_aa}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)particleCustomizers, 1, 1), new Object[]{" D ", "DCD", " D ", Character.valueOf('C'), "dustCoal", Character.valueOf('D'), Blocks.field_150359_w}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)particleCustomizers, 1, 2), new Object[]{" C ", "CCC", " C ", Character.valueOf('C'), "dustCoal"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)particleCustomizers, 1, 3), new Object[]{" R ", " C ", "G B", Character.valueOf('C'), "dustCoal", Character.valueOf('R'), "dyeRed", Character.valueOf('G'), "dyeLime", Character.valueOf('B'), "dyeBlue"}));
        }
        for (int i = 0; i <= Jetpack.getHighestMeta(); ++i) {
            Jetpack jetpack = Jetpack.getJetpack(i);
            if (jetpack == null) continue;
            GameRegistry.addRecipe((IRecipe)new JetpackUpgradingRecipe(new ItemStack((Item)jetpacks, 1, i), new Object[]{"J", "P", Character.valueOf('J'), new ItemStack((Item)jetpacks, 1, i), Character.valueOf('P'), new ItemStack((Item)particleCustomizers, 1, Short.MAX_VALUE)}));
        }
    }

    private static void doIMC() {
        SimplyJetpacks.logger.info("Doing intermod communication");
        if (teAvailable && SJConfig.enableCraftingArmorPlating) {
            for (int i = 0; i < OreDictionary.getOres((String)"ingotBronze").size(); ++i) {
                ItemStack ingotBronze = ((ItemStack)OreDictionary.getOres((String)"ingotBronze").get(i)).func_77946_l();
                ingotBronze.field_77994_a = 10;
                TERecipes.addSmelterRecipe(3200, new ItemStack((Item)components, 1, 121), ingotBronze, new ItemStack((Item)components, 1, 122), null, 0);
            }
            for (int i = 0; i < OreDictionary.getOres((String)"ingotInvar").size(); ++i) {
                ItemStack ingotInvar = ((ItemStack)OreDictionary.getOres((String)"ingotInvar").get(i)).func_77946_l();
                ingotInvar.field_77994_a = 10;
                TERecipes.addSmelterRecipe(4800, new ItemStack((Item)components, 1, 122), ingotInvar, new ItemStack((Item)components, 1, 123), null, 0);
            }
            for (int i = 0; i < OreDictionary.getOres((String)"ingotEnderium").size(); ++i) {
                ItemStack ingotEnderium = ((ItemStack)OreDictionary.getOres((String)"ingotEnderium").get(i)).func_77946_l();
                ingotEnderium.field_77994_a = 10;
                TERecipes.addSmelterRecipe(6400, new ItemStack((Item)components, 1, 123), ingotEnderium, new ItemStack((Item)components, 1, 124), null, 0);
            }
        }
    }
}

