/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block;

import cofh.api.tileentity.ISecurable;
import cofh.network.PacketCoFHBase;
import cofh.util.BlockHelper;
import cofh.util.ServerHelper;
import cofh.util.StringHelper;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileTEBase;
import thermalexpansion.util.Utils;

public abstract class TileInventory
extends TileTEBase
implements IInventory,
ISecurable {
    protected String owner = "[None]";
    protected ISecurable.AccessMode access = ISecurable.AccessMode.PUBLIC;
    protected boolean canAccess = true;
    public ItemStack[] inventory = new ItemStack[0];

    public boolean canAccess() {
        return this.canAccess;
    }

    public boolean isSecured() {
        return !this.owner.equals("[None]");
    }

    public boolean enableSecurity() {
        return true;
    }

    public boolean transferItem(int n, int n2, int n3) {
        if (this.inventory[n] == null || n > this.inventory.length) {
            return false;
        }
        ItemStack itemStack = this.inventory[n].func_77946_l();
        itemStack.field_77994_a = n2 = Math.min(n2, itemStack.field_77994_a);
        TileEntity tileEntity = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)n3);
        if (Utils.isInventory(tileEntity, n3)) {
            this.inventory[n].field_77994_a -= n2 - Utils.addToInventory(tileEntity, n3, itemStack);
            if (this.inventory[n].field_77994_a <= 0) {
                this.inventory[n] = null;
            }
            return true;
        }
        if (Utils.isPipeTile(tileEntity)) {
            this.inventory[n].field_77994_a -= Utils.addToPipeTile(tileEntity, n3, itemStack);
            if (this.inventory[n].field_77994_a <= 0) {
                this.inventory[n] = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public int getInvSlotCount() {
        return this.inventory.length;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean openGui(EntityPlayer entityPlayer) {
        if (this.canPlayerAccess(entityPlayer.getDisplayName())) {
            if (this.hasGui()) {
                entityPlayer.openGui((Object)ThermalExpansion.instance, 0, ((TileEntity)this).field_145850_b, ((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
            }
            return this.hasGui();
        }
        if (ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b)) {
            entityPlayer.func_145747_a((IChatComponent)new ChatComponentText(StringHelper.localize((String)"chat.cofh.secure1") + " " + this.owner + "! " + StringHelper.localize((String)"chat.cofh.secure2")));
        }
        return this.hasGui();
    }

    public void receiveGuiNetworkData(int n, int n2) {
        this.canAccess = n2 != 0;
    }

    @Override
    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        super.sendGuiNetworkData(container, iCrafting);
        iCrafting.func_71112_a(container, 0, this.canPlayerAccess(((EntityPlayer)iCrafting).getDisplayName()) ? 1 : 0);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.access = ISecurable.AccessMode.values()[nBTTagCompound.func_74771_c("Access")];
        this.owner = nBTTagCompound.func_74779_i("Owner");
        if (!this.enableSecurity()) {
            this.access = ISecurable.AccessMode.PUBLIC;
        }
        this.readInventoryFromNBT(nBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74774_a("Access", (byte)this.access.ordinal());
        nBTTagCompound.func_74778_a("Owner", this.owner);
        this.writeInventoryToNBT(nBTTagCompound);
    }

    public void readInventoryFromNBT(NBTTagCompound nBTTagCompound) {
        NBTTagList nBTTagList = nBTTagCompound.func_150295_c("Inventory", 10);
        this.inventory = new ItemStack[this.inventory.length];
        for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
            NBTTagCompound nBTTagCompound2 = nBTTagList.func_150305_b(i);
            int n = nBTTagCompound2.func_74762_e("Slot");
            if (n < 0 || n >= this.inventory.length) continue;
            this.inventory[n] = ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound2);
        }
    }

    public void writeInventoryToNBT(NBTTagCompound nBTTagCompound) {
        if (this.inventory.length <= 0) {
            return;
        }
        NBTTagList nBTTagList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound2.func_74768_a("Slot", i);
            this.inventory[i].func_77955_b(nBTTagCompound2);
            nBTTagList.func_74742_a((NBTBase)nBTTagCompound2);
        }
        nBTTagCompound.func_74782_a("Inventory", (NBTBase)nBTTagList);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addByte((byte)this.access.ordinal());
        packetCoFHBase.addString(this.owner);
        return packetCoFHBase;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        this.access = ISecurable.AccessMode.values()[packetCoFHBase.getByte()];
        if (!bl) {
            this.owner = packetCoFHBase.getString();
        } else {
            packetCoFHBase.getString();
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int n) {
        return this.inventory[n];
    }

    public ItemStack func_70298_a(int n, int n2) {
        if (this.inventory[n] == null) {
            return null;
        }
        if (this.inventory[n].field_77994_a <= n2) {
            n2 = this.inventory[n].field_77994_a;
        }
        ItemStack itemStack = this.inventory[n].func_77979_a(n2);
        if (this.inventory[n].field_77994_a <= 0) {
            this.inventory[n] = null;
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int n) {
        if (this.inventory[n] == null) {
            return null;
        }
        ItemStack itemStack = this.inventory[n];
        this.inventory[n] = null;
        return itemStack;
    }

    public void func_70299_a(int n, ItemStack itemStack) {
        this.inventory[n] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        this.markChunkDirty();
    }

    public String func_145825_b() {
        return this.tileName.isEmpty() ? this.getName() : this.tileName;
    }

    public boolean func_145818_k_() {
        return !this.tileName.isEmpty();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.isUseable(entityPlayer);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int n, ItemStack itemStack) {
        return true;
    }

    public boolean setAccess(ISecurable.AccessMode accessMode) {
        this.access = accessMode;
        this.sendUpdatePacket(Side.SERVER);
        return true;
    }

    public ISecurable.AccessMode getAccess() {
        return this.access;
    }

    public boolean setOwnerName(String string) {
        if (this.owner.equals("[None]")) {
            this.owner = string;
            this.markChunkDirty();
            return true;
        }
        return false;
    }

    public String getOwnerName() {
        return this.owner;
    }
}

