/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.cache;

import cofh.api.tileentity.ISidedTexture;
import cofh.block.BlockCoFHBase;
import cofh.render.IconRegistry;
import cofh.util.CoreUtils;
import cofh.util.ItemHelper;
import cofh.util.ServerHelper;
import cofh.util.StringHelper;
import cofh.util.crafting.RecipeUpgrade;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.ShapedOreRecipe;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.BlockTEBase;
import thermalexpansion.block.cache.TileCache;

public class BlockCache
extends BlockTEBase {
    public static final String[] NAMES = new String[]{"creative", "basic", "hardened", "reinforced", "resonant"};
    public static boolean[] enable = new boolean[Types.values().length];
    public static ItemStack cacheCreative;
    public static ItemStack cacheBasic;
    public static ItemStack cacheHardened;
    public static ItemStack cacheReinforced;
    public static ItemStack cacheResonant;

    public BlockCache() {
        super(Material.field_151573_f);
        this.func_149711_c(15.0f);
        this.func_149752_b(25.0f);
        this.func_149663_c("thermalexpansion.cache");
        this.setHarvestLevel("pickaxe", 1);
    }

    public TileEntity func_149915_a(World world, int n) {
        if (n >= Types.values().length) {
            return null;
        }
        if (n == Types.CREATIVE.ordinal() && !enable[Types.CREATIVE.ordinal()]) {
            return null;
        }
        return new TileCache(n);
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < Types.values().length; ++i) {
            if (!enable[i]) continue;
            list.add(new ItemStack(item, 1, i));
        }
    }

    public boolean func_149740_M() {
        return true;
    }

    @Override
    public void func_149689_a(World world, int n, int n2, int n3, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        if (itemStack.field_77990_d != null) {
            TileCache tileCache = (TileCache)world.func_147438_o(n, n2, n3);
            tileCache.locked = itemStack.field_77990_d.func_74767_n("Lock");
            if (itemStack.field_77990_d.func_74764_b("Item")) {
                ItemStack itemStack2 = ItemHelper.readItemStackFromNBT((NBTTagCompound)itemStack.field_77990_d.func_74775_l("Item"));
                tileCache.setStoredItemType(itemStack2, itemStack2.field_77994_a);
            }
        }
        super.func_149689_a(world, n, n2, n3, entityLivingBase, itemStack);
    }

    @Override
    public boolean func_149727_a(World world, int n, int n2, int n3, EntityPlayer entityPlayer, int n4, float f, float f2, float f3) {
        if (super.func_149727_a(world, n, n2, n3, entityPlayer, n4, f, f2, f3)) {
            return true;
        }
        if (ServerHelper.isClientWorld((World)world)) {
            return true;
        }
        TileCache tileCache = (TileCache)world.func_147438_o(n, n2, n3);
        if (ItemHelper.isPlayerHoldingNothing((EntityPlayer)entityPlayer)) {
            if (entityPlayer.func_70093_af()) {
                tileCache.toggleLock();
                return true;
            }
            if (tileCache.getStoredItemType() != null) {
                for (int i = 0; i < entityPlayer.field_71071_by.func_70302_i_(); ++i) {
                    if (tileCache.insertItem(ForgeDirection.UNKNOWN, entityPlayer.field_71071_by.func_70301_a(i), true) == entityPlayer.field_71071_by.func_70301_a(i)) continue;
                    entityPlayer.field_71071_by.func_70299_a(i, tileCache.insertItem(ForgeDirection.UNKNOWN, entityPlayer.field_71071_by.func_70301_a(i), false));
                }
            }
            return true;
        }
        ItemStack itemStack = entityPlayer.func_71045_bC();
        ItemStack itemStack2 = tileCache.insertItem(ForgeDirection.UNKNOWN, itemStack, false);
        if (!entityPlayer.field_71075_bZ.field_75098_d && itemStack2 != itemStack) {
            entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, itemStack2);
        }
        return true;
    }

    public void func_149699_a(World world, int n, int n2, int n3, EntityPlayer entityPlayer) {
        if (ServerHelper.isClientWorld((World)world)) {
            return;
        }
        TileCache tileCache = (TileCache)world.func_147438_o(n, n2, n3);
        int n4 = entityPlayer.func_70093_af() ? 1 : 64;
        ItemStack itemStack = tileCache.extractItem(ForgeDirection.UNKNOWN, n4, true);
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            if (!entityPlayer.field_71071_by.func_70441_a(itemStack)) {
                return;
            }
            tileCache.extractItem(ForgeDirection.UNKNOWN, n4, false);
        } else {
            tileCache.extractItem(ForgeDirection.UNKNOWN, n4, false);
        }
    }

    public float func_149737_a(EntityPlayer entityPlayer, World world, int n, int n2, int n3) {
        ItemStack itemStack = entityPlayer.func_71045_bC();
        if (itemStack == null || !ForgeHooks.isToolEffective((ItemStack)itemStack, (Block)world.func_147439_a(n, n2, n3), (int)world.func_72805_g(n, n2, n3))) {
            return -1.0f;
        }
        return super.func_149737_a(entityPlayer, world, n, n2, n3);
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int n) {
        BlockCoFHBase.renderPass = n;
        return n < 2;
    }

    public boolean func_149662_c() {
        return true;
    }

    public boolean func_149686_d() {
        return true;
    }

    public IIcon func_149673_e(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        ISidedTexture iSidedTexture = (ISidedTexture)iBlockAccess.func_147438_o(n, n2, n3);
        return iSidedTexture == null ? null : iSidedTexture.getTexture(n4, BlockCoFHBase.renderPass);
    }

    @Override
    public IIcon func_149691_a(int n, int n2) {
        if (n == 0) {
            return IconRegistry.getIcon((String)"CacheBottom", (int)n2);
        }
        if (n == 1) {
            return IconRegistry.getIcon((String)"CacheTop", (int)n2);
        }
        return n != 3 ? IconRegistry.getIcon((String)"CacheSide", (int)n2) : IconRegistry.getIcon((String)"CacheFace", (int)n2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        int n;
        for (n = 0; n < 9; ++n) {
            IconRegistry.addIcon((String)("CacheMeter" + n), (String)("thermalexpansion:cache/Cache_Meter_" + n), (IIconRegister)iIconRegister);
        }
        for (n = 0; n < Types.values().length; ++n) {
            IconRegistry.addIcon((String)("CacheBottom" + n), (String)("thermalexpansion:cache/Cache_" + StringHelper.titleCase((String)NAMES[n]) + "_Bottom"), (IIconRegister)iIconRegister);
            IconRegistry.addIcon((String)("CacheTop" + n), (String)("thermalexpansion:cache/Cache_" + StringHelper.titleCase((String)NAMES[n]) + "_Top"), (IIconRegister)iIconRegister);
            IconRegistry.addIcon((String)("CacheSide" + n), (String)("thermalexpansion:cache/Cache_" + StringHelper.titleCase((String)NAMES[n]) + "_Side"), (IIconRegister)iIconRegister);
            IconRegistry.addIcon((String)("CacheFace" + n), (String)("thermalexpansion:cache/Cache_" + StringHelper.titleCase((String)NAMES[n]) + "_Face"), (IIconRegister)iIconRegister);
        }
        IconRegistry.addIcon((String)"CacheBlank", (String)"thermalexpansion:config/Config_None", (IIconRegister)iIconRegister);
    }

    @Override
    public NBTTagCompound getItemStackTag(World world, int n, int n2, int n3) {
        NBTTagCompound nBTTagCompound = super.getItemStackTag(world, n, n2, n3);
        TileCache tileCache = (TileCache)world.func_147438_o(n, n2, n3);
        if (tileCache != null && tileCache.storedStack != null) {
            nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74757_a("Lock", tileCache.locked);
            nBTTagCompound.func_74782_a("Item", (NBTBase)ItemHelper.writeItemStackToNBT((ItemStack)tileCache.storedStack, (int)tileCache.getStoredCount(), (NBTTagCompound)new NBTTagCompound()));
        }
        return nBTTagCompound;
    }

    public ArrayList<ItemStack> dismantleBlock(EntityPlayer entityPlayer, World world, int n, int n2, int n3, boolean bl) {
        NBTTagCompound nBTTagCompound = this.getItemStackTag(world, n, n2, n3);
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileCache) {
            ((TileCache)tileEntity).inventory = new ItemStack[((TileCache)tileEntity).inventory.length];
        }
        return super.dismantleBlock(entityPlayer, nBTTagCompound, world, n, n2, n3, bl, false);
    }

    public boolean canDismantle(EntityPlayer entityPlayer, World world, int n, int n2, int n3) {
        if (world.func_72805_g(n, n2, n3) == Types.CREATIVE.ordinal() && !CoreUtils.isOp((EntityPlayer)entityPlayer)) {
            return false;
        }
        return super.canDismantle(entityPlayer, world, n, n2, n3);
    }

    public boolean initialize() {
        TileCache.initialize();
        cacheCreative = new ItemStack((Block)this, 1, Types.CREATIVE.ordinal());
        cacheBasic = new ItemStack((Block)this, 1, Types.BASIC.ordinal());
        cacheHardened = new ItemStack((Block)this, 1, Types.HARDENED.ordinal());
        cacheReinforced = new ItemStack((Block)this, 1, Types.REINFORCED.ordinal());
        cacheResonant = new ItemStack((Block)this, 1, Types.RESONANT.ordinal());
        return true;
    }

    public boolean postInit() {
        if (enable[Types.BASIC.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(cacheBasic, new Object[]{" I ", "IXI", " I ", Character.valueOf('I'), "ingotTin", Character.valueOf('X'), "logWood"}));
        }
        if (enable[Types.HARDENED.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeUpgrade(cacheHardened, new Object[]{" I ", "IXI", " I ", Character.valueOf('I'), "ingotInvar", Character.valueOf('X'), cacheBasic}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(cacheHardened, new Object[]{"IYI", "YXY", "IYI", Character.valueOf('I'), "ingotInvar", Character.valueOf('X'), "logWood", Character.valueOf('Y'), "ingotTin"}));
        }
        if (enable[Types.REINFORCED.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeUpgrade(cacheReinforced, new Object[]{" G ", "GXG", " G ", Character.valueOf('X'), cacheHardened, Character.valueOf('G'), "blockGlassHardened"}));
        }
        if (enable[Types.RESONANT.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeUpgrade(cacheResonant, new Object[]{" I ", "IXI", " I ", Character.valueOf('I'), "ingotEnderium", Character.valueOf('X'), cacheReinforced}));
        }
        return true;
    }

    static {
        String string = "block.feature";
        BlockCache.enable[Types.CREATIVE.ordinal()] = ThermalExpansion.config.get(string, "Cache.Creative", true);
        BlockCache.enable[Types.BASIC.ordinal()] = ThermalExpansion.config.get(string, "Cache.Basic", true);
        BlockCache.enable[Types.HARDENED.ordinal()] = ThermalExpansion.config.get(string, "Cache.Hardened", true);
        BlockCache.enable[Types.REINFORCED.ordinal()] = ThermalExpansion.config.get(string, "Cache.Reinforced", true);
        BlockCache.enable[Types.RESONANT.ordinal()] = ThermalExpansion.config.get(string, "Cache.Resonant", true);
    }

    public static enum Types {
        CREATIVE,
        BASIC,
        HARDENED,
        REINFORCED,
        RESONANT;

    }
}

