/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.device;

import cofh.entity.CoFHFakePlayer;
import cofh.render.IconRegistry;
import cofh.util.BlockHelper;
import cofh.util.FluidHelper;
import cofh.util.InventoryHelper;
import cofh.util.ServerHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileAugmentable;
import thermalexpansion.block.TileTEBase;
import thermalexpansion.block.device.BlockDevice;
import thermalexpansion.core.TEProps;
import thermalexpansion.gui.client.device.GuiBreaker;
import thermalexpansion.gui.container.ContainerTEBase;

public class TileBreaker
extends TileAugmentable
implements IFluidHandler {
    static final int TYPE = BlockDevice.Types.BREAKER.ordinal();
    static TileTEBase.SideConfig defaultSideConfig = new TileTEBase.SideConfig();
    public static boolean enableSecurity = true;
    boolean needsWorld = true;
    CoFHFakePlayer myFakePlayer;
    public LinkedList<ItemStack> stuffedItems = new LinkedList();

    public static void initialize() {
        defaultSideConfig = new TileTEBase.SideConfig();
        TileBreaker.defaultSideConfig.numGroup = 2;
        TileBreaker.defaultSideConfig.slotGroups = new int[][]{new int[0], new int[0]};
        TileBreaker.defaultSideConfig.allowInsertion = new boolean[]{false, false};
        TileBreaker.defaultSideConfig.allowExtraction = new boolean[]{false, false};
        TileBreaker.defaultSideConfig.sideTex = new int[]{0, 4};
        TileBreaker.defaultSideConfig.defaultSides = new byte[]{0, 0, 0, 0, 0, 0};
        GameRegistry.registerTileEntity(TileBreaker.class, (String)"thermalexpansion.Breaker");
        TileBreaker.configure();
    }

    public static void configure() {
        String string = "Enable this to allow for Breakers to be securable. (Default: true)";
        enableSecurity = ThermalExpansion.config.get("security", "Device.Breaker.Securable", enableSecurity, string);
    }

    public TileBreaker() {
        this.sideConfig = defaultSideConfig;
    }

    @Override
    public void setDefaultSides() {
        this.sideCache = this.getDefaultSides();
        this.sideCache[this.facing ^ 1] = 1;
    }

    public String getName() {
        return "tile.thermalexpansion.device." + BlockDevice.NAMES[this.getType()] + ".name";
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public boolean enableSecurity() {
        return enableSecurity;
    }

    @Override
    public boolean sendRedstoneUpdates() {
        return true;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b) && ((TileEntity)this).field_145850_b.func_82737_E() % 16L == 0L && this.redstoneControlOrDisable()) {
            if (!this.isEmpty()) {
                this.outputBuffer();
            }
            if (this.isEmpty()) {
                this.updateFakePlayer();
                this.breakBlock();
            }
        }
    }

    public boolean isEmpty() {
        return this.stuffedItems.size() == 0;
    }

    public void breakBlock() {
        int[] nArray = BlockHelper.getAdjacentCoordinatesForSide((int)((TileEntity)this).field_145851_c, (int)((TileEntity)this).field_145848_d, (int)((TileEntity)this).field_145849_e, (int)this.facing);
        Block block = ((TileEntity)this).field_145850_b.func_147439_a(nArray[0], nArray[1], nArray[2]);
        FluidStack fluidStack = FluidHelper.getFluidFromWorld((World)((TileEntity)this).field_145850_b, (int)nArray[0], (int)nArray[1], (int)nArray[2]);
        if (fluidStack != null) {
            for (int i = 0; i < 6 && fluidStack.amount > 0; ++i) {
                if (this.sideCache[i] != 1) continue;
                fluidStack.amount -= FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (int)i, (FluidStack)fluidStack, (boolean)true);
            }
            ((TileEntity)this).field_145850_b.func_147468_f(nArray[0], nArray[1], nArray[2]);
        } else if (CoFHFakePlayer.isBlockBreakable((CoFHFakePlayer)this.myFakePlayer, (World)((TileEntity)this).field_145850_b, (int)nArray[0], (int)nArray[1], (int)nArray[2])) {
            this.stuffedItems.addAll(BlockHelper.breakBlock((World)((TileEntity)this).field_145850_b, (int)nArray[0], (int)nArray[1], (int)nArray[2], (Block)block, (int)0, (boolean)true, (boolean)false));
        }
    }

    public void outputBuffer() {
        for (int i = 0; i < 6; ++i) {
            int[] nArray;
            TileEntity tileEntity;
            if (i == this.facing || this.sideCache[i] != 1 || !InventoryHelper.isInsertion((Object)(tileEntity = ((TileEntity)this).field_145850_b.func_147438_o((nArray = BlockHelper.getAdjacentCoordinatesForSide((int)((TileEntity)this).field_145851_c, (int)((TileEntity)this).field_145848_d, (int)((TileEntity)this).field_145849_e, (int)i))[0], nArray[1], nArray[2])))) continue;
            LinkedList<ItemStack> linkedList = new LinkedList<ItemStack>();
            for (Object object : this.stuffedItems) {
                object = object == null || object.func_77973_b() == null ? null : InventoryHelper.addToInsertion((Object)tileEntity, (int)i, (ItemStack)object);
                if (object == null) continue;
                linkedList.add((ItemStack)object);
            }
            this.stuffedItems = linkedList;
        }
    }

    public void updateFakePlayer() {
        if (this.needsWorld) {
            this.myFakePlayer = new CoFHFakePlayer((WorldServer)((TileEntity)this).field_145850_b);
            this.needsWorld = false;
        }
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiBreaker(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerTEBase(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        NBTTagList nBTTagList = nBTTagCompound.func_150295_c("StuffedInv", 10);
        this.stuffedItems.clear();
        for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
            NBTTagCompound nBTTagCompound2 = nBTTagList.func_150305_b(i);
            this.stuffedItems.add(ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound2));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        NBTTagList nBTTagList = new NBTTagList();
        nBTTagList = new NBTTagList();
        for (int i = 0; i < this.stuffedItems.size(); ++i) {
            if (this.stuffedItems.get(i) == null) continue;
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            this.stuffedItems.get(i).func_77955_b(nBTTagCompound2);
            nBTTagList.func_74742_a((NBTBase)nBTTagCompound2);
        }
        nBTTagCompound.func_74782_a("StuffedInv", (NBTBase)nBTTagList);
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return TEProps.EMPTY_TANK_INFO;
    }

    @Override
    public boolean allowYAxisFacing() {
        return true;
    }

    @Override
    public boolean setFacing(int n) {
        if (n < 0 || n > 5) {
            return false;
        }
        this.facing = (byte)n;
        this.sideCache[this.facing] = 0;
        this.sideCache[this.facing ^ 1] = 1;
        this.func_70296_d();
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    @Override
    public IIcon getTexture(int n, int n2) {
        if (n2 == 0) {
            return n != this.facing ? IconRegistry.getIcon((String)"DeviceSide") : (this.redstoneControlOrDisable() ? IconRegistry.getIcon((String)"DeviceActive", (int)this.getType()) : IconRegistry.getIcon((String)"DeviceFace", (int)this.getType()));
        }
        if (n < 6) {
            return IconRegistry.getIcon((String)TEProps.textureSelection, (int)this.sideConfig.sideTex[this.sideCache[n]]);
        }
        return IconRegistry.getIcon((String)"DeviceSide");
    }
}

