/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.device;

import cofh.render.IconRegistry;
import cofh.render.RenderHelper;
import cofh.util.FluidHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileAugmentable;
import thermalexpansion.block.TileTEBase;
import thermalexpansion.block.device.BlockDevice;
import thermalexpansion.core.TEProps;
import thermalexpansion.gui.client.device.GuiNullifier;
import thermalexpansion.gui.container.device.ContainerNullifier;

public class TileNullifier
extends TileAugmentable
implements IFluidHandler {
    static final int TYPE = BlockDevice.Types.NULLIFIER.ordinal();
    static TileTEBase.SideConfig defaultSideConfig = new TileTEBase.SideConfig();
    public static boolean enableSecurity = true;
    protected static final int[] SLOTS = new int[]{0};
    protected static final Fluid renderFluid = FluidRegistry.LAVA;

    public static void initialize() {
        defaultSideConfig = new TileTEBase.SideConfig();
        TileNullifier.defaultSideConfig.numGroup = 2;
        TileNullifier.defaultSideConfig.slotGroups = new int[][]{new int[0], new int[0], new int[0]};
        TileNullifier.defaultSideConfig.allowInsertion = new boolean[]{false, false, false};
        TileNullifier.defaultSideConfig.allowExtraction = new boolean[]{false, false, false};
        TileNullifier.defaultSideConfig.sideTex = new int[]{0, 1, 4};
        TileNullifier.defaultSideConfig.defaultSides = new byte[]{0, 0, 0, 0, 0, 0};
        GameRegistry.registerTileEntity(TileNullifier.class, (String)"thermalexpansion.Nullifier");
        TileNullifier.configure();
    }

    public static void configure() {
        String string = "Enable this to allow for Nullifiers to be securable. (Default: true)";
        enableSecurity = ThermalExpansion.config.get("security", "Device.Nullifier.Securable", enableSecurity, string);
    }

    public TileNullifier() {
        this.sideConfig = defaultSideConfig;
        this.inventory = new ItemStack[1];
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public void setDefaultSides() {
        this.sideCache = this.getDefaultSides();
        this.sideCache[this.facing] = 1;
    }

    public String getName() {
        return "tile.thermalexpansion.device." + BlockDevice.NAMES[this.getType()] + ".name";
    }

    public int getType() {
        return TYPE;
    }

    public int getLightValue() {
        return FluidHelper.getFluidLuminosity((Fluid)renderFluid);
    }

    @Override
    public boolean enableSecurity() {
        return enableSecurity;
    }

    @Override
    public boolean sendRedstoneUpdates() {
        return true;
    }

    protected boolean isSideAccessible(int n) {
        return this.sideCache[n] == 1 && this.redstoneControlOrDisable();
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiNullifier(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerNullifier(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public void readInventoryFromNBT(NBTTagCompound nBTTagCompound) {
    }

    @Override
    public void writeInventoryToNBT(NBTTagCompound nBTTagCompound) {
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return this.isSideAccessible(forgeDirection.ordinal()) ? fluidStack.amount : 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return null;
    }

    @Override
    public ItemStack func_70301_a(int n) {
        return this.inventory[n];
    }

    @Override
    public ItemStack func_70298_a(int n, int n2) {
        if (this.inventory[n] == null) {
            return null;
        }
        if (this.inventory[n].field_77994_a <= n2) {
            n2 = this.inventory[n].field_77994_a;
        }
        ItemStack itemStack = this.inventory[n].func_77979_a(n2);
        if (this.inventory[n].field_77994_a <= 0) {
            this.inventory[n] = null;
        }
        return itemStack;
    }

    @Override
    public ItemStack func_70304_b(int n) {
        if (this.inventory[n] == null) {
            return null;
        }
        ItemStack itemStack = this.inventory[n];
        this.inventory[n] = null;
        return itemStack;
    }

    @Override
    public void func_70299_a(int n, ItemStack itemStack) {
        if (n == 0) {
            return;
        }
        this.inventory[n] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    @Override
    public boolean allowYAxisFacing() {
        return true;
    }

    @Override
    public boolean setFacing(int n) {
        if (n < 0 || n > 5) {
            return false;
        }
        this.facing = (byte)n;
        this.sideCache[this.facing] = 1;
        this.func_70296_d();
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    @Override
    public int getNumConfig(int n) {
        return 2;
    }

    @Override
    public IIcon getTexture(int n, int n2) {
        if (n2 == 0) {
            return n != this.facing ? IconRegistry.getIcon((String)"DeviceSide") : (this.redstoneControlOrDisable() ? RenderHelper.getFluidTexture((Fluid)renderFluid) : IconRegistry.getIcon((String)"DeviceFace", (int)this.getType()));
        }
        if (n < 6) {
            return n != this.facing ? IconRegistry.getIcon((String)TEProps.textureSelection, (int)this.sideConfig.sideTex[this.sideCache[n]]) : (this.redstoneControlOrDisable() ? IconRegistry.getIcon((String)"DeviceActive", (int)this.getType()) : IconRegistry.getIcon((String)"DeviceFace", (int)this.getType()));
        }
        return IconRegistry.getIcon((String)"DeviceSide");
    }

    @Override
    public int[] func_94128_d(int n) {
        return this.isSideAccessible(n) ? SLOTS : TEProps.EMPTY_INVENTORY;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return this.isSideAccessible(n2);
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return false;
    }
}

