/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.device;

import cofh.api.energy.EnergyStorage;
import cofh.util.ServerHelper;
import cofh.util.fluid.FluidTankAdv;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.block.TileReconfigurable;
import thermalexpansion.block.device.BlockDevice;
import thermalexpansion.gui.client.machine.GuiTransposer;
import thermalexpansion.gui.container.machine.ContainerTransposer;

public class TilePump
extends TileReconfigurable
implements IFluidHandler {
    int outputTracker;
    FluidTankAdv tank = new FluidTankAdv(10000);
    public boolean reverse;

    public static void initialize() {
    }

    public TilePump() {
        this.sideCache = new byte[]{0, 0, 1, 1, 1, 1};
        this.energyStorage = new EnergyStorage(0);
    }

    public String getName() {
        return "tile.thermalexpansion.device." + BlockDevice.NAMES[this.getType()] + ".name";
    }

    public int getType() {
        return BlockDevice.Types.PUMP.ordinal();
    }

    public void func_145845_h() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public void func_145829_t() {
        super.func_145829_t();
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiTransposer(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerTransposer(inventoryPlayer, (TileEntity)this);
    }

    public FluidTankAdv getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.outputTracker = nBTTagCompound.func_74762_e("Tracker2");
        this.reverse = nBTTagCompound.func_74767_n("Rev");
        this.tank.readFromNBT(nBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("Tracker", this.outputTracker);
        nBTTagCompound.func_74757_a("Rev", this.reverse);
        this.tank.writeToNBT(nBTTagCompound);
    }

    @Override
    public int getNumConfig(int n) {
        return 3;
    }

    @Override
    public IIcon getTexture(int n, int n2) {
        return null;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (!this.reverse || forgeDirection == ForgeDirection.UNKNOWN || this.sideCache[forgeDirection.ordinal()] != 1) {
            return 0;
        }
        return this.tank.fill(fluidStack, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (this.reverse || forgeDirection == ForgeDirection.UNKNOWN || this.sideCache[forgeDirection.ordinal()] != 2) {
            return null;
        }
        return this.tank.drain(fluidStack, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        if (this.reverse || forgeDirection == ForgeDirection.UNKNOWN || this.sideCache[forgeDirection.ordinal()] != 2) {
            return null;
        }
        return this.tank.drain(n, bl);
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        if (forgeDirection == ForgeDirection.UNKNOWN) {
            return false;
        }
        return !this.reverse && this.sideCache[forgeDirection.ordinal()] == 1;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        if (forgeDirection == ForgeDirection.UNKNOWN) {
            return false;
        }
        return this.reverse && this.sideCache[forgeDirection.ordinal()] == 2;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }
}

