/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.device;

import cofh.api.core.ICustomInventory;
import cofh.api.inventory.IInventoryRetainer;
import cofh.api.tileentity.ISecurable;
import cofh.api.tileentity.ISidedTexture;
import cofh.network.PacketBase;
import cofh.network.PacketCoFHBase;
import cofh.network.PacketHandler;
import cofh.network.PacketTileInfo;
import cofh.render.IconRegistry;
import cofh.util.InventoryHelper;
import cofh.util.ItemHelper;
import cofh.util.oredict.OreDictionaryArbiter;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileInventory;
import thermalexpansion.block.device.BlockDevice;
import thermalexpansion.core.TEProps;
import thermalexpansion.gui.client.device.GuiWorkbench;
import thermalexpansion.gui.container.device.ContainerWorkbench;
import thermalexpansion.util.SchematicHelper;

public class TileWorkbench
extends TileInventory
implements ICustomInventory,
ISidedInventory,
ISidedTexture,
IInventoryRetainer {
    public static boolean enableSecurity = true;
    public int selectedSchematic = 0;
    public boolean[] missingItem = new boolean[]{false, false, false, false, false, false, false, false, false};
    public ItemStack[] craftingGrid = new ItemStack[9];

    public static void initialize() {
        GameRegistry.registerTileEntity(TileWorkbench.class, (String)"thermalexpansion.Workbench");
        TileWorkbench.configure();
    }

    public static void configure() {
        String string = "Enable this to allow for Workbenches to be securable. (Default: true)";
        enableSecurity = ThermalExpansion.config.get("security", "Device.Workbench.Securable", enableSecurity, string);
    }

    public TileWorkbench() {
        this.inventory = new ItemStack[21];
    }

    public String getName() {
        return "tile.thermalexpansion.device." + BlockDevice.NAMES[this.getType()] + ".name";
    }

    public int getType() {
        return BlockDevice.Types.WORKBENCH.ordinal();
    }

    public int getCurrentSchematicSlot() {
        return this.selectedSchematic;
    }

    public boolean canUpdate() {
        return false;
    }

    public boolean createItem(boolean bl, ItemStack itemStack) {
        ItemStack[] itemStackArray = InventoryHelper.cloneInventory((ItemStack[])this.inventory);
        boolean bl2 = false;
        for (int i = 0; i < 9; ++i) {
            ItemStack itemStack2 = this.craftingGrid[i];
            String string = OreDictionaryArbiter.getOreName((ItemStack)itemStack2);
            if (itemStack2 == null) continue;
            for (int j = 0; j < this.func_70302_i_(); ++j) {
                ItemStack itemStack3;
                if (itemStackArray[j] == null || !ItemHelper.craftingEquivalent((ItemStack)itemStackArray[j], (ItemStack)itemStack2, (String)string, (ItemStack)itemStack)) continue;
                this.craftingGrid[i] = ItemHelper.cloneStack((ItemStack)itemStackArray[j], (int)1);
                --itemStackArray[j].field_77994_a;
                if (itemStackArray[j].func_77973_b().hasContainerItem(itemStackArray[j]) && (itemStack3 = itemStackArray[j].func_77973_b().getContainerItem(itemStackArray[j])) != null) {
                    if (itemStack3.func_77984_f() && itemStack3.func_77960_j() > itemStack3.func_77958_k()) {
                        itemStack3 = null;
                    }
                    if (!(itemStack3 == null || itemStackArray[j].func_77973_b().func_77630_h(itemStackArray[j]) && InventoryHelper.addItemStackToInventory((ItemStack[])itemStackArray, (ItemStack)itemStack3, (int)3))) {
                        if (itemStackArray[j].field_77994_a <= 0) {
                            itemStackArray[j] = itemStack3;
                            if (itemStack3.field_77994_a <= 0) {
                                itemStackArray[j].field_77994_a = 1;
                            }
                        } else {
                            return false;
                        }
                    }
                }
                if (itemStackArray[j].field_77994_a <= 0) {
                    itemStackArray[j] = null;
                }
                bl2 = true;
                break;
            }
            if (!bl2) {
                return false;
            }
            bl2 = false;
        }
        if (bl) {
            this.inventory = itemStackArray;
        }
        return true;
    }

    public boolean createItemClient(boolean bl, ItemStack itemStack) {
        ItemStack[] itemStackArray = InventoryHelper.cloneInventory((ItemStack[])this.inventory);
        boolean bl2 = false;
        boolean bl3 = true;
        this.missingItem = new boolean[]{false, false, false, false, false, false, false, false, false};
        for (int i = 0; i < 9; ++i) {
            ItemStack itemStack2 = this.craftingGrid[i];
            String string = OreDictionaryArbiter.getOreName((ItemStack)itemStack2);
            if (itemStack2 == null) continue;
            for (int j = 0; j < this.func_70302_i_(); ++j) {
                if (itemStackArray[j] == null || !ItemHelper.craftingEquivalent((ItemStack)itemStackArray[j], (ItemStack)itemStack2, (String)string, (ItemStack)itemStack)) continue;
                this.craftingGrid[i] = ItemHelper.cloneStack((ItemStack)itemStackArray[j], (int)1);
                --itemStackArray[j].field_77994_a;
                if (itemStackArray[j].func_77973_b().hasContainerItem(itemStackArray[j])) {
                    ItemStack itemStack3 = itemStackArray[j].func_77973_b().getContainerItem(itemStackArray[j]);
                    if (itemStack3.func_77984_f() && itemStack3.func_77960_j() > itemStack3.func_77958_k()) {
                        itemStack3 = null;
                    }
                    if (!(itemStack3 == null || itemStackArray[j].func_77973_b().func_77630_h(itemStackArray[j]) && InventoryHelper.addItemStackToInventory((ItemStack[])itemStackArray, (ItemStack)itemStack3, (int)2))) {
                        if (itemStackArray[j].field_77994_a <= 0) {
                            itemStackArray[j] = itemStack3;
                            if (itemStack3.field_77994_a <= 0) {
                                itemStackArray[j].field_77994_a = 1;
                            }
                        } else {
                            return false;
                        }
                    }
                }
                if (itemStackArray[j].field_77994_a <= 0) {
                    itemStackArray[j] = null;
                }
                bl2 = true;
                break;
            }
            if (!bl2) {
                bl3 = false;
                this.missingItem[i] = true;
            }
            bl2 = false;
        }
        if (!bl3) {
            return false;
        }
        if (bl) {
            this.inventory = itemStackArray;
        }
        return true;
    }

    @Override
    public boolean enableSecurity() {
        return enableSecurity;
    }

    public void clearCraftingGrid() {
        for (int i = 0; i < 9; ++i) {
            this.craftingGrid[i] = null;
        }
        PacketHandler.sendToServer((PacketBase)PacketTileInfo.newPacket((TileEntity)this).addByte(PacketInfoID.CLEAR_GRID.ordinal()));
    }

    public void setCraftingGrid() {
        for (int i = 0; i < 9; ++i) {
            this.craftingGrid[i] = SchematicHelper.getSchematicSlot(this.func_70301_a(this.getCurrentSchematicSlot()), i);
        }
        PacketHandler.sendToServer((PacketBase)PacketTileInfo.newPacket((TileEntity)this).addByte(PacketInfoID.SET_GRID.ordinal()));
    }

    public void setCurrentSchematicSlot(int n) {
        this.selectedSchematic = n;
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addByte((byte)this.access.ordinal());
        packetCoFHBase.addByte(this.selectedSchematic);
        packetCoFHBase.addString(this.owner);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        return null;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        this.access = ISecurable.AccessMode.values()[packetCoFHBase.getByte()];
        this.selectedSchematic = packetCoFHBase.getByte();
        if (!bl) {
            this.owner = packetCoFHBase.getString();
        } else {
            packetCoFHBase.getString();
        }
    }

    @Override
    public void handleTileInfoPacket(PacketCoFHBase packetCoFHBase, boolean bl, EntityPlayer entityPlayer) {
        byte by = packetCoFHBase.getByte();
        if (by == PacketInfoID.CLEAR_GRID.ordinal()) {
            for (int i = 0; i < 9; ++i) {
                this.craftingGrid[i] = null;
                if (entityPlayer.field_71070_bA == null) continue;
                entityPlayer.field_71070_bA.func_75130_a(null);
            }
        } else if (by == PacketInfoID.SET_GRID.ordinal()) {
            for (int i = 0; i < 9; ++i) {
                this.craftingGrid[i] = SchematicHelper.getSchematicSlot(this.func_70301_a(this.getCurrentSchematicSlot()), i);
                if (entityPlayer.field_71070_bA == null) continue;
                entityPlayer.field_71070_bA.func_75130_a(null);
            }
        } else if (by == PacketInfoID.NEI_SUP.ordinal()) {
            byte by2;
            for (int i = 0; i < 9; ++i) {
                this.craftingGrid[i] = null;
            }
            while ((by2 = packetCoFHBase.getByte()) >= 0) {
                this.craftingGrid[by2] = packetCoFHBase.getItemStack();
            }
            Container container = entityPlayer.field_71070_bA;
            if (container != null) {
                ((ICrafting)entityPlayer).func_71110_a(container, container.func_75138_a());
                container.func_75130_a(null);
            }
        }
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiWorkbench(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerWorkbench(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.canPlayerAccess(((EntityPlayer)iCrafting).getDisplayName()) ? 1 : 0);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.readCraftingFromNBT(nBTTagCompound);
        this.selectedSchematic = nBTTagCompound.func_74771_c("Mode");
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        this.writeCraftingToNBT(nBTTagCompound);
        nBTTagCompound.func_74774_a("Mode", (byte)this.selectedSchematic);
    }

    public void readCraftingFromNBT(NBTTagCompound nBTTagCompound) {
        NBTTagList nBTTagList = nBTTagCompound.func_150295_c("Crafting", 10);
        this.craftingGrid = new ItemStack[9];
        for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
            NBTTagCompound nBTTagCompound2 = nBTTagList.func_150305_b(i);
            int n = nBTTagCompound2.func_74762_e("Slot");
            if (n < 0 || n >= this.craftingGrid.length) continue;
            this.craftingGrid[n] = ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound2);
        }
    }

    public void writeCraftingToNBT(NBTTagCompound nBTTagCompound) {
        NBTTagList nBTTagList = new NBTTagList();
        for (int i = 0; i < this.craftingGrid.length; ++i) {
            if (this.craftingGrid[i] == null) continue;
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound2.func_74768_a("Slot", i);
            this.craftingGrid[i].func_77955_b(nBTTagCompound2);
            nBTTagList.func_74742_a((NBTBase)nBTTagCompound2);
        }
        nBTTagCompound.func_74782_a("Crafting", (NBTBase)nBTTagList);
    }

    public ItemStack[] getInventorySlots(int n) {
        return this.craftingGrid;
    }

    public int getSlotStackLimit(int n) {
        return 1;
    }

    public void onSlotUpdate() {
        this.func_70296_d();
    }

    public int[] func_94128_d(int n) {
        return TEProps.EMPTY_INVENTORY;
    }

    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return false;
    }

    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return false;
    }

    public IIcon getTexture(int n, int n2) {
        if (n == 0) {
            return IconRegistry.getIcon((String)"WorkbenchBottom");
        }
        if (n == 1) {
            return IconRegistry.getIcon((String)"WorkbenchTop");
        }
        return IconRegistry.getIcon((String)"WorkbenchSide");
    }

    public static enum PacketInfoID {
        CLEAR_GRID,
        SET_GRID,
        NEI_SUP;

    }
}

