/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.dynamo;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cofh.api.item.IAugmentItem;
import cofh.api.tileentity.IAugmentable;
import cofh.api.tileentity.IEnergyInfo;
import cofh.api.tileentity.IReconfigurableFacing;
import cofh.api.tileentity.IRedstoneControl;
import cofh.network.ITileInfoPacketHandler;
import cofh.network.PacketCoFHBase;
import cofh.util.BlockHelper;
import cofh.util.CoreUtils;
import cofh.util.EnergyHelper;
import cofh.util.RedstoneControlHelper;
import cofh.util.ServerHelper;
import cofh.util.fluid.FluidTankAdv;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileRSControl;
import thermalexpansion.block.TileTEBase;
import thermalexpansion.block.dynamo.BlockDynamo;
import thermalexpansion.core.TEProps;
import thermalexpansion.item.TEAugments;
import thermalexpansion.util.Utils;

public abstract class TileDynamoBase
extends TileRSControl
implements ITileInfoPacketHandler,
IAugmentable,
IEnergyInfo,
IReconfigurableFacing,
ISidedInventory {
    public static boolean enableSecurity = true;
    protected static final TileTEBase.EnergyConfig[] defaultEnergyConfig = new TileTEBase.EnergyConfig[BlockDynamo.Types.values().length];
    protected static final int MAX_FLUID = 4000;
    protected static final int[] SLOTS = new int[]{0};
    public static final int FUEL_MOD = 1000;
    int compareTracker;
    int fuelRF;
    byte facing = 1;
    boolean cached = false;
    IEnergyHandler adjacentHandler = null;
    TileTEBase.EnergyConfig config;
    ItemStack[] augments = new ItemStack[4];
    boolean[] augmentStatus = new boolean[4];
    int energyMod = 1;
    int fuelMod = 1000;
    public boolean augmentRedstoneControl;
    public boolean augmentThrottle;
    public boolean augmentCoilDuct;

    public static void configure() {
        String string = "Enable this to allow for Dynamos to be securable. (Default: true)";
        enableSecurity = ThermalExpansion.config.get("security", "Dynamo.All.Securable", enableSecurity, string);
    }

    public TileDynamoBase() {
        this.config = defaultEnergyConfig[this.getType()];
        this.energyStorage = new EnergyStorage(this.config.maxEnergy, this.config.maxPower * 2);
    }

    public String getName() {
        return "tile.thermalexpansion.dynamo." + BlockDynamo.NAMES[this.getType()] + ".name";
    }

    public int getComparatorInput(int n) {
        return this.compareTracker;
    }

    public int getLightValue() {
        return this.isActive ? 7 : 0;
    }

    @Override
    public boolean enableSecurity() {
        return enableSecurity;
    }

    public boolean onWrench(EntityPlayer entityPlayer, int n) {
        this.rotateBlock();
        return true;
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.updateAdjacentHandlers();
    }

    public void onNeighborTileChange(int n, int n2, int n3) {
        super.onNeighborTileChange(n, n2, n3);
        this.updateAdjacentHandlers();
    }

    public void func_145845_h() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        if (!this.cached) {
            this.onNeighborBlockChange();
        }
        boolean bl = this.isActive;
        if (this.redstoneControlOrDisable()) {
            int n;
            if (this.isActive) {
                if (this.canGenerate()) {
                    this.generate();
                    this.transferEnergy(this.facing);
                } else {
                    this.isActive = false;
                }
            } else if (this.canGenerate()) {
                this.isActive = true;
                this.generate();
                this.transferEnergy(this.facing);
            } else {
                this.attenuate();
            }
            if (this.timeCheck() && (n = this.getScaledEnergyStored(15)) != this.compareTracker) {
                this.compareTracker = n;
                this.callNeighborTileChange();
            }
        } else {
            this.isActive = false;
            this.attenuate();
        }
        if (bl != this.isActive) {
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    public void func_145843_s() {
        this.cached = false;
        super.func_145843_s();
    }

    protected abstract boolean canGenerate();

    protected abstract void generate();

    protected int calcEnergy() {
        if (!this.isActive) {
            return 0;
        }
        if (this.energyStorage.getEnergyStored() < this.config.minPowerLevel) {
            return this.config.maxPower;
        }
        if (this.energyStorage.getEnergyStored() > this.config.maxPowerLevel) {
            return this.config.minPower;
        }
        return (this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored()) / this.config.energyRamp;
    }

    protected int calcEnergy2() {
        if (!this.isActive || this.energyStorage.getEnergyStored() == this.energyStorage.getMaxEnergyStored()) {
            return 0;
        }
        if (this.energyStorage.getEnergyStored() < this.config.maxPowerLevel) {
            return this.config.maxPower;
        }
        if (this.energyStorage.getEnergyStored() > this.config.minPowerLevel) {
            return this.config.minPower;
        }
        return (this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored()) / this.config.energyRamp;
    }

    protected boolean hasStoredEnergy() {
        return this.energyStorage.getEnergyStored() > 0;
    }

    protected void attenuate() {
        if (this.timeCheck() && this.fuelRF > 0) {
            this.fuelRF -= 10;
            if (this.fuelRF < 0) {
                this.fuelRF = 0;
            }
        }
    }

    protected void transferEnergy(int n) {
        if (this.adjacentHandler == null) {
            return;
        }
        this.energyStorage.modifyEnergyStored(-this.adjacentHandler.receiveEnergy(ForgeDirection.VALID_DIRECTIONS[n ^ 1], Math.min(this.config.maxPower * 2, this.energyStorage.getEnergyStored()), false));
    }

    protected void updateAdjacentHandlers() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        TileEntity tileEntity = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)this.facing);
        this.adjacentHandler = EnergyHelper.isEnergyHandlerFromSide((TileEntity)tileEntity, (ForgeDirection)ForgeDirection.VALID_DIRECTIONS[this.facing ^ 1]) ? (IEnergyHandler)tileEntity : null;
        this.cached = true;
    }

    public IIcon getActiveIcon() {
        return FluidRegistry.WATER.getIcon();
    }

    public FluidTankAdv getTank(int n) {
        return null;
    }

    public int getScaledDuration(int n) {
        return 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.readAugmentsFromNBT(nBTTagCompound);
        this.installAugments();
        this.energyStorage.readFromNBT(nBTTagCompound);
        this.facing = nBTTagCompound.func_74771_c("Facing");
        this.isActive = nBTTagCompound.func_74767_n("Active");
        this.fuelRF = nBTTagCompound.func_74762_e("Fuel");
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        this.writeAugmentsToNBT(nBTTagCompound);
        nBTTagCompound.func_74774_a("Facing", this.facing);
        nBTTagCompound.func_74757_a("Active", this.isActive);
        nBTTagCompound.func_74768_a("Fuel", this.fuelRF);
    }

    public void readAugmentsFromNBT(NBTTagCompound nBTTagCompound) {
        NBTTagList nBTTagList = nBTTagCompound.func_150295_c("Augments", 10);
        for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
            NBTTagCompound nBTTagCompound2 = nBTTagList.func_150305_b(i);
            int n = nBTTagCompound2.func_74762_e("Slot");
            if (n < 0 || n >= this.augments.length) continue;
            this.augments[n] = ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound2);
        }
    }

    public void writeAugmentsToNBT(NBTTagCompound nBTTagCompound) {
        if (this.augments.length <= 0) {
            return;
        }
        NBTTagList nBTTagList = new NBTTagList();
        for (int i = 0; i < this.augments.length; ++i) {
            if (this.augments[i] == null) continue;
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound2.func_74768_a("Slot", i);
            this.augments[i].func_77955_b(nBTTagCompound2);
            nBTTagList.func_74742_a((NBTBase)nBTTagCompound2);
        }
        nBTTagCompound.func_74782_a("Augments", (NBTBase)nBTTagList);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addByte(this.facing);
        packetCoFHBase.addBool(this.augmentRedstoneControl);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        packetCoFHBase.addInt(this.energyStorage.getMaxEnergyStored());
        packetCoFHBase.addInt(this.energyStorage.getEnergyStored());
        packetCoFHBase.addInt(this.fuelRF);
        packetCoFHBase.addBool(this.augmentRedstoneControl);
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.energyStorage.setCapacity(packetCoFHBase.getInt());
        this.energyStorage.setEnergyStored(packetCoFHBase.getInt());
        this.fuelRF = packetCoFHBase.getInt();
        boolean bl = this.augmentRedstoneControl;
        this.augmentRedstoneControl = packetCoFHBase.getBool();
        if (this.augmentRedstoneControl != bl) {
            this.onInstalled();
            this.sendUpdatePacket(Side.SERVER);
        }
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        if (!bl) {
            this.facing = packetCoFHBase.getByte();
            this.augmentRedstoneControl = packetCoFHBase.getBool();
        } else {
            packetCoFHBase.getByte();
            packetCoFHBase.getBool();
        }
    }

    public ItemStack[] getAugmentSlots() {
        return this.augments;
    }

    public boolean[] getAugmentStatus() {
        return this.augmentStatus;
    }

    public void installAugments() {
        this.resetAugments();
        for (int i = 0; i < this.augments.length; ++i) {
            this.augmentStatus[i] = false;
            if (!Utils.isAugmentItem(this.augments[i])) continue;
            this.augmentStatus[i] = this.installAugment(i);
        }
        if (CoreUtils.isServer()) {
            this.onInstalled();
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    protected boolean hasAugment(String string, int n) {
        for (int i = 0; i < this.augments.length; ++i) {
            if (!Utils.isAugmentItem(this.augments[i]) || ((IAugmentItem)this.augments[i].func_77973_b()).getAugmentLevel(this.augments[i], string) != n) continue;
            return true;
        }
        return false;
    }

    protected boolean hasDuplicateAugment(String string, int n, int n2) {
        for (int i = 0; i < this.augments.length; ++i) {
            if (i == n2 || !Utils.isAugmentItem(this.augments[i]) || ((IAugmentItem)this.augments[i].func_77973_b()).getAugmentLevel(this.augments[i], string) != n) continue;
            return true;
        }
        return false;
    }

    protected boolean hasAugmentChain(String string, int n) {
        boolean bl = true;
        for (int i = 1; i < n; ++i) {
            bl = bl && this.hasAugment(string, i);
        }
        return bl;
    }

    protected boolean installAugment(int n) {
        int n2;
        IAugmentItem iAugmentItem = (IAugmentItem)this.augments[n].func_77973_b();
        boolean bl = false;
        if (iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.DYNAMO_EFFICIENCY) > 0) {
            if (iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.DYNAMO_OUTPUT) > 0) {
                return false;
            }
            n2 = Math.min(TEAugments.NUM_DYNAMO_EFFICIENCY, iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.DYNAMO_EFFICIENCY));
            if (this.hasDuplicateAugment(TEAugments.DYNAMO_EFFICIENCY, n2, n)) {
                return false;
            }
            if (this.hasAugmentChain(TEAugments.DYNAMO_EFFICIENCY, n2)) {
                this.fuelMod += TEAugments.DYNAMO_EFFICIENCY_MOD[n2];
                bl = true;
            } else {
                return false;
            }
        }
        if (iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.DYNAMO_OUTPUT) > 0) {
            n2 = iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.DYNAMO_OUTPUT);
            if (this.hasDuplicateAugment(TEAugments.DYNAMO_OUTPUT, n2, n)) {
                return false;
            }
            if (this.hasAugmentChain(TEAugments.DYNAMO_OUTPUT, n2)) {
                this.energyMod = Math.max(this.energyMod, TEAugments.DYNAMO_OUTPUT_MOD[n2]);
                this.energyStorage.setMaxTransfer(Math.max(this.energyStorage.getMaxExtract(), this.config.maxPower * 2 * TEAugments.DYNAMO_OUTPUT_MOD[n2]));
                this.fuelMod -= 350 - 100 * n2;
                bl = true;
            } else {
                return false;
            }
        }
        if (iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.DYNAMO_COIL_DUCT) > 0) {
            this.augmentCoilDuct = true;
            bl = true;
        }
        if (iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.DYNAMO_THROTTLE) > 0) {
            if (this.hasAugment(TEAugments.GENERAL_REDSTONE_CONTROL, 0)) {
                this.augmentThrottle = true;
                bl = true;
            } else {
                return false;
            }
        }
        if (iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.ENDER_ENERGY) > 0) {
            // empty if block
        }
        if (iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.GENERAL_REDSTONE_CONTROL) > 0) {
            this.augmentRedstoneControl = true;
            bl = true;
        }
        return bl;
    }

    protected void onInstalled() {
        if (!this.augmentRedstoneControl) {
            this.rsMode = IRedstoneControl.ControlMode.DISABLED;
        }
    }

    protected void resetAugments() {
        this.energyMod = 1;
        this.fuelMod = 1000;
        this.augmentRedstoneControl = false;
        this.augmentThrottle = false;
    }

    @Override
    public int receiveEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection forgeDirection) {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection forgeDirection) {
        return this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection forgeDirection) {
        return forgeDirection.ordinal() == this.facing;
    }

    public int getInfoEnergyPerTick() {
        return this.calcEnergy() * this.energyMod;
    }

    public int getInfoMaxEnergyPerTick() {
        return this.config.maxPower * this.energyMod;
    }

    public int getInfoEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getInfoMaxEnergyStored() {
        return this.config.maxEnergy;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return this.augmentCoilDuct || forgeDirection.ordinal() != this.facing;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return this.augmentCoilDuct || forgeDirection.ordinal() != this.facing;
    }

    @Override
    public String getDataType() {
        return "tile.thermalexpansion.dynamo";
    }

    @Override
    public void readPortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        if (!this.canPlayerAccess(entityPlayer.func_70005_c_())) {
            return;
        }
        if (this.augmentRedstoneControl) {
            RedstoneControlHelper.getControlFromNBT((NBTTagCompound)nBTTagCompound);
        }
    }

    @Override
    public void writePortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        if (!this.canPlayerAccess(entityPlayer.func_70005_c_())) {
            return;
        }
        RedstoneControlHelper.setItemStackTagRS((NBTTagCompound)nBTTagCompound, (IRedstoneControl)this);
    }

    public int getFacing() {
        return this.facing;
    }

    public boolean allowYAxisFacing() {
        return true;
    }

    public boolean rotateBlock() {
        for (int i = this.facing + 1; i < this.facing + 6; ++i) {
            if (!EnergyHelper.isAdjacentEnergyHandlerFromSide((TileEntity)this, (int)(i % 6))) continue;
            this.facing = (byte)(i % 6);
            this.updateAdjacentHandlers();
            this.func_70296_d();
            this.sendUpdatePacket(Side.CLIENT);
            return true;
        }
        return false;
    }

    public boolean setFacing(int n) {
        return false;
    }

    public int[] func_94128_d(int n) {
        return TEProps.EMPTY_INVENTORY;
    }

    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return this.augmentCoilDuct || n2 != this.facing;
    }

    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return this.augmentCoilDuct;
    }
}

