/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.dynamo;

import cofh.api.energy.IEnergyContainerItem;
import cofh.network.PacketCoFHBase;
import cofh.util.EnergyHelper;
import cofh.util.ItemHelper;
import cofh.util.MathHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileTEBase;
import thermalexpansion.block.dynamo.BlockDynamo;
import thermalexpansion.block.dynamo.TileDynamoBase;
import thermalexpansion.core.TEProps;
import thermalexpansion.gui.client.dynamo.GuiDynamoEnervation;
import thermalexpansion.gui.container.dynamo.ContainerDynamoEnervation;
import thermalexpansion.util.FuelHandler;
import thermalfoundation.fluid.TFFluids;

public class TileDynamoEnervation
extends TileDynamoBase {
    static final int TYPE = BlockDynamo.Types.ENERVATION.ordinal();
    static int redstoneRF = 64000;
    static int blockRedstoneRF = redstoneRF * 10;
    static ItemStack redstone = new ItemStack(Items.field_151137_ax);
    static ItemStack blockRedstone = new ItemStack(Blocks.field_150451_bX);
    int currentFuelRF = TileDynamoEnervation.getEnergyValue(redstone);

    public static void initialize() {
        int n = MathHelper.clampI((int)ThermalExpansion.config.get("block.tweak", "Dynamo.Enervation.BasePower", 80), (int)10, (int)160);
        ThermalExpansion.config.set("block.tweak", "Dynamo.Enervation.BasePower", n);
        n /= 10;
        TileDynamoBase.defaultEnergyConfig[TileDynamoEnervation.TYPE] = new TileTEBase.EnergyConfig();
        TileDynamoBase.defaultEnergyConfig[TYPE].setParamsDefault(n *= 10);
        GameRegistry.registerTileEntity(TileDynamoEnervation.class, (String)"thermalexpansion.DynamoEnervation");
    }

    public static int getEnergyValue(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        if (itemStack.func_77969_a(redstone)) {
            return redstoneRF;
        }
        if (itemStack.func_77969_a(blockRedstone)) {
            return blockRedstoneRF;
        }
        if (EnergyHelper.isEnergyContainerItem((ItemStack)itemStack)) {
            IEnergyContainerItem iEnergyContainerItem = (IEnergyContainerItem)itemStack.func_77973_b();
            return iEnergyContainerItem.extractEnergy(itemStack, iEnergyContainerItem.getEnergyStored(itemStack), true);
        }
        return 0;
    }

    public TileDynamoEnervation() {
        this.inventory = new ItemStack[1];
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected boolean canGenerate() {
        if (this.fuelRF > 0) {
            return true;
        }
        return TileDynamoEnervation.getEnergyValue(this.inventory[0]) >= this.config.maxPower;
    }

    @Override
    protected void generate() {
        int n;
        if (this.fuelRF <= 0) {
            if (EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[0])) {
                IEnergyContainerItem iEnergyContainerItem = (IEnergyContainerItem)this.inventory[0].func_77973_b();
                this.fuelRF += iEnergyContainerItem.extractEnergy(this.inventory[0], iEnergyContainerItem.getEnergyStored(this.inventory[0]), false);
                this.currentFuelRF = redstoneRF;
            } else {
                n = TileDynamoEnervation.getEnergyValue(this.inventory[0]) * this.fuelMod / 1000;
                this.fuelRF += n;
                this.currentFuelRF = n;
                this.inventory[0] = ItemHelper.consumeItem((ItemStack)this.inventory[0]);
            }
        }
        n = this.calcEnergy() * this.energyMod;
        this.energyStorage.modifyEnergyStored(n);
        this.fuelRF -= n;
    }

    @Override
    public IIcon getActiveIcon() {
        return TFFluids.fluidRedstone.getIcon();
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiDynamoEnervation(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerDynamoEnervation(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public int getScaledDuration(int n) {
        if (this.currentFuelRF <= 0) {
            this.currentFuelRF = redstoneRF;
        } else if (EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[0])) {
            return n;
        }
        return this.fuelRF * n / this.currentFuelRF;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.currentFuelRF = nBTTagCompound.func_74762_e("FuelMax");
        if (this.currentFuelRF <= 0) {
            this.currentFuelRF = redstoneRF;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("FuelMax", this.currentFuelRF);
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        packetCoFHBase.addInt(this.currentFuelRF);
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.currentFuelRF = packetCoFHBase.getInt();
    }

    @Override
    public int[] func_94128_d(int n) {
        return n != this.facing || this.augmentCoilDuct ? TileDynamoBase.SLOTS : TEProps.EMPTY_INVENTORY;
    }

    static {
        String string = "fuels.enervation";
        redstoneRF = FuelHandler.configFuels.get(string, "redstone", redstoneRF);
        blockRedstoneRF = redstoneRF * 10;
    }
}

