/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.dynamo;

import cofh.network.PacketCoFHBase;
import cofh.util.ItemHelper;
import cofh.util.MathHelper;
import cofh.util.fluid.FluidTankAdv;
import cpw.mods.fml.common.registry.GameRegistry;
import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileTEBase;
import thermalexpansion.block.dynamo.BlockDynamo;
import thermalexpansion.block.dynamo.TileDynamoBase;
import thermalexpansion.core.TEProps;
import thermalexpansion.gui.client.dynamo.GuiDynamoReactant;
import thermalexpansion.gui.container.dynamo.ContainerDynamoReactant;

public class TileDynamoReactant
extends TileDynamoBase
implements IFluidHandler {
    static final int TYPE = BlockDynamo.Types.REACTANT.ordinal();
    static int sugarRF = 16000;
    static int gunpowderRF = 160000;
    static int blazePowderRF = 640000;
    static int ghastTearRF = 1600000;
    static int netherStarRF = 6400000;
    static ItemStack sugar = new ItemStack(Items.field_151102_aT, 1, 0);
    static ItemStack gunpowder = new ItemStack(Items.field_151016_H, 1, 0);
    static ItemStack blazePowder = new ItemStack(Items.field_151065_br, 1, 0);
    static ItemStack ghastTear = new ItemStack(Items.field_151073_bk, 1, 0);
    static ItemStack netherStar = new ItemStack(Items.field_151156_bN, 1, 0);
    static TMap fuels = new THashMap();
    FluidTankAdv tank = new FluidTankAdv(4000);
    FluidStack renderFluid = new FluidStack(FluidRegistry.LAVA, 1000);
    int reactantRF;
    int currentReactantRF;
    int reactantMod = 1000;

    public static void initialize() {
        int n = MathHelper.clampI((int)ThermalExpansion.config.get("block.tweak", "Dynamo.Reactant.BasePower", 80), (int)10, (int)160);
        ThermalExpansion.config.set("block.tweak", "Dynamo.Reactant.BasePower", n);
        n /= 10;
        TileDynamoBase.defaultEnergyConfig[TileDynamoReactant.TYPE] = new TileTEBase.EnergyConfig();
        TileDynamoBase.defaultEnergyConfig[TYPE].setParamsDefault(n *= 10);
        GameRegistry.registerTileEntity(TileDynamoReactant.class, (String)"thermalexpansion.DynamoReactant");
    }

    public TileDynamoReactant() {
        this.inventory = new ItemStack[1];
    }

    public static int getFuelEnergy(FluidStack fluidStack) {
        return fluidStack == null ? 0 : (Integer)fuels.get((Object)fluidStack.getFluid());
    }

    public static int getReactantEnergy(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        if (itemStack.func_77969_a(sugar)) {
            return sugarRF;
        }
        if (itemStack.func_77969_a(gunpowder)) {
            return gunpowderRF;
        }
        if (itemStack.func_77969_a(blazePowder)) {
            return blazePowderRF;
        }
        if (itemStack.func_77969_a(ghastTear)) {
            return ghastTearRF;
        }
        if (itemStack.func_77969_a(netherStar)) {
            return netherStarRF;
        }
        return 0;
    }

    public static int getReactantMod(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        return 1000;
    }

    public static boolean isValidFuel(FluidStack fluidStack) {
        return fluidStack == null ? false : fuels.containsKey((Object)fluidStack.getFluid());
    }

    public static boolean registerFuel(Fluid fluid, int n) {
        if (fluid == null || n < 10000) {
            return false;
        }
        fuels.put((Object)fluid, (Object)(n / 20));
        return true;
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected boolean canGenerate() {
        if (this.fuelRF > 0) {
            return this.reactantRF > 0 || TileDynamoReactant.getReactantEnergy(this.inventory[0]) > 0;
        }
        if (this.reactantRF > 0) {
            return this.tank.getFluidAmount() >= 50;
        }
        return this.tank.getFluidAmount() >= 50 && TileDynamoReactant.getReactantEnergy(this.inventory[0]) > 0;
    }

    @Override
    protected void generate() {
        int n;
        if (this.fuelRF <= 0) {
            this.fuelRF = TileDynamoReactant.getFuelEnergy(this.tank.getFluid()) * this.reactantMod / 1000 * this.fuelMod / 1000;
            this.tank.drain(50, true);
        }
        if (this.reactantRF <= 0) {
            n = TileDynamoReactant.getReactantEnergy(this.inventory[0]) * this.fuelMod / 1000;
            this.reactantMod = TileDynamoReactant.getReactantMod(this.inventory[0]);
            this.reactantRF += n;
            this.currentReactantRF = n;
            this.inventory[0] = ItemHelper.consumeItem((ItemStack)this.inventory[0]);
        }
        n = this.calcEnergy() * this.energyMod;
        this.energyStorage.modifyEnergyStored(n);
        this.fuelRF -= n;
        this.reactantRF -= n;
    }

    @Override
    public IIcon getActiveIcon() {
        return this.renderFluid.getFluid().getIcon();
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiDynamoReactant(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerDynamoReactant(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public int getScaledDuration(int n) {
        if (this.currentReactantRF <= 0) {
            this.currentReactantRF = sugarRF;
        }
        return this.reactantRF * n / this.currentReactantRF;
    }

    @Override
    public FluidTankAdv getTank(int n) {
        return this.tank;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.currentReactantRF = nBTTagCompound.func_74762_e("ReactMax");
        this.reactantRF = nBTTagCompound.func_74762_e("React");
        this.tank.readFromNBT(nBTTagCompound);
        if (!TileDynamoReactant.isValidFuel(this.tank.getFluid())) {
            this.tank.setFluid(null);
        }
        if (this.tank.getFluid() != null) {
            this.renderFluid = this.tank.getFluid();
        }
        if (this.currentReactantRF <= 0) {
            this.currentReactantRF = sugarRF;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("ReactMax", this.currentReactantRF);
        nBTTagCompound.func_74768_a("React", this.reactantRF);
        this.tank.writeToNBT(nBTTagCompound);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addFluidStack(this.tank.getFluid());
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        packetCoFHBase.addFluidStack(this.tank.getFluid());
        packetCoFHBase.addInt(this.reactantRF);
        packetCoFHBase.addInt(this.currentReactantRF);
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.tank.setFluid(packetCoFHBase.getFluidStack());
        this.reactantRF = packetCoFHBase.getInt();
        this.currentReactantRF = packetCoFHBase.getInt();
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        this.renderFluid = packetCoFHBase.getFluidStack();
        if (this.renderFluid == null) {
            this.renderFluid = new FluidStack(FluidRegistry.LAVA, 1000);
        }
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack == null || forgeDirection.ordinal() == this.facing && !this.augmentCoilDuct) {
            return 0;
        }
        if (TileDynamoReactant.isValidFuel(fluidStack)) {
            return this.tank.fill(fluidStack, bl);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack == null || !this.augmentCoilDuct) {
            return null;
        }
        if (TileDynamoReactant.isValidFuel(fluidStack)) {
            return this.tank.drain(fluidStack.amount, bl);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        if (!this.augmentCoilDuct) {
            return null;
        }
        return this.tank.drain(n, bl);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public int[] func_94128_d(int n) {
        return n != this.facing || this.augmentCoilDuct ? TileDynamoBase.SLOTS : TEProps.EMPTY_INVENTORY;
    }
}

