/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.light;

import cofh.block.BlockCoFHBase;
import cofh.render.IconRegistry;
import cofh.util.ColorHelper;
import cofh.util.ItemHelper;
import cofh.util.ServerHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.BlockTEBase;
import thermalexpansion.block.light.TileLight;
import thermalexpansion.block.simple.BlockFrame;
import thermalexpansion.core.TEProps;
import thermalexpansion.util.crafting.TransposerManager;
import thermalfoundation.fluid.TFFluids;

public class BlockLight
extends BlockTEBase {
    public static final String[] NAMES = new String[]{"illuminator", "lampBasic"};
    public static boolean[] enable = new boolean[Types.values().length];
    public static ItemStack illuminator;
    public static ItemStack lampBasic;

    public BlockLight() {
        super(Material.field_151592_s);
        this.func_149711_c(3.0f);
        this.func_149752_b(150.0f);
        this.func_149672_a(Block.field_149778_k);
        this.func_149663_c("thermalexpansion.light");
    }

    public TileEntity func_149915_a(World world, int n) {
        return new TileLight();
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < Types.values().length; ++i) {
            if (!enable[i]) continue;
            list.add(new ItemStack(item, 1, i));
        }
    }

    @Override
    public void func_149689_a(World world, int n, int n2, int n3, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        if (itemStack.field_77990_d != null) {
            TileLight tileLight = (TileLight)world.func_147438_o(n, n2, n3);
            tileLight.modified = true;
            tileLight.setColor(itemStack.field_77990_d.func_74762_e("Color"));
        }
        super.func_149689_a(world, n, n2, n3, entityLivingBase, itemStack);
    }

    public void onNeighborChange(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public boolean func_149727_a(World world, int n, int n2, int n3, EntityPlayer entityPlayer, int n4, float f, float f2, float f3) {
        TileLight tileLight = (TileLight)world.func_147438_o(n, n2, n3);
        if (ItemHelper.isPlayerHoldingItem((Item)Items.field_151100_aR, (EntityPlayer)entityPlayer)) {
            if (ServerHelper.isServerWorld((World)world)) {
                tileLight.setColor(ColorHelper.getDyeColor((int)entityPlayer.func_71045_bC().func_77960_j()));
                if (!entityPlayer.field_71075_bZ.field_75098_d) {
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, ItemHelper.consumeItem((ItemStack)entityPlayer.func_71045_bC()));
                }
                world.func_72908_a((double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5, "note.harp", 0.5f, 1.0f);
            }
            return true;
        }
        if (ItemHelper.isPlayerHoldingItem((Item)Items.field_151114_aO, (EntityPlayer)entityPlayer)) {
            if (ServerHelper.isServerWorld((World)world)) {
                tileLight.resetColor();
                if (!entityPlayer.field_71075_bZ.field_75098_d) {
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, ItemHelper.consumeItem((ItemStack)entityPlayer.func_71045_bC()));
                }
                world.func_72908_a((double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5, "random.orb", 0.25f, 1.0f);
            }
            return true;
        }
        return super.func_149727_a(world, n, n2, n3, entityPlayer, n4, f, f2, f3);
    }

    public boolean shouldCheckWeakPower(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        return true;
    }

    public int func_149701_w() {
        return 1;
    }

    public int func_149645_b() {
        return TEProps.renderIdLight;
    }

    public boolean canRenderInPass(int n) {
        BlockCoFHBase.renderPass = n;
        return n < 2;
    }

    public boolean isSideSolid(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        IconRegistry.addIcon((String)"Light0", (String)"thermalexpansion:light/Illuminator_Frame", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Light1", (String)"thermalexpansion:light/Lamp_Effect", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"LightEffect", (String)"thermalexpansion:light/Illuminator_Effect", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"LightHalo", (String)"thermalexpansion:light/Lamp_Halo", (IIconRegister)iIconRegister);
    }

    @Override
    public NBTTagCompound getItemStackTag(World world, int n, int n2, int n3) {
        NBTTagCompound nBTTagCompound = super.getItemStackTag(world, n, n2, n3);
        TileLight tileLight = (TileLight)world.func_147438_o(n, n2, n3);
        if (tileLight != null && tileLight.modified) {
            nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74768_a("Color", tileLight.color);
        }
        return nBTTagCompound;
    }

    public boolean initialize() {
        TileLight.initialize();
        illuminator = new ItemStack((Block)this, 1, 0);
        lampBasic = new ItemStack((Block)this, 1, 1);
        GameRegistry.registerCustomItemStack((String)"illuminator", (ItemStack)illuminator);
        GameRegistry.registerCustomItemStack((String)"lampBasic", (ItemStack)lampBasic);
        return true;
    }

    public boolean postInit() {
        if (enable[Types.ILLUMINATOR.ordinal()]) {
            TransposerManager.addTEFillRecipe(2000, BlockFrame.frameIlluminator, illuminator, new FluidStack(TFFluids.fluidGlowstone, 1000), false);
        }
        if (enable[Types.LAMP_BASIC.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(lampBasic, new Object[]{" L ", "GLG", " S ", Character.valueOf('G'), "blockGlassHardened", Character.valueOf('L'), "dustLumium", Character.valueOf('S'), "ingotSignalum"}));
        }
        return true;
    }

    static {
        String string = "block.feature";
        BlockLight.enable[Types.ILLUMINATOR.ordinal()] = ThermalExpansion.config.get(string, "Light.Illuminator", true);
        BlockLight.enable[Types.LAMP_BASIC.ordinal()] = ThermalExpansion.config.get(string, "Light.LampBasic", true);
    }

    public static enum Types {
        ILLUMINATOR,
        LAMP_BASIC;

    }
}

