/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.CoFHCore;
import cofh.util.CoreUtils;
import cofh.util.FluidHelper;
import cofh.util.ServerHelper;
import cofh.util.fluid.FluidTankAdv;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileTEBase;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.block.machine.TileMachineBase;
import thermalexpansion.gui.client.machine.GuiAccumulator;
import thermalexpansion.gui.container.ContainerTEBase;

public class TileAccumulator
extends TileMachineBase
implements IFluidHandler {
    static final int TYPE = BlockMachine.Types.ACCUMULATOR.ordinal();
    public static int genRate = 800;
    public static int transferRate = genRate / 32;
    public static boolean passiveGen = false;
    public static FluidStack genStack;
    public static FluidStack genStackSmall;
    public static FluidStack genStackSnow;
    FluidTankAdv tank = new FluidTankAdv(4000);
    int adjacentSources = -1;
    int outputTrackerFluid;
    boolean inHell;
    FluidStack outputBuffer;

    public static void initialize() {
        TileMachineBase.defaultSideConfig[TileAccumulator.TYPE] = new TileTEBase.SideConfig();
        TileMachineBase.defaultSideConfig[TileAccumulator.TYPE].numGroup = 2;
        TileMachineBase.defaultSideConfig[TileAccumulator.TYPE].slotGroups = new int[][]{new int[0], new int[0]};
        TileMachineBase.defaultSideConfig[TileAccumulator.TYPE].allowInsertion = new boolean[]{false, false};
        TileMachineBase.defaultSideConfig[TileAccumulator.TYPE].allowExtraction = new boolean[]{false, false};
        TileMachineBase.defaultSideConfig[TileAccumulator.TYPE].sideTex = new int[]{0, 4};
        TileMachineBase.defaultSideConfig[TileAccumulator.TYPE].defaultSides = new byte[]{1, 1, 1, 1, 1, 1};
        TileMachineBase.defaultEnergyConfig[TileAccumulator.TYPE] = new TileTEBase.EnergyConfig();
        TileMachineBase.defaultEnergyConfig[TYPE].setParamsPower(0);
        TileMachineBase.sounds[TileAccumulator.TYPE] = CoreUtils.getSoundName((String)"ThermalExpansion", (String)"blockMachineAccumulator");
        TileMachineBase.enableSound[TileAccumulator.TYPE] = CoFHCore.configClient.get("sound", "Machine.Accumulator", true);
        GameRegistry.registerTileEntity(TileAccumulator.class, (String)"thermalexpansion.Accumulator");
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.updateAdjacentSources();
    }

    @Override
    public void func_145845_h() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        boolean bl = this.isActive;
        this.transferFluid();
        if (this.isActive) {
            if (this.timeCheck()) {
                if (this.adjacentSources >= 2) {
                    this.tank.fill(genStack, true);
                } else if (((TileEntity)this).field_145850_b.func_72896_J() && ((TileEntity)this).field_145850_b.func_72937_j(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e)) {
                    this.tank.fill(genStack, true);
                } else if (passiveGen) {
                    this.tank.fill(genStackSmall, true);
                }
            }
            if (!this.redstoneControlOrDisable()) {
                this.isActive = false;
                this.wasActive = true;
                this.tracker.markTime(((TileEntity)this).field_145850_b);
            }
        } else if (this.redstoneControlOrDisable() && this.canStart()) {
            this.isActive = true;
        }
        if (this.adjacentSources < 0) {
            this.updateAdjacentSources();
        }
        this.updateIfChanged(bl);
    }

    @Override
    protected boolean canStart() {
        return !this.inHell;
    }

    protected void updateAdjacentSources() {
        this.inHell = ((TileEntity)this).field_145850_b.func_72807_a(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145849_e) == BiomeGenBase.field_76778_j;
        this.adjacentSources = 0;
        Block block = ((TileEntity)this).field_145850_b.func_147439_a(((TileEntity)this).field_145851_c - 1, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        int n = ((TileEntity)this).field_145850_b.func_72805_g(((TileEntity)this).field_145851_c - 1, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        if (n == 0 && (block == Blocks.field_150355_j || block == Blocks.field_150358_i)) {
            ++this.adjacentSources;
        }
        block = ((TileEntity)this).field_145850_b.func_147439_a(((TileEntity)this).field_145851_c + 1, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        n = ((TileEntity)this).field_145850_b.func_72805_g(((TileEntity)this).field_145851_c + 1, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        if (n == 0 && (block == Blocks.field_150355_j || block == Blocks.field_150358_i)) {
            ++this.adjacentSources;
        }
        block = ((TileEntity)this).field_145850_b.func_147439_a(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e - 1);
        n = ((TileEntity)this).field_145850_b.func_72805_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e - 1);
        if (n == 0 && (block == Blocks.field_150355_j || block == Blocks.field_150358_i)) {
            ++this.adjacentSources;
        }
        block = ((TileEntity)this).field_145850_b.func_147439_a(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e + 1);
        n = ((TileEntity)this).field_145850_b.func_72805_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e + 1);
        if (n == 0 && (block == Blocks.field_150355_j || block == Blocks.field_150358_i)) {
            ++this.adjacentSources;
        }
        if ((block = ((TileEntity)this).field_145850_b.func_147439_a(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d + 1, ((TileEntity)this).field_145849_e)) == Blocks.field_150433_aE) {
            ((TileEntity)this).field_145850_b.func_147468_f(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d + 1, ((TileEntity)this).field_145849_e);
            this.tank.fill(genStackSnow, true);
        }
    }

    protected void transferFluid() {
        if (!this.augmentAutoTransfer) {
            return;
        }
        if (this.tank.getFluidAmount() <= 0) {
            return;
        }
        this.outputBuffer = new FluidStack(this.tank.getFluid(), Math.min(this.tank.getFluidAmount(), 500));
        for (int i = this.outputTrackerFluid + 1; i <= this.outputTrackerFluid + 6; ++i) {
            int n;
            int n2 = i % 6;
            if (this.sideCache[n2] != 1 || (n = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (int)n2, (FluidStack)this.outputBuffer, (boolean)true)) <= 0) continue;
            this.tank.drain(n, true);
            this.outputTrackerFluid = n2;
            break;
        }
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiAccumulator(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerTEBase(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public void receiveGuiNetworkData(int n, int n2) {
        switch (n) {
            case 0: {
                this.adjacentSources = n2;
                return;
            }
            case 1: {
                if (this.tank.getFluid() == null) {
                    this.tank.setFluid(new FluidStack(FluidRegistry.WATER, n2));
                } else {
                    this.tank.getFluid().amount = n2;
                }
                return;
            }
        }
    }

    @Override
    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        super.sendGuiNetworkData(container, iCrafting);
        iCrafting.func_71112_a(container, 0, this.adjacentSources);
        iCrafting.func_71112_a(container, 1, this.tank.getFluidAmount());
    }

    @Override
    public FluidTankAdv getTank() {
        return this.tank;
    }

    @Override
    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.inHell = nBTTagCompound.func_74767_n("Hell");
        this.adjacentSources = nBTTagCompound.func_74762_e("Sources");
        this.outputTrackerFluid = nBTTagCompound.func_74762_e("Tracker");
        this.tank.readFromNBT(nBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74757_a("Hell", this.inHell);
        nBTTagCompound.func_74768_a("Sources", this.adjacentSources);
        nBTTagCompound.func_74768_a("Tracker", this.outputTrackerFluid);
        this.tank.writeToNBT(nBTTagCompound);
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (forgeDirection != ForgeDirection.UNKNOWN && this.sideCache[forgeDirection.ordinal()] != 2) {
            return null;
        }
        if (fluidStack == null || fluidStack.getFluid() != FluidRegistry.WATER) {
            return null;
        }
        return this.tank.drain(fluidStack.amount, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        if (forgeDirection != ForgeDirection.UNKNOWN && this.sideCache[forgeDirection.ordinal()] != 2) {
            return null;
        }
        return this.tank.drain(n, bl);
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    static {
        genStackSmall = new FluidStack(FluidRegistry.WATER, 1);
        genStackSnow = new FluidStack(FluidRegistry.WATER, 125);
        int n = ThermalExpansion.config.get("tweak", "Accumulator.Rate", genRate / 32);
        if (n > 0 && n <= 50) {
            genRate = n * 32;
            transferRate = n;
        } else {
            ThermalExpansion.log.info("'Accumulator.Rate' config value is out of acceptable range. Using default. (25)");
        }
        genStack = new FluidStack(FluidRegistry.WATER, genRate);
        ThermalExpansion.config.removeProperty("tweak", "Accumulator.PassiveGen");
        passiveGen = ThermalExpansion.config.get("tweak", "Accumulator.PassiveGen", false);
    }
}

