/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.network.PacketCoFHBase;
import cofh.util.InventoryHelper;
import cofh.util.ItemHelper;
import cofh.util.MathHelper;
import cofh.util.ServerHelper;
import cofh.util.fluid.FluidTankAdv;
import cofh.util.inventory.InventoryCraftingFalse;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileTEBase;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.block.machine.TileMachineBase;
import thermalexpansion.gui.client.machine.GuiAssembler;
import thermalexpansion.gui.container.machine.ContainerAssembler;
import thermalexpansion.util.SchematicHelper;

public class TileAssembler
extends TileMachineBase
implements IFluidHandler {
    static final int TYPE = BlockMachine.Types.ASSEMBLER.ordinal();
    public static final int PROCESS_ENERGY = 20;
    private boolean needsCache = true;
    private boolean needsCraft = false;
    int outputTracker;
    FluidTankAdv tank = new FluidTankAdv(10000);
    InventoryCrafting crafting = new InventoryCraftingFalse(3, 3);
    ItemStack recipeOutput;
    FluidStack[] filledContainer = new FluidStack[9];
    ItemStack[] recipeSlot = new ItemStack[9];
    String[] recipeOre = new String[9];

    public static void initialize() {
        TileMachineBase.defaultSideConfig[TileAssembler.TYPE] = new TileTEBase.SideConfig();
        TileMachineBase.defaultSideConfig[TileAssembler.TYPE].numGroup = 5;
        TileMachineBase.defaultSideConfig[TileAssembler.TYPE].slotGroups = new int[][]{new int[0], {3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20}, {1}, {3, 4, 5, 6, 7, 8, 9, 10, 11}, {12, 13, 14, 15, 16, 17, 18, 19, 20}};
        TileMachineBase.defaultSideConfig[TileAssembler.TYPE].allowInsertion = new boolean[]{false, true, false, true, true};
        TileMachineBase.defaultSideConfig[TileAssembler.TYPE].allowExtraction = new boolean[]{false, true, true, true, true};
        TileMachineBase.defaultSideConfig[TileAssembler.TYPE].sideTex = new int[]{0, 1, 4, 5, 6};
        TileMachineBase.defaultSideConfig[TileAssembler.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        int n = MathHelper.clampI((int)ThermalExpansion.config.get("block.tweak", "Machine.Assembler.BasePower", 20), (int)10, (int)500);
        ThermalExpansion.config.set("block.tweak", "Machine.Assembler.BasePower", n);
        TileMachineBase.defaultEnergyConfig[TileAssembler.TYPE] = new TileTEBase.EnergyConfig();
        TileMachineBase.defaultEnergyConfig[TYPE].setParamsPower(n);
        GameRegistry.registerTileEntity(TileAssembler.class, (String)"thermalexpansion.Assembler");
    }

    public TileAssembler() {
        this.inventory = new ItemStack[21];
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public void func_145845_h() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        boolean bl = this.isActive;
        if (this.redstoneControlOrDisable()) {
            if (this.needsCraft) {
                this.updateOutput();
            }
            if (this.timeCheck()) {
                this.transferProducts();
            }
        } else {
            if (this.isActive) {
                this.wasActive = true;
            }
            this.isActive = false;
        }
        this.updateIfChanged(bl);
        this.chargeEnergy();
    }

    @Override
    protected void transferProducts() {
        if (!this.augmentAutoTransfer) {
            return;
        }
        if (this.inventory[1] == null) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int n = i % 6;
            if (this.sideCache[n] != 2 || !this.transferItem(1, 64, n)) continue;
            this.outputTracker = n;
            break;
        }
    }

    @Override
    public int getChargeSlot() {
        return 2;
    }

    public boolean canCreate(ItemStack itemStack) {
        return itemStack != null && (this.inventory[1] == null || itemStack.func_77969_a(this.inventory[1]) && this.inventory[1].field_77994_a + itemStack.field_77994_a <= itemStack.func_77976_d());
    }

    public boolean createItem() {
        if (this.energyStorage.getEnergyStored() < 20) {
            return false;
        }
        ItemStack[] itemStackArray = InventoryHelper.cloneInventory((ItemStack[])this.inventory);
        FluidStack fluidStack = null;
        if (this.tank.getFluid() != null) {
            fluidStack = this.tank.getFluid().copy();
        }
        boolean bl = false;
        for (int i = 0; i < 9; ++i) {
            if (fluidStack != null && fluidStack.isFluidEqual(this.filledContainer[i]) && fluidStack.amount >= this.filledContainer[i].amount) {
                fluidStack.amount -= this.filledContainer[i].amount;
                this.crafting.func_70299_a(i, this.recipeSlot[i].func_77946_l());
                continue;
            }
            if (this.recipeSlot[i] != null) {
                for (int j = 2; j < itemStackArray.length; ++j) {
                    ItemStack itemStack;
                    if (itemStackArray[j] == null || !ItemHelper.craftingEquivalent((ItemStack)itemStackArray[j], (ItemStack)this.recipeSlot[i], (String)this.recipeOre[i], (ItemStack)this.recipeOutput)) continue;
                    this.crafting.func_70299_a(i, itemStackArray[j].func_77946_l());
                    --itemStackArray[j].field_77994_a;
                    if (itemStackArray[j].func_77973_b().hasContainerItem(itemStackArray[j]) && (itemStack = itemStackArray[j].func_77973_b().getContainerItem(itemStackArray[j])) != null) {
                        if (itemStack.func_77984_f() && itemStack.func_77960_j() > itemStack.func_77958_k()) {
                            itemStack = null;
                        }
                        if (!(itemStack == null || itemStackArray[j].func_77973_b().func_77630_h(itemStackArray[j]) && InventoryHelper.addItemStackToInventory((ItemStack[])itemStackArray, (ItemStack)itemStack, (int)3))) {
                            if (itemStackArray[j].field_77994_a <= 0) {
                                itemStackArray[j] = itemStack;
                                if (itemStack.field_77994_a <= 0) {
                                    itemStackArray[j].field_77994_a = 1;
                                }
                            } else {
                                return false;
                            }
                        }
                    }
                    if (itemStackArray[j].field_77994_a <= 0) {
                        itemStackArray[j] = null;
                    }
                    bl = true;
                    break;
                }
                if (!bl) {
                    return false;
                }
                bl = false;
                continue;
            }
            this.crafting.func_70299_a(i, null);
        }
        this.inventory = itemStackArray;
        if (fluidStack == null || fluidStack.amount <= 0) {
            fluidStack = null;
        }
        this.tank.setFluid(fluidStack);
        this.energyStorage.modifyEnergyStored(-20);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateOutput() {
        if (this.inventory[0] == null) return;
        if (this.needsCache) {
            this.recipeOutput = SchematicHelper.getOutput(this.inventory[0], ((TileEntity)this).field_145850_b);
            for (int i = 0; i < 9; ++i) {
                this.recipeSlot[i] = SchematicHelper.getSchematicSlot(this.inventory[0], i);
                this.filledContainer[i] = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.recipeSlot[i]);
                this.recipeOre[i] = SchematicHelper.getSchematicOreSlot(this.inventory[0], i);
            }
            this.needsCache = false;
        }
        if (this.recipeOutput == null) {
            this.isActive = false;
            return;
        }
        if (this.canCreate(this.recipeOutput)) {
            if (this.createItem()) {
                this.recipeOutput = ItemHelper.findMatchingRecipe((InventoryCrafting)this.crafting, (World)((TileEntity)this).field_145850_b);
                if (this.recipeOutput == null) return;
                if (this.inventory[1] == null) {
                    this.inventory[1] = this.recipeOutput.func_77946_l();
                } else {
                    this.inventory[1].field_77994_a += this.recipeOutput.field_77994_a;
                }
                this.isActive = true;
                return;
            }
            if (this.energyStorage.getEnergyStored() >= 20) {
                this.needsCraft = false;
            }
            this.wasActive = true;
            this.isActive = false;
            return;
        }
        if (this.isActive) {
            this.wasActive = true;
        }
        this.isActive = false;
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiAssembler(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerAssembler(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public FluidTankAdv getTank() {
        return this.tank;
    }

    @Override
    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.outputTracker = nBTTagCompound.func_74762_e("Output");
        this.needsCraft = true;
        this.needsCache = true;
        this.tank.readFromNBT(nBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("Output", this.outputTracker);
        this.tank.writeToNBT(nBTTagCompound);
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        packetCoFHBase.addFluidStack(this.getTankFluid());
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.tank.setFluid(packetCoFHBase.getFluidStack());
    }

    @Override
    public void func_70296_d() {
        this.needsCraft = true;
        super.func_70296_d();
    }

    @Override
    public ItemStack func_70298_a(int n, int n2) {
        this.needsCraft = true;
        this.needsCache = this.needsCache ? true : n == 0;
        return super.func_70298_a(n, n2);
    }

    @Override
    public void func_70299_a(int n, ItemStack itemStack) {
        this.needsCraft = true;
        this.needsCache = this.needsCache ? true : n == 0;
        this.inventory[n] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (forgeDirection == ForgeDirection.UNKNOWN || !this.sideConfig.allowInsertion[this.sideCache[forgeDirection.ordinal()]]) {
            return 0;
        }
        int n = this.tank.fill(fluidStack, bl);
        if (bl && n > 0) {
            this.needsCraft = true;
        }
        return n;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (forgeDirection == ForgeDirection.UNKNOWN || !this.sideConfig.allowExtraction[this.sideCache[forgeDirection.ordinal()]]) {
            return null;
        }
        if (fluidStack == null || !fluidStack.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.tank.drain(fluidStack.amount, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        if (forgeDirection == ForgeDirection.UNKNOWN || !this.sideConfig.allowExtraction[this.sideCache[forgeDirection.ordinal()]]) {
            return null;
        }
        return this.tank.drain(n, bl);
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }
}

