/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.CoFHCore;
import cofh.network.PacketCoFHBase;
import cofh.render.IconRegistry;
import cofh.render.RenderHelper;
import cofh.util.CoreUtils;
import cofh.util.FluidHelper;
import cofh.util.MathHelper;
import cofh.util.ServerHelper;
import cofh.util.fluid.FluidTankAdv;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileTEBase;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.block.machine.TileMachineBase;
import thermalexpansion.core.TEProps;
import thermalexpansion.gui.client.machine.GuiCrucible;
import thermalexpansion.gui.container.machine.ContainerCrucible;
import thermalexpansion.util.crafting.CrucibleManager;

public class TileCrucible
extends TileMachineBase
implements IFluidHandler {
    static final int TYPE = BlockMachine.Types.CRUCIBLE.ordinal();
    int outputTrackerFluid;
    FluidTankAdv tank = new FluidTankAdv(10000);
    FluidStack outputBuffer;
    FluidStack renderFluid = new FluidStack(FluidRegistry.LAVA, 0);

    public static void initialize() {
        TileMachineBase.defaultSideConfig[TileCrucible.TYPE] = new TileTEBase.SideConfig();
        TileMachineBase.defaultSideConfig[TileCrucible.TYPE].numGroup = 3;
        TileMachineBase.defaultSideConfig[TileCrucible.TYPE].slotGroups = new int[][]{new int[0], {0}, new int[0]};
        TileMachineBase.defaultSideConfig[TileCrucible.TYPE].allowInsertion = new boolean[]{false, true, false};
        TileMachineBase.defaultSideConfig[TileCrucible.TYPE].allowExtraction = new boolean[]{false, true, false};
        TileMachineBase.defaultSideConfig[TileCrucible.TYPE].sideTex = new int[]{0, 1, 4};
        TileMachineBase.defaultSideConfig[TileCrucible.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        int n = MathHelper.clampI((int)ThermalExpansion.config.get("block.tweak", "Machine.Crucible.BasePower", 400), (int)100, (int)500);
        ThermalExpansion.config.set("block.tweak", "Machine.Crucible.BasePower", n);
        TileMachineBase.defaultEnergyConfig[TileCrucible.TYPE] = new TileTEBase.EnergyConfig();
        TileMachineBase.defaultEnergyConfig[TYPE].setParams(n / 10, n, Math.max(480000, n * 1200));
        TileMachineBase.sounds[TileCrucible.TYPE] = CoreUtils.getSoundName((String)"ThermalExpansion", (String)"blockMachineCrucible");
        TileMachineBase.enableSound[TileCrucible.TYPE] = CoFHCore.configClient.get("sound", "Machine.Crucible", true);
        GameRegistry.registerTileEntity(TileCrucible.class, (String)"thermalexpansion.Crucible");
    }

    public TileCrucible() {
        this.inventory = new ItemStack[2];
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected boolean canStart() {
        if (this.inventory[0] == null) {
            return false;
        }
        CrucibleManager.RecipeCrucible recipeCrucible = CrucibleManager.getRecipe(this.inventory[0]);
        if (recipeCrucible == null || this.energyStorage.getEnergyStored() < recipeCrucible.getEnergy() * this.energyMod / this.processMod) {
            return false;
        }
        if (this.inventory[0].field_77994_a < recipeCrucible.getInput().field_77994_a) {
            return false;
        }
        FluidStack fluidStack = recipeCrucible.getOutput();
        return this.tank.fill(fluidStack, false) == fluidStack.amount;
    }

    @Override
    protected boolean hasValidInput() {
        CrucibleManager.RecipeCrucible recipeCrucible = CrucibleManager.getRecipe(this.inventory[0]);
        return recipeCrucible == null ? false : recipeCrucible.getInput().field_77994_a <= this.inventory[0].field_77994_a;
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = CrucibleManager.getRecipe(this.inventory[0]).getEnergy();
        int n = this.renderFluid.fluidID;
        this.renderFluid = CrucibleManager.getRecipe(this.inventory[0]).getOutput();
        this.renderFluid.amount = 0;
        if (n != this.renderFluid.fluidID) {
            this.sendFluidPacket();
        }
    }

    @Override
    protected void processFinish() {
        this.tank.fill(CrucibleManager.getRecipe(this.inventory[0]).getOutput(), true);
        --this.inventory[0].field_77994_a;
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
    }

    protected void transferFluid() {
        if (!this.augmentAutoTransfer) {
            return;
        }
        if (this.tank.getFluidAmount() <= 0) {
            return;
        }
        this.outputBuffer = new FluidStack(this.tank.getFluid(), Math.min(this.tank.getFluidAmount(), 500));
        for (int i = this.outputTrackerFluid + 1; i <= this.outputTrackerFluid + 6; ++i) {
            int n;
            int n2 = i % 6;
            if (this.sideCache[n2] != 2 || (n = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (int)n2, (FluidStack)this.outputBuffer, (boolean)true)) <= 0) continue;
            this.tank.drain(n, true);
            this.outputTrackerFluid = n2;
            break;
        }
    }

    @Override
    public void func_145845_h() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        this.transferFluid();
        super.func_145845_h();
    }

    @Override
    public boolean isItemValid(ItemStack itemStack, int n, int n2) {
        return n == 0 ? CrucibleManager.recipeExists(itemStack) : true;
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiCrucible(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerCrucible(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public FluidTankAdv getTank() {
        return this.tank;
    }

    @Override
    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.outputTrackerFluid = nBTTagCompound.func_74762_e("Tracker");
        this.tank.readFromNBT(nBTTagCompound);
        if (this.tank.getFluid() != null) {
            this.renderFluid = this.tank.getFluid();
        } else if (CrucibleManager.getRecipe(this.inventory[0]) != null) {
            this.renderFluid = CrucibleManager.getRecipe(this.inventory[0]).getOutput();
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("Tracker", this.outputTrackerFluid);
        this.tank.writeToNBT(nBTTagCompound);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addFluidStack(this.renderFluid);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        if (this.tank.getFluid() == null) {
            packetCoFHBase.addFluidStack(this.renderFluid);
        } else {
            packetCoFHBase.addFluidStack(this.tank.getFluid());
        }
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getFluidPacket() {
        PacketCoFHBase packetCoFHBase = super.getFluidPacket();
        packetCoFHBase.addFluidStack(this.renderFluid);
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.tank.setFluid(packetCoFHBase.getFluidStack());
    }

    @Override
    protected void handleFluidPacket(PacketCoFHBase packetCoFHBase) {
        super.handleFluidPacket(packetCoFHBase);
        this.renderFluid = packetCoFHBase.getFluidStack();
        ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        if (!bl) {
            this.renderFluid = packetCoFHBase.getFluidStack();
        } else {
            packetCoFHBase.getFluidStack();
        }
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (forgeDirection == ForgeDirection.UNKNOWN || this.sideCache[forgeDirection.ordinal()] != 2) {
            return null;
        }
        if (fluidStack == null || !fluidStack.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.tank.drain(fluidStack.amount, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        if (forgeDirection != ForgeDirection.UNKNOWN && this.sideCache[forgeDirection.ordinal()] != 2) {
            return null;
        }
        return this.tank.drain(n, bl);
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public IIcon getTexture(int n, int n2) {
        if (n2 == 0) {
            if (n == 0) {
                return IconRegistry.getIcon((String)"MachineBottom");
            }
            if (n == 1) {
                return IconRegistry.getIcon((String)"MachineTop");
            }
            return n != this.facing ? IconRegistry.getIcon((String)"MachineSide") : (this.isActive ? RenderHelper.getFluidTexture((FluidStack)this.renderFluid) : IconRegistry.getIcon((String)"MachineFace", (int)this.getType()));
        }
        return n != this.facing ? IconRegistry.getIcon((String)TEProps.textureSelection, (int)this.sideConfig.sideTex[this.sideCache[n]]) : (this.isActive ? IconRegistry.getIcon((String)"MachineActive", (int)this.getType()) : IconRegistry.getIcon((String)"MachineFace", (int)this.getType()));
    }
}

