/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.CoFHCore;
import cofh.util.CoreUtils;
import cofh.util.MathHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileTEBase;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.block.machine.TileMachineBase;
import thermalexpansion.gui.client.machine.GuiPulverizer;
import thermalexpansion.gui.container.machine.ContainerPulverizer;
import thermalexpansion.util.crafting.PulverizerManager;

public class TilePulverizer
extends TileMachineBase {
    static final int TYPE = BlockMachine.Types.PULVERIZER.ordinal();
    int outputTrackerPrimary;
    int outputTrackerSecondary;

    public static void initialize() {
        TileMachineBase.defaultSideConfig[TilePulverizer.TYPE] = new TileTEBase.SideConfig();
        TileMachineBase.defaultSideConfig[TilePulverizer.TYPE].numGroup = 5;
        TileMachineBase.defaultSideConfig[TilePulverizer.TYPE].slotGroups = new int[][]{new int[0], {0}, {1, 2}, {3}, {1, 2, 3}};
        TileMachineBase.defaultSideConfig[TilePulverizer.TYPE].allowInsertion = new boolean[]{false, true, false, false, false};
        TileMachineBase.defaultSideConfig[TilePulverizer.TYPE].allowExtraction = new boolean[]{false, true, true, true, true};
        TileMachineBase.defaultSideConfig[TilePulverizer.TYPE].sideTex = new int[]{0, 1, 2, 3, 4};
        TileMachineBase.defaultSideConfig[TilePulverizer.TYPE].defaultSides = new byte[]{3, 1, 2, 2, 2, 2};
        int n = MathHelper.clampI((int)ThermalExpansion.config.get("block.tweak", "Machine.Pulverizer.BasePower", 40), (int)10, (int)500);
        ThermalExpansion.config.set("block.tweak", "Machine.Pulverizer.BasePower", n);
        TileMachineBase.defaultEnergyConfig[TilePulverizer.TYPE] = new TileTEBase.EnergyConfig();
        TileMachineBase.defaultEnergyConfig[TYPE].setParamsPower(n);
        TileMachineBase.sounds[TilePulverizer.TYPE] = CoreUtils.getSoundName((String)"ThermalExpansion", (String)"blockMachinePulverizer");
        TileMachineBase.enableSound[TilePulverizer.TYPE] = CoFHCore.configClient.get("sound", "Machine.Pulverizer", true);
        GameRegistry.registerTileEntity(TilePulverizer.class, (String)"thermalexpansion.Pulverizer");
    }

    public TilePulverizer() {
        this.inventory = new ItemStack[5];
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected boolean canStart() {
        if (this.inventory[0] == null) {
            return false;
        }
        PulverizerManager.RecipePulverizer recipePulverizer = PulverizerManager.getRecipe(this.inventory[0]);
        if (recipePulverizer == null || this.energyStorage.getEnergyStored() < recipePulverizer.getEnergy() * this.energyMod / this.processMod) {
            return false;
        }
        if (this.inventory[0].field_77994_a < recipePulverizer.getInput().field_77994_a) {
            return false;
        }
        ItemStack itemStack = recipePulverizer.getPrimaryOutput();
        ItemStack itemStack2 = recipePulverizer.getSecondaryOutput();
        if (itemStack2 != null && this.inventory[3] != null) {
            if (!this.inventory[3].func_77969_a(itemStack2)) {
                return false;
            }
            if (this.inventory[3].field_77994_a + itemStack2.field_77994_a > itemStack2.func_77976_d()) {
                return false;
            }
        }
        if (this.inventory[1] == null || this.inventory[2] == null) {
            return true;
        }
        if (!this.inventory[1].func_77969_a(itemStack) && !this.inventory[2].func_77969_a(itemStack)) {
            return false;
        }
        if (!this.inventory[1].func_77969_a(itemStack)) {
            return this.inventory[2].field_77994_a + itemStack.field_77994_a <= itemStack.func_77976_d();
        }
        if (!this.inventory[2].func_77969_a(itemStack)) {
            return this.inventory[1].field_77994_a + itemStack.field_77994_a <= itemStack.func_77976_d();
        }
        return this.inventory[1].field_77994_a + this.inventory[2].field_77994_a + itemStack.field_77994_a <= itemStack.func_77976_d() * 2;
    }

    @Override
    protected boolean hasValidInput() {
        PulverizerManager.RecipePulverizer recipePulverizer = PulverizerManager.getRecipe(this.inventory[0]);
        return recipePulverizer == null ? false : recipePulverizer.getInput().field_77994_a <= this.inventory[0].field_77994_a;
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = PulverizerManager.getRecipe(this.inventory[0]).getEnergy();
    }

    @Override
    protected void processFinish() {
        PulverizerManager.RecipePulverizer recipePulverizer = PulverizerManager.getRecipe(this.inventory[0]);
        ItemStack itemStack = recipePulverizer.getPrimaryOutput();
        ItemStack itemStack2 = recipePulverizer.getSecondaryOutput();
        if (this.inventory[1] == null) {
            this.inventory[1] = itemStack;
        } else if (this.inventory[1].func_77969_a(itemStack)) {
            int n = this.inventory[1].field_77994_a + itemStack.field_77994_a;
            if (n <= itemStack.func_77976_d()) {
                this.inventory[1].field_77994_a += itemStack.field_77994_a;
            } else {
                int n2 = itemStack.func_77976_d() - this.inventory[1].field_77994_a;
                this.inventory[1].field_77994_a += n2;
                if (this.inventory[2] == null) {
                    this.inventory[2] = itemStack;
                    this.inventory[2].field_77994_a = itemStack.field_77994_a - n2;
                } else {
                    this.inventory[2].field_77994_a += itemStack.field_77994_a - n2;
                }
            }
        } else if (this.inventory[2] == null) {
            this.inventory[2] = itemStack;
        } else {
            this.inventory[2].field_77994_a += itemStack.field_77994_a;
        }
        if (itemStack2 != null && ((TileEntity)this).field_145850_b.field_73012_v.nextInt(this.secondaryChance) < recipePulverizer.getSecondaryOutputChance()) {
            if (this.inventory[3] == null) {
                this.inventory[3] = itemStack2;
            } else {
                this.inventory[3].field_77994_a += itemStack2.field_77994_a;
            }
        }
        --this.inventory[0].field_77994_a;
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
    }

    @Override
    protected void transferProducts() {
        int n;
        int n2;
        if (!this.augmentAutoTransfer) {
            return;
        }
        if (this.inventory[1] != null || this.inventory[2] != null) {
            for (n2 = this.outputTrackerPrimary + 1; n2 <= this.outputTrackerPrimary + 6; ++n2) {
                n = n2 % 6;
                if (this.sideCache[n] != 2 && this.sideCache[n] != 4) continue;
                if (this.transferItem(1, 4, n)) {
                    if (!this.transferItem(2, 4, n)) {
                        this.transferItem(1, 4, n);
                    }
                    this.outputTrackerPrimary = n;
                    break;
                }
                if (!this.transferItem(2, 8, n)) continue;
                this.outputTrackerPrimary = n;
                break;
            }
        }
        if (this.inventory[3] == null) {
            return;
        }
        for (n2 = this.outputTrackerSecondary + 1; n2 <= this.outputTrackerSecondary + 6; ++n2) {
            n = n2 % 6;
            if (this.sideCache[n] != 3 && this.sideCache[n] != 4 || !this.transferItem(3, 4, n)) continue;
            this.outputTrackerSecondary = n;
            break;
        }
    }

    @Override
    public boolean isItemValid(ItemStack itemStack, int n, int n2) {
        return n == 0 ? PulverizerManager.recipeExists(itemStack) : true;
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiPulverizer(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerPulverizer(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.outputTrackerPrimary = nBTTagCompound.func_74762_e("Tracker1");
        this.outputTrackerSecondary = nBTTagCompound.func_74762_e("Tracker2");
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("Tracker1", this.outputTrackerPrimary);
        nBTTagCompound.func_74768_a("Tracker2", this.outputTrackerSecondary);
    }
}

