/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.gui.element;

import cofh.gui.GuiBase;
import cofh.gui.element.ElementBase;
import cofh.render.RenderHelper;
import net.minecraft.util.ResourceLocation;
import thermalexpansion.core.TEProps;

public class ElementSlotOverlay
extends ElementBase {
    public int slotColor;
    public int slotType;
    public int slotRender;

    public ElementSlotOverlay(GuiBase guiBase, int n, int n2) {
        super(guiBase, n, n2);
        this.texture = TEProps.textureGuiCommon;
    }

    public ElementSlotOverlay setSlotInfo(int n, int n2, int n3) {
        this.slotColor = n;
        this.slotType = n2;
        this.slotRender = n3;
        return this;
    }

    public ElementSlotOverlay setSlotColor(int n) {
        this.slotColor = n;
        return this;
    }

    public ElementSlotOverlay setSlotRender(int n) {
        this.slotRender = n;
        return this;
    }

    public void drawBackground(int n, int n2, float f) {
        if (!this.isVisible()) {
            return;
        }
        RenderHelper.bindTexture((ResourceLocation)this.texture);
        if (TEProps.enableGuiBorders) {
            this.drawSlotWithBorder(this.posX, this.posY);
        } else {
            this.drawSlotNoBorder(this.posX, this.posY);
        }
    }

    public void drawForeground(int n, int n2) {
    }

    public boolean intersectsWith(int n, int n2) {
        return false;
    }

    protected void drawSlotNoBorder(int n, int n2) {
        this.sizeX = 0;
        this.sizeY = 0;
        int n3 = this.slotColor / 3 * 128;
        int n4 = this.slotColor % 3 * 32;
        switch (this.slotType) {
            case 0: {
                this.sizeX = 16;
                this.sizeY = 16;
                n3 += 8;
                n4 += 8;
                break;
            }
            case 1: {
                this.sizeX = 24;
                this.sizeY = 24;
                n3 += 36;
                n4 += 4;
                break;
            }
            case 2: {
                this.sizeX = 42;
                this.sizeY = 24;
                n3 += 75;
                n4 += 4;
                break;
            }
            case 3: {
                this.sizeX = 16;
                this.sizeY = 60;
                n3 = this.slotColor * 32 + 8;
                n4 = 98;
            }
        }
        switch (this.slotRender) {
            case 0: {
                this.sizeY /= 2;
                break;
            }
            case 1: {
                this.sizeY /= 2;
                n2 += this.sizeY;
                n4 += this.sizeY;
                break;
            }
        }
        this.gui.func_73729_b(n, n2, n3, n4, this.sizeX, this.sizeY);
    }

    protected void drawSlotWithBorder(int n, int n2) {
        int n3 = 32;
        int n4 = 32;
        int n5 = this.slotColor / 3 * 128;
        int n6 = this.slotColor % 3 * 32;
        n5 += this.slotType * 32;
        switch (this.slotType) {
            case 0: {
                n -= 8;
                n2 -= 8;
                break;
            }
            case 1: {
                n -= 4;
                n2 -= 4;
                break;
            }
            case 2: {
                n3 = 64;
                n -= 11;
                n2 -= 4;
                break;
            }
            case 3: {
                n3 = 32;
                n4 = 64;
                n5 = this.slotColor * 32;
                n6 = 96;
                n -= 8;
                n2 -= 2;
            }
        }
        switch (this.slotRender) {
            case 0: {
                n4 /= 2;
                break;
            }
            case 1: {
                n2 += (n4 /= 2);
                n6 += n4;
                break;
            }
        }
        this.gui.func_73729_b(n, n2, n5, n6, n3, n4);
    }
}

