/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.gui.element;

import cofh.gui.GuiBase;
import cofh.gui.element.ElementBase;
import cofh.gui.element.TabBase;
import cofh.render.RenderHelper;
import cofh.util.StringHelper;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thermalexpansion.gui.container.ISchematicContainer;
import thermalexpansion.network.PacketTEBase;

public class TabSchematic
extends TabBase {
    public static int defaultSide = 1;
    public static ResourceLocation GRID_TEXTURE = new ResourceLocation("thermalexpansion:textures/gui/elements/Slot_Grid_Schematic.png");
    public static ResourceLocation OUTPUT_TEXTURE = new ResourceLocation("thermalexpansion:textures/gui/elements/Slot_Output_Schematic.png");
    ISchematicContainer myContainer;

    public TabSchematic(GuiBase guiBase, ISchematicContainer iSchematicContainer) {
        this(guiBase, defaultSide, iSchematicContainer);
    }

    public TabSchematic(GuiBase guiBase, int n, ISchematicContainer iSchematicContainer) {
        super(guiBase, n);
        this.myContainer = iSchematicContainer;
        this.maxHeight = 92;
        this.maxWidth = 112;
        this.backgroundColor = 0x2020B0;
        for (int i = 0; i < this.myContainer.getCraftingSlots().length; ++i) {
            this.myContainer.getCraftingSlots()[i].field_75223_e = -guiBase.getGuiLeft() - 16;
            this.myContainer.getCraftingSlots()[i].field_75221_f = -guiBase.getGuiTop() - 16;
        }
        this.myContainer.getResultSlot().field_75223_e = -guiBase.getGuiLeft() - 16;
        this.myContainer.getResultSlot().field_75221_f = -guiBase.getGuiTop() - 16;
    }

    public void draw() {
        this.drawBackground();
        this.drawTabIcon("IconSchematic");
        if (!this.isFullyOpened()) {
            return;
        }
        this.getFontRenderer().func_78261_a(StringHelper.localize((String)"item.thermalexpansion.diagram.schematic.name"), this.posXOffset() + 18, ((ElementBase)this).posY + 6, this.headerColor);
        if (this.myContainer.canWriteSchematic()) {
            ((ElementBase)this).gui.drawButton("IconAccept", this.posX() + 77, ((ElementBase)this).posY + 60, 1, 0);
        } else {
            ((ElementBase)this).gui.drawButton("IconAcceptInactive", this.posX() + 77, ((ElementBase)this).posY + 60, 1, 2);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void addTooltip(List<String> list) {
        if (!this.isFullyOpened()) {
            list.add(StringHelper.localize((String)"item.thermalexpansion.diagram.schematic"));
        }
    }

    public boolean onMousePressed(int n, int n2, int n3) {
        if (!this.isFullyOpened()) {
            return false;
        }
        if (this.side == TabBase.LEFT) {
            n += this.currentWidth;
        }
        if ((n -= this.currentShiftX) < 8 || n >= 102 || (n2 -= this.currentShiftY) < 20 || n2 >= 84) {
            return false;
        }
        if (77 < n && n < 93 && 60 < n2 && n2 < 76) {
            if (this.myContainer.canWriteSchematic()) {
                this.writeSchematic();
            }
        } else {
            ((ElementBase)this).gui.mouseClicked(1);
        }
        return true;
    }

    protected void drawBackground() {
        super.drawBackground();
        if (!this.isFullyOpened()) {
            return;
        }
        float f = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f * 0.6f;
        float f2 = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f * 0.6f;
        float f3 = (float)(this.backgroundColor & 0xFF) / 255.0f * 0.6f;
        GL11.glColor4f((float)f, (float)f2, (float)f3, (float)1.0f);
        ((ElementBase)this).gui.func_73729_b(this.posX() + 8, ((ElementBase)this).posY + 20, 16, 20, 94, 64);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.bindTexture((ResourceLocation)GRID_TEXTURE);
        ((ElementBase)this).gui.drawSizedTexturedModalRect(this.posX() + 8, ((ElementBase)this).posY + 20, 0, 0, 64, 64, 64.0f, 64.0f);
        RenderHelper.bindTexture((ResourceLocation)OUTPUT_TEXTURE);
        ((ElementBase)this).gui.drawSizedTexturedModalRect(this.posX() + 72, ((ElementBase)this).posY + 25, 0, 0, 26, 26, 26.0f, 26.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void setFullyOpen() {
        super.setFullyOpen();
        for (int i = 0; i < this.myContainer.getCraftingSlots().length; ++i) {
            this.myContainer.getCraftingSlots()[i].field_75223_e = this.posX() + 14 + 18 * (i % 3);
            this.myContainer.getCraftingSlots()[i].field_75221_f = ((ElementBase)this).posY + 26 + 18 * (i / 3);
        }
        this.myContainer.getResultSlot().field_75223_e = this.posX() + 77;
        this.myContainer.getResultSlot().field_75221_f = ((ElementBase)this).posY + 30;
    }

    public void toggleOpen() {
        if (this.open) {
            for (int i = 0; i < this.myContainer.getCraftingSlots().length; ++i) {
                this.myContainer.getCraftingSlots()[i].field_75223_e = -((ElementBase)this).gui.getGuiLeft() - 16;
                this.myContainer.getCraftingSlots()[i].field_75221_f = -((ElementBase)this).gui.getGuiTop() - 16;
            }
            this.myContainer.getResultSlot().field_75223_e = -((ElementBase)this).gui.getGuiLeft() - 16;
            this.myContainer.getResultSlot().field_75221_f = -((ElementBase)this).gui.getGuiTop() - 16;
        }
        super.toggleOpen();
    }

    private boolean writeSchematic() {
        if (this.myContainer.canWriteSchematic()) {
            PacketTEBase.sendTabSchematicPacketToServer();
            this.myContainer.writeSchematic();
            return true;
        }
        return false;
    }
}

