/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.item;

import cofh.api.energy.IEnergyContainerItem;
import cofh.item.ItemBase;
import cofh.util.CoreUtils;
import cofh.util.EnergyHelper;
import cofh.util.ItemHelper;
import cofh.util.StringHelper;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thermalexpansion.ThermalExpansion;

public class ItemCapacitor
extends ItemBase
implements IEnergyContainerItem {
    public static final String[] NAMES = new String[]{"creative", "potato", "basic", "hardened", "reinforced", "resonant"};
    public static final int[] SEND = new int[]{10000, 80, 80, 400, 2000, 10000};
    public static final int[] RECEIVE = new int[]{0, 0, 80, 400, 2000, 10000};
    public static final int[] STORAGE = new int[]{10000, 16000, 80000, 400000, 2000000, 10000000};

    public ItemCapacitor() {
        super("thermalexpansion");
        this.func_77656_e(1);
        this.func_77625_d(1);
        this.func_77637_a(ThermalExpansion.tabTools);
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, Types.CREATIVE.ordinal()), (int)STORAGE[Types.CREATIVE.ordinal()]));
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, Types.POTATO.ordinal()), (int)STORAGE[Types.POTATO.ordinal()]));
        for (int i = 2; i < Types.values().length; ++i) {
            list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, i), (int)0));
            list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, i), (int)STORAGE[i]));
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        return "item.thermalexpansion.capacitor." + NAMES[ItemHelper.getItemDamage((ItemStack)itemStack)];
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean bl) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForDetails());
        }
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (ItemHelper.getItemDamage((ItemStack)itemStack) == Types.CREATIVE.ordinal()) {
            list.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.localize((String)"info.cofh.infinite"));
            list.add(StringHelper.localize((String)"info.cofh.send") + ": " + SEND[ItemHelper.getItemDamage((ItemStack)itemStack)] + " RF/t");
        } else {
            list.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.getScaledNumber((long)itemStack.field_77990_d.func_74762_e("Energy")) + " / " + StringHelper.getScaledNumber((long)STORAGE[ItemHelper.getItemDamage((ItemStack)itemStack)]) + " RF");
            list.add(StringHelper.localize((String)"info.cofh.send") + "/" + StringHelper.localize((String)"info.cofh.receive") + ": " + SEND[ItemHelper.getItemDamage((ItemStack)itemStack)] + "/" + RECEIVE[ItemHelper.getItemDamage((ItemStack)itemStack)] + " RF/t");
        }
        if (this.isActive(itemStack)) {
            list.add(StringHelper.getInfoText((String)"info.thermalexpansion.capacitor.2"));
            list.add(StringHelper.getInfoText((String)"info.thermalexpansion.capacitor.4"));
            list.add(StringHelper.getDeactivationText((String)"info.thermalexpansion.capacitor.3"));
        } else {
            list.add(StringHelper.getInfoText((String)"info.thermalexpansion.capacitor.0"));
            list.add(StringHelper.getInfoText((String)"info.thermalexpansion.capacitor.4"));
            list.add(StringHelper.getActivationText((String)"info.thermalexpansion.capacitor.1"));
        }
        if (ItemHelper.getItemDamage((ItemStack)itemStack) == Types.POTATO.ordinal()) {
            list.add(StringHelper.getFlavorText((String)"info.thermalexpansion.capacitor.potato"));
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int n, boolean bl) {
        if (n > 8 || !this.isActive(itemStack) || bl) {
            return;
        }
        InventoryPlayer inventoryPlayer = ((EntityPlayer)entity).field_71071_by;
        int n2 = Math.min(this.getEnergyStored(itemStack), SEND[ItemHelper.getItemDamage((ItemStack)itemStack)]);
        if (EnergyHelper.isEnergyContainerItem((ItemStack)inventoryPlayer.func_70448_g())) {
            IEnergyContainerItem iEnergyContainerItem = (IEnergyContainerItem)inventoryPlayer.field_70462_a[inventoryPlayer.field_70461_c].func_77973_b();
            this.extractEnergy(itemStack, iEnergyContainerItem.receiveEnergy(inventoryPlayer.field_70462_a[inventoryPlayer.field_70461_c], n2, false), false);
        }
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (CoreUtils.isFakePlayer((EntityPlayer)entityPlayer)) {
            return itemStack;
        }
        if (entityPlayer.func_70093_af() && this.setActiveState(itemStack, !this.isActive(itemStack))) {
            if (this.isActive(itemStack)) {
                entityPlayer.field_70170_p.func_72956_a((Entity)entityPlayer, "random.orb", 0.2f, 0.8f);
            } else {
                entityPlayer.field_70170_p.func_72956_a((Entity)entityPlayer, "random.orb", 0.2f, 0.5f);
            }
        }
        entityPlayer.func_71038_i();
        return itemStack;
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int n, int n2, int n3, int n4, float f, float f2, float f3) {
        return false;
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return this.isActive(itemStack);
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean func_77616_k(ItemStack itemStack) {
        return false;
    }

    public boolean isDamaged(ItemStack itemStack) {
        return ItemHelper.getItemDamage((ItemStack)itemStack) != Types.CREATIVE.ordinal();
    }

    public int getDisplayDamage(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return 1 + STORAGE[ItemHelper.getItemDamage((ItemStack)itemStack)];
        }
        return 1 + STORAGE[ItemHelper.getItemDamage((ItemStack)itemStack)] - itemStack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxDamage(ItemStack itemStack) {
        return 1 + STORAGE[ItemHelper.getItemDamage((ItemStack)itemStack)];
    }

    public int receiveEnergy(ItemStack itemStack, int n, boolean bl) {
        int n2 = ItemHelper.getItemDamage((ItemStack)itemStack);
        if (n2 <= Types.POTATO.ordinal()) {
            return 0;
        }
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        int n3 = itemStack.field_77990_d.func_74762_e("Energy");
        int n4 = Math.min(n, Math.min(STORAGE[n2] - n3, RECEIVE[n2]));
        if (!bl) {
            itemStack.field_77990_d.func_74768_a("Energy", n3 += n4);
        }
        return n4;
    }

    public int extractEnergy(ItemStack itemStack, int n, boolean bl) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        int n2 = itemStack.field_77990_d.func_74762_e("Energy");
        int n3 = Math.min(n, Math.min(n2, SEND[ItemHelper.getItemDamage((ItemStack)itemStack)]));
        if (!bl && itemStack.func_77960_j() != Types.CREATIVE.ordinal()) {
            itemStack.field_77990_d.func_74768_a("Energy", n2 -= n3);
            if (n2 == 0 && itemStack.func_77960_j() == Types.POTATO.ordinal()) {
                itemStack = new ItemStack(Items.field_151168_bH);
            }
        }
        return n3;
    }

    public int getEnergyStored(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        return itemStack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack itemStack) {
        return STORAGE[itemStack.func_77960_j()];
    }

    public boolean isActive(ItemStack itemStack) {
        return itemStack.field_77990_d == null ? false : itemStack.field_77990_d.func_74767_n("Active");
    }

    public boolean setActiveState(ItemStack itemStack, boolean bl) {
        if (this.getEnergyStored(itemStack) > 0) {
            itemStack.field_77990_d.func_74757_a("Active", bl);
            return true;
        }
        itemStack.field_77990_d.func_74757_a("Active", false);
        return false;
    }

    public static enum Types {
        CREATIVE,
        POTATO,
        BASIC,
        HARDENED,
        REINFORCED,
        RESONANT;

    }
}

