/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.item;

import cofh.api.item.IInventoryContainerItem;
import cofh.api.tileentity.ISecurable;
import cofh.core.CoFHProps;
import cofh.enchantment.CoFHEnchantment;
import cofh.item.ItemBase;
import cofh.util.CoreUtils;
import cofh.util.ItemHelper;
import cofh.util.SecurityHelper;
import cofh.util.ServerHelper;
import cofh.util.SocialRegistry;
import cofh.util.StringHelper;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import thermalexpansion.ThermalExpansion;

public class ItemSatchel
extends ItemBase
implements IInventoryContainerItem {
    public static boolean enableSecurity = true;
    IIcon[] latch = new IIcon[3];
    public static final String[] NAMES = new String[]{"creative", "basic", "hardened", "reinforced", "resonant"};

    public static ItemStack setDefaultInventoryTag(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74757_a("Accessible", true);
        return itemStack;
    }

    public static void configure() {
        String string = "Enable this to allow for Satchels to be securable. (Default: true)";
        enableSecurity = ThermalExpansion.config.get("security", "Satchel.All.Securable", enableSecurity, string);
    }

    public ItemSatchel() {
        super("thermalexpansion");
        this.func_77625_d(1);
        this.func_77637_a(ThermalExpansion.tabTools);
        this.setNoRepair();
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 1; i < Types.values().length; ++i) {
            list.add(ItemSatchel.setDefaultInventoryTag(new ItemStack(item, 1, i)));
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        return "item.thermalexpansion.satchel." + NAMES[itemStack.func_77960_j()];
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean bl) {
        SecurityHelper.addOwnerInformation((ItemStack)itemStack, (List)list);
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        SecurityHelper.addAccessInformation((ItemStack)itemStack, (List)list);
        ItemHelper.addInventoryInformation((ItemStack)itemStack, (List)list);
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (CoreUtils.isFakePlayer((EntityPlayer)entityPlayer)) {
            return itemStack;
        }
        if (SecurityHelper.isSecure((ItemStack)itemStack) && SecurityHelper.getOwnerName((ItemStack)itemStack).isEmpty()) {
            SecurityHelper.setOwnerName((ItemStack)itemStack, (String)entityPlayer.getDisplayName());
        }
        if (ServerHelper.isServerWorld((World)world)) {
            if (ItemSatchel.canPlayerAccess(itemStack, entityPlayer.getDisplayName())) {
                entityPlayer.openGui((Object)ThermalExpansion.instance, 1, world, 0, 0, 0);
            } else if (SecurityHelper.isSecure((ItemStack)itemStack)) {
                entityPlayer.func_145747_a((IChatComponent)new ChatComponentText(StringHelper.localize((String)"chat.cofh.secure1") + " " + SecurityHelper.getOwnerName((ItemStack)itemStack) + "! " + StringHelper.localize((String)"chat.cofh.secure2")));
            }
        }
        return itemStack;
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int n, int n2, int n3, int n4, float f, float f2, float f3) {
        return false;
    }

    public boolean func_77662_d() {
        return false;
    }

    public boolean func_77616_k(ItemStack itemStack) {
        return true;
    }

    public boolean func_77623_v() {
        return true;
    }

    public int func_77619_b() {
        return 10;
    }

    public IIcon getIcon(ItemStack itemStack, int n) {
        if (n == 0) {
            return super.getIcon(itemStack, n);
        }
        if (SecurityHelper.isSecure((ItemStack)itemStack)) {
            return this.latch[SecurityHelper.getAccess((ItemStack)itemStack).ordinal()];
        }
        return this.latch[0];
    }

    public void func_94581_a(IIconRegister iIconRegister) {
        super.func_94581_a(iIconRegister);
        this.latch[0] = iIconRegister.func_94245_a(this.modName + ":" + this.func_77658_a().replace("item." + this.modName + ".", "") + "/" + "LatchPublic");
        this.latch[1] = iIconRegister.func_94245_a(this.modName + ":" + this.func_77658_a().replace("item." + this.modName + ".", "") + "/" + "LatchFriends");
        this.latch[2] = iIconRegister.func_94245_a(this.modName + ":" + this.func_77658_a().replace("item." + this.modName + ".", "") + "/" + "LatchPrivate");
    }

    public static boolean canPlayerAccess(ItemStack itemStack, String string) {
        if (!SecurityHelper.isSecure((ItemStack)itemStack)) {
            return true;
        }
        ISecurable.AccessMode accessMode = SecurityHelper.getAccess((ItemStack)itemStack);
        String string2 = SecurityHelper.getOwnerName((ItemStack)itemStack);
        return accessMode.isPublic() || CoFHProps.enableOpSecureAccess && CoreUtils.isOp((String)string) || string2.equals("[None]") || string2.equals(string) || accessMode.isRestricted() && SocialRegistry.playerHasAccess((String)string, (String)string2);
    }

    public static boolean isEnchanted(ItemStack itemStack) {
        return EnchantmentHelper.func_77506_a((int)CoFHEnchantment.enchantmentHolding.field_77352_x, (ItemStack)itemStack) > 0;
    }

    public static int getStorageIndex(int n, int n2) {
        return n > 0 ? Math.min(n + n2, CoFHProps.STORAGE_SIZE.length - 1) : 0;
    }

    public static int getStorageIndex(ItemStack itemStack) {
        int n = itemStack.func_77960_j();
        int n2 = EnchantmentHelper.func_77506_a((int)CoFHEnchantment.enchantmentHolding.field_77352_x, (ItemStack)itemStack);
        return ItemSatchel.getStorageIndex(n, n2);
    }

    public int getSizeInventory(ItemStack itemStack) {
        return CoFHProps.STORAGE_SIZE[ItemSatchel.getStorageIndex(itemStack)];
    }

    public static enum Types {
        CREATIVE,
        BASIC,
        HARDENED,
        REINFORCED,
        RESONANT;

    }
}

