/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.item.tool;

import cofh.api.energy.IEnergyContainerItem;
import cofh.item.ItemBase;
import cofh.util.BlockHelper;
import cofh.util.EnergyHelper;
import cofh.util.MathHelper;
import cofh.util.ServerHelper;
import cofh.util.StringHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTNT;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thermalexpansion.ThermalExpansion;

public class ItemIgniter
extends ItemBase
implements IEnergyContainerItem {
    public int maxEnergy = 80000;
    public int maxTransfer = 160;
    public int energyPerUse = 400;
    public int range = 32;

    public ItemIgniter() {
        super("thermalexpansion");
        this.func_77656_e(1);
        this.func_77625_d(1);
        this.func_77637_a(ThermalExpansion.tabTools);
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, 0), (int)0));
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, 0), (int)this.maxEnergy));
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean bl) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        list.add(StringHelper.localize((String)"info.cofh.charge") + ": " + itemStack.field_77990_d.func_74762_e("Energy") + " / " + this.maxEnergy + " RF");
        list.add("\u00a76" + this.energyPerUse + " RF " + StringHelper.localize((String)"info.cofh.perUse") + "\u00a7r");
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        MovingObjectPosition movingObjectPosition;
        if (!entityPlayer.field_71075_bZ.field_75098_d && this.extractEnergy(itemStack, this.energyPerUse, true) != this.energyPerUse) {
            return itemStack;
        }
        MovingObjectPosition movingObjectPosition2 = movingObjectPosition = entityPlayer.func_70093_af() ? BlockHelper.getCurrentMovingObjectPosition((EntityPlayer)entityPlayer) : BlockHelper.getCurrentMovingObjectPosition((EntityPlayer)entityPlayer, (double)this.range);
        if (movingObjectPosition != null) {
            int[] nArray = BlockHelper.getAdjacentCoordinatesForSide((MovingObjectPosition)movingObjectPosition);
            world.func_72908_a((double)nArray[0] + 0.5, (double)nArray[1] + 0.5, (double)nArray[2] + 0.5, "fire.ignite", 1.0f, MathHelper.RANDOM.nextFloat() * 0.4f + 0.8f);
            if (ServerHelper.isServerWorld((World)world)) {
                Block block = world.func_147439_a(movingObjectPosition.field_72311_b, movingObjectPosition.field_72312_c, movingObjectPosition.field_72309_d);
                if (block == Blocks.field_150335_W) {
                    world.func_147468_f(movingObjectPosition.field_72311_b, movingObjectPosition.field_72312_c, movingObjectPosition.field_72309_d);
                    ((BlockTNT)block).func_150114_a(world, movingObjectPosition.field_72311_b, movingObjectPosition.field_72312_c, movingObjectPosition.field_72309_d, 1, (EntityLivingBase)entityPlayer);
                } else {
                    AxisAlignedBB axisAlignedBB = BlockHelper.getAdjacentAABBForSide((MovingObjectPosition)movingObjectPosition);
                    List list = world.func_72872_a(EntityCreeper.class, axisAlignedBB);
                    if (!list.isEmpty()) {
                        for (int i = 0; i < list.size(); ++i) {
                            ((EntityCreeper)list.get(i)).func_146079_cb();
                        }
                    } else if (world.func_147439_a(nArray[0], nArray[1], nArray[2]).isAir((IBlockAccess)world, nArray[0], nArray[1], nArray[2])) {
                        world.func_147449_b(nArray[0], nArray[1], nArray[2], (Block)Blocks.field_150480_ab);
                    }
                }
            }
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                this.extractEnergy(itemStack, this.energyPerUse, false);
            }
            entityPlayer.func_71038_i();
        }
        return itemStack;
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int n, int n2, int n3, int n4, float f, float f2, float f3) {
        entityPlayer.func_71038_i();
        return false;
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean isDamaged(ItemStack itemStack) {
        return itemStack.func_77960_j() != Short.MAX_VALUE;
    }

    public int getDisplayDamage(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        return 1 + this.maxEnergy - itemStack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxDamage(ItemStack itemStack) {
        return 1 + this.maxEnergy;
    }

    public int receiveEnergy(ItemStack itemStack, int n, boolean bl) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        int n2 = itemStack.field_77990_d.func_74762_e("Energy");
        int n3 = Math.min(n, Math.min(this.maxEnergy - n2, this.maxTransfer));
        if (!bl) {
            itemStack.field_77990_d.func_74768_a("Energy", n2 += n3);
        }
        return n3;
    }

    public int extractEnergy(ItemStack itemStack, int n, boolean bl) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        int n2 = itemStack.field_77990_d.func_74762_e("Energy");
        int n3 = Math.min(n, n2);
        if (!bl) {
            itemStack.field_77990_d.func_74768_a("Energy", n2 -= n3);
        }
        return n3;
    }

    public int getEnergyStored(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        return itemStack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack itemStack) {
        return this.maxEnergy;
    }
}

