/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.plugins;

import java.util.ArrayList;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.core.TEProps;

public class TEPlugins {
    public static ArrayList<Plugin> pluginList = new ArrayList();

    public static void preInit() {
        ThermalExpansion.log.info("Loading Plugins...");
        for (int i = 0; i < pluginList.size(); ++i) {
            pluginList.get(i).preInit();
        }
        ThermalExpansion.log.info("Finished Loading Plugins.");
    }

    public static void initialize() {
        for (int i = 0; i < pluginList.size(); ++i) {
            pluginList.get(i).initialize();
        }
    }

    public static void postInit() {
        for (int i = 0; i < pluginList.size(); ++i) {
            pluginList.get(i).postInit();
        }
    }

    public static void cleanUp() {
        pluginList.clear();
    }

    public static boolean addPlugin(String string, String string2) {
        boolean bl = ThermalExpansion.config.get("plugins", string2, true);
        ThermalExpansion.config.save();
        if (bl) {
            pluginList.add(new Plugin(string));
            return true;
        }
        return false;
    }

    static {
        TEPlugins.addPlugin("mfr.MFRPlugin", "MineFactoryReloaded");
        TEPlugins.addPlugin("tc4.TCPlugin", "Thaumcraft4");
    }

    static class Plugin {
        public Class pluginClass = null;
        public String pluginPath;

        public Plugin(String string) {
            this.pluginPath = "thermalexpansion.plugins." + string;
        }

        public void preInit() {
            block2: {
                try {
                    this.pluginClass = TEPlugins.class.getClassLoader().loadClass(this.pluginPath);
                    this.pluginClass.getMethod("preInit", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Throwable throwable) {
                    if (!TEProps.enableDebugOutput) break block2;
                    throwable.printStackTrace();
                }
            }
        }

        public void initialize() {
            block3: {
                try {
                    if (this.pluginClass != null) {
                        this.pluginClass.getMethod("initialize", new Class[0]).invoke(null, new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    if (!TEProps.enableDebugOutput) break block3;
                    throwable.printStackTrace();
                }
            }
        }

        public void postInit() {
            block3: {
                try {
                    if (this.pluginClass != null) {
                        this.pluginClass.getMethod("postInit", new Class[0]).invoke(null, new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    if (!TEProps.enableDebugOutput) break block3;
                    throwable.printStackTrace();
                }
            }
        }

        public void registerRenderInformation() {
            block3: {
                try {
                    if (this.pluginClass != null) {
                        this.pluginClass.getMethod("registerRenderInformation", new Class[0]).invoke(null, new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    if (!TEProps.enableDebugOutput) break block3;
                    throwable.printStackTrace();
                }
            }
        }
    }
}

