/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Blocks;

import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import vswe.stevescarts.Blocks.BlockContainerBase;
import vswe.stevescarts.PacketHandler;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.TileEntities.TileEntityCartAssembler;
import vswe.stevescarts.TileEntities.TileEntityUpgrade;

public class BlockCartAssembler
extends BlockContainerBase {
    private IIcon topIcon;
    private IIcon botIcon;
    private IIcon[] sideIcons;

    public BlockCartAssembler() {
        super(Material.field_151576_e);
        this.func_149647_a(StevesCarts.tabsSC2Blocks);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == 0) {
            return this.botIcon;
        }
        if (side == 1) {
            return this.topIcon;
        }
        return this.sideIcons[side - 2];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.topIcon = register.func_94245_a(StevesCarts.instance.textureHeader + ":" + "cart_assembler" + "_top");
        this.botIcon = register.func_94245_a(StevesCarts.instance.textureHeader + ":" + "cart_assembler" + "_bot");
        this.sideIcons = new IIcon[4];
        for (int i = 1; i <= 4; ++i) {
            this.sideIcons[i - 1] = register.func_94245_a(StevesCarts.instance.textureHeader + ":" + "cart_assembler" + "_side_" + i);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        if (entityplayer.func_70093_af()) {
            return false;
        }
        TileEntityCartAssembler assembler = (TileEntityCartAssembler)world.func_147438_o(x, y, z);
        if (assembler != null) {
            if (!world.field_72995_K) {
                FMLNetworkHandler.openGui((EntityPlayer)entityplayer, (Object)StevesCarts.instance, (int)3, (World)world, (int)x, (int)y, (int)z);
            }
        } else {
            return false;
        }
        return true;
    }

    public void updateMultiBlock(World world, int x, int y, int z) {
        TileEntityCartAssembler master = (TileEntityCartAssembler)world.func_147438_o(x, y, z);
        if (master != null) {
            master.clearUpgrades();
        }
        this.checkForUpgrades(world, x, y, z);
        if (!world.field_72995_K) {
            PacketHandler.sendBlockInfoToClients(world, new byte[0], x, y, z);
        }
        if (master != null) {
            master.onUpgradeUpdate();
        }
    }

    private void checkForUpgrades(World world, int x, int y, int z) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (Math.abs(i) + Math.abs(j) + Math.abs(k) != 1) continue;
                    this.checkForUpgrade(world, x + i, y + j, z + k);
                }
            }
        }
    }

    private TileEntityCartAssembler checkForUpgrade(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityUpgrade) {
            TileEntityUpgrade upgrade = (TileEntityUpgrade)tile;
            ArrayList<TileEntityCartAssembler> masters = this.getMasters(world, x, y, z);
            if (masters.size() == 1) {
                TileEntityCartAssembler master = masters.get(0);
                master.addUpgrade(upgrade);
                upgrade.setMaster(master);
                return master;
            }
            for (TileEntityCartAssembler master : masters) {
                master.removeUpgrade(upgrade);
            }
            upgrade.setMaster(null);
        }
        return null;
    }

    private ArrayList<TileEntityCartAssembler> getMasters(World world, int x, int y, int z) {
        ArrayList<TileEntityCartAssembler> masters = new ArrayList<TileEntityCartAssembler>();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    TileEntityCartAssembler temp;
                    if (Math.abs(i) + Math.abs(j) + Math.abs(k) != 1 || (temp = this.getMaster(world, x + i, y + j, z + k)) == null) continue;
                    masters.add(temp);
                }
            }
        }
        return masters;
    }

    private TileEntityCartAssembler getValidMaster(World world, int x, int y, int z) {
        TileEntityCartAssembler master = null;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    TileEntityCartAssembler temp;
                    if (Math.abs(i) + Math.abs(j) + Math.abs(k) != 1 || (temp = this.getMaster(world, x + i, y + j, z + k)) == null) continue;
                    if (master != null) {
                        return null;
                    }
                    master = temp;
                }
            }
        }
        return master;
    }

    private TileEntityCartAssembler getMaster(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityCartAssembler) {
            TileEntityCartAssembler master = (TileEntityCartAssembler)tile;
            if (!master.isDead) {
                return master;
            }
        }
        return null;
    }

    public void addUpgrade(World world, int x, int y, int z) {
        TileEntityCartAssembler master = this.getValidMaster(world, x, y, z);
        if (master != null) {
            this.updateMultiBlock(world, master.field_145851_c, master.field_145848_d, master.field_145849_e);
        }
    }

    public void removeUpgrade(World world, int x, int y, int z) {
        TileEntityCartAssembler master = this.getValidMaster(world, x, y, z);
        if (master != null) {
            this.updateMultiBlock(world, master.field_145851_c, master.field_145848_d, master.field_145849_e);
        }
    }

    public TileEntity func_149915_a(World world, int var2) {
        return new TileEntityCartAssembler();
    }

    public void func_149726_b(World world, int x, int y, int z) {
        this.updateMultiBlock(world, x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block unknown1, int unknown2) {
        TileEntityCartAssembler var7 = (TileEntityCartAssembler)world.func_147438_o(x, y, z);
        var7.isDead = true;
        this.updateMultiBlock(world, x, y, z);
        if (var7 != null) {
            for (int var8 = 0; var8 < var7.func_70302_i_(); ++var8) {
                ItemStack var9 = var7.func_70304_b(var8);
                if (var9 == null) continue;
                float var10 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float var11 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float var12 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                while (var9.field_77994_a > 0) {
                    int var13 = world.field_73012_v.nextInt(21) + 10;
                    if (var13 > var9.field_77994_a) {
                        var13 = var9.field_77994_a;
                    }
                    var9.field_77994_a -= var13;
                    EntityItem var14 = new EntityItem(world, (double)((float)x + var10), (double)((float)y + var11), (double)((float)z + var12), new ItemStack(var9.func_77973_b(), var13, var9.func_77960_j()));
                    float var15 = 0.05f;
                    var14.field_70159_w = (float)world.field_73012_v.nextGaussian() * var15;
                    var14.field_70181_x = (float)world.field_73012_v.nextGaussian() * var15 + 0.2f;
                    var14.field_70179_y = (float)world.field_73012_v.nextGaussian() * var15;
                    if (var9.func_77942_o()) {
                        var14.func_92059_d().func_77982_d((NBTTagCompound)var9.func_77978_p().func_74737_b());
                    }
                    world.func_72838_d((Entity)var14);
                }
            }
            ItemStack outputItem = var7.getOutputOnInterupt();
            if (outputItem != null) {
                EntityItem eItem = new EntityItem(world, (double)x + (double)0.2f, (double)y + (double)0.2f, (double)((float)z + 0.2f), outputItem);
                eItem.field_70159_w = (float)world.field_73012_v.nextGaussian() * 0.05f;
                eItem.field_70181_x = (float)world.field_73012_v.nextGaussian() * 0.25f;
                eItem.field_70179_y = (float)world.field_73012_v.nextGaussian() * 0.05f;
                if (outputItem.func_77942_o()) {
                    eItem.func_92059_d().func_77982_d((NBTTagCompound)outputItem.func_77978_p().func_74737_b());
                }
                world.func_72838_d((Entity)eItem);
            }
        }
        super.func_149749_a(world, x, y, z, unknown1, unknown2);
    }
}

